/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.identity.monitoring.SsoServerRealmEntry;
import com.sun.identity.monitoring.SsoServerRealmEntryMBean;
import com.sun.management.snmp.SnmpInt;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpIndex;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.agent.SnmpTableSupport;
import java.io.Serializable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class TableSsoServerRealmTable
extends SnmpTableSupport
implements Serializable {
    protected MBeanServer server;

    public TableSsoServerRealmTable(SnmpMib myMib) {
        super(myMib);
    }

    public TableSsoServerRealmTable(SnmpMib myMib, MBeanServer server) {
        this(myMib);
        this.server = server;
    }

    public void createNewEntry(SnmpMibSubRequest req, SnmpOid rowOid, int depth, SnmpMibTable meta) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(rowOid);
        Vector v = index.getComponents();
        try {
            SnmpOid oid0 = (SnmpOid)v.elementAt(0);
            ObjectName objname = null;
            if (this.server != null) {
                objname = this.buildNameFromIndex(index);
            }
            Object entry = this.createSsoServerRealmEntryMBean(req, rowOid, depth, objname, meta, oid0.toInteger());
            if (this.server != null) {
                this.server.registerMBean(entry, objname);
            }
            meta.addEntry(rowOid, objname, entry);
        }
        catch (SnmpStatusException e) {
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            throw new SnmpStatusException(e.getMessage());
        }
    }

    protected SnmpMibTable getRegisteredTableMeta(SnmpMib mib) {
        return mib.getRegisteredTableMeta("SsoServerRealmTable");
    }

    public void removeEntryCb(int pos, SnmpOid row, ObjectName name, Object entry, SnmpMibTable meta) throws SnmpStatusException {
        try {
            super.removeEntryCb(pos, row, name, entry, meta);
            if (this.server != null && name != null) {
                this.server.unregisterMBean(name);
            }
        }
        catch (Exception x) {
            // empty catch block
        }
    }

    public synchronized void addEntry(SsoServerRealmEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, (Object)entry);
    }

    public synchronized void addEntry(SsoServerRealmEntryMBean entry, ObjectName name) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, name, (Object)entry);
    }

    public synchronized SsoServerRealmEntryMBean[] getEntries() {
        Object[] array = this.getBasicEntries();
        SsoServerRealmEntryMBean[] result = new SsoServerRealmEntryMBean[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public void removeEntry(SsoServerRealmEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.removeEntry(index, (Object)entry);
    }

    public ObjectName buildNameFromIndex(SnmpIndex index) throws SnmpStatusException {
        Vector v = index.getComponents();
        try {
            SnmpOid oid = (SnmpOid)v.elementAt(0);
            String _keySsoServerRealmIndex = oid.toInteger().toString();
            return new ObjectName("TableSsoServerRealmTable:name=com.sun.identity.monitoring.SsoServerRealmEntry,SsoServerRealmIndex=" + _keySsoServerRealmIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            throw new SnmpStatusException(e.getMessage());
        }
    }

    public SnmpIndex buildSnmpIndex(SsoServerRealmEntryMBean entry) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[1];
        SnmpInt val = null;
        val = new SnmpInt(entry.getSsoServerRealmIndex());
        oids[0] = val.toOid();
        return new SnmpIndex(oids);
    }

    public SnmpOid buildOidFromIndex(SnmpIndex index) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        if (index.getNbComponents() != 1) {
            throw new SnmpStatusException(224);
        }
        try {
            Vector v = index.getComponents();
            SnmpInt.appendToOid((SnmpOid)((SnmpOid)v.elementAt(0)), (SnmpOid)oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpOid buildOidFromIndexVal(Integer aSsoServerRealmIndex) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        try {
            SnmpInt.appendToOid((SnmpOid)new SnmpInt(aSsoServerRealmIndex).toOid(), (SnmpOid)oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpIndex buildSnmpIndex(long[] index, int start) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[1];
        int pos = start;
        oids[0] = SnmpInt.toOid((long[])index, (int)pos);
        return new SnmpIndex(oids);
    }

    public Object createSsoServerRealmEntryMBean(SnmpMibSubRequest req, SnmpOid rowOid, int depth, ObjectName entryObjName, SnmpMibTable meta, Integer aSsoServerRealmIndex) throws SnmpStatusException {
        SsoServerRealmEntry entry = new SsoServerRealmEntry(this.theMib);
        entry.SsoServerRealmIndex = aSsoServerRealmIndex;
        return entry;
    }
}

