/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AuthRoleCondition
implements Condition {
    private static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    public static final String ROLE_NAME = "authRoleName";
    private Map properties;
    private String authRoleName;
    private static List propertyNames = new ArrayList(1);

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.ANY;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return property;
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = (HashMap)properties;
        if (properties == null || properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        Set keySet = properties.keySet();
        Iterator keys = keySet.iterator();
        String key = (String)keys.next();
        if (!ROLE_NAME.equals(key)) {
            Object[] args = new String[]{ROLE_NAME};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property", args, null);
        }
        Set roleNameSet = (Set)properties.get(ROLE_NAME);
        if (roleNameSet == null || roleNameSet.isEmpty() || roleNameSet.size() > 1) {
            Object[] args = new String[]{ROLE_NAME};
            throw new PolicyException("amPolicy", "property_does_not_allow_empty_or_multiple_values", args, null);
        }
        Iterator iter = roleNameSet.iterator();
        this.authRoleName = (String)iter.next();
    }

    public Map getProperties() {
        return this.properties;
    }

    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws SSOException, PolicyException {
        if (token != null) {
            String userAuthRoleNames = token.getProperty("Role");
            if (DEBUG.messageEnabled()) {
                DEBUG.message("At AuthRoleCondition.getConditionDecision(): userAuthRoleNames=" + userAuthRoleNames);
            }
            if (userAuthRoleNames == null) {
                return new ConditionDecision(false);
            }
            String userAuthRoleName = null;
            StringTokenizer st = new StringTokenizer(userAuthRoleNames, "|");
            while (st.hasMoreElements()) {
                userAuthRoleName = (String)st.nextElement();
                if (!userAuthRoleName.equals(this.authRoleName)) continue;
                return new ConditionDecision(true);
            }
        }
        return new ConditionDecision(false);
    }

    public Object clone() {
        AuthRoleCondition theClone = null;
        try {
            theClone = (AuthRoleCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            for (Object o : this.properties.keySet()) {
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
        }
        return theClone;
    }

    static {
        propertyNames.add(ROLE_NAME);
    }
}

