/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.sun.identity.shared.locale.L10NMessage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ConfiguratorException
extends RuntimeException
implements L10NMessage {
    private String message;
    private String bundleName = "amConfigurator";
    private String errorCode;
    private Object[] args;
    private ResourceBundle bundle;

    public ConfiguratorException(String errorCode, Object[] args, Locale locale) {
        this.errorCode = errorCode;
        this.args = args;
        this.message = this.getL10NMessage(locale);
    }

    public ConfiguratorException(String message) {
        super(message);
    }

    public String getResourceBundleName() {
        return this.bundleName;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return super.getMessage();
    }

    public String getL10NMessage(Locale locale) {
        if (this.errorCode == null) {
            return this.getMessage();
        }
        String result = this.message;
        if (this.bundleName != null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                this.bundle = ResourceBundle.getBundle(this.bundleName, locale);
                String mid = this.bundle.getString(this.errorCode);
                result = this.args == null || this.args.length == 0 ? mid : MessageFormat.format(mid, this.args);
            }
            catch (MissingResourceException mre) {
                result = this.errorCode;
            }
        }
        return result;
    }
}

