/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.sun.identity.shared.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InsertContent {
    private Pattern pattern;

    public InsertContent(Pattern pattern) {
        this.pattern = pattern;
    }

    public void inserts(String extFile, String origFileName, String tag) throws IOException {
        String content = this.getMatched(extFile);
        if (content.length() > 0) {
            content = content + "\n" + tag;
            String orig = this.getFileContent(origFileName);
            orig = StringUtils.strReplaceAll((String)orig, (String)tag, (String)content);
            InsertContent.writeToFile(origFileName, orig);
        }
    }

    private String getMatched(String fileName) throws IOException {
        StringBuffer buff = new StringBuffer();
        String content = this.getFileContent(fileName);
        Matcher m = this.pattern.matcher(content);
        while (m.find()) {
            buff.append(m.group()).append("\n");
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContent(String fileName) throws IOException {
        StringBuffer sb = new StringBuffer();
        FileReader in = null;
        try {
            in = new FileReader(fileName);
            BufferedReader buff = new BufferedReader(in);
            String line = buff.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = buff.readLine();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String filename, String content) throws IOException {
        if (filename != null) {
            File fileHandle = new File(filename);
            FileWriter out = null;
            try {
                out = new FileWriter(filename);
                out.write(content);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            InsertContent it = new InsertContent(Pattern.compile(args[0], 40));
            it.inserts(args[1], args[2], args[3]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

