/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.flatfile;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Hash;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.flatfile.NodeNameFilter;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SMSFlatFileTreeNode {
    private String distinguishedName;
    private String id;
    private String name;
    private SMSFlatFileTreeNode parentNode;
    private Set children = new HashSet();
    private static final String XML_DIRECTIVES = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n<!DOCTYPE FlatFileTree\n     PUBLIC \"=//Service Management Services (SMS) 1.0 DTD//EN\"\n    \"jar://com/sun/identity/sm/flatfile/smsflatfile.dtd\">\n\n";
    private static final String VERSION = "1.0";
    private static final String XML_VERSION_ATTR_NAME = "version";
    private static final String XML_ROOT_ELEMENT = "FlatFileTree";
    private static final String XML_NODE_ELEMENT = "FlatFileNode";
    private static final String XML_ROOT_START_TAG = "<FlatFileTree version=\"1.0\">";
    private static final String XML_ROOT_END_TAG = "</FlatFileTree>";
    private static final String XML_NODE_DN_ATTR_NAME = "distinguishedName";
    private static final String XML_NODE_START_TAG = "<FlatFileNode distinguishedName=\"{0}\">";
    private static final String XML_NODE_END_TAG = "</FlatFileNode>";

    public SMSFlatFileTreeNode(String dn) {
        this.distinguishedName = dn;
        this.id = dn.toLowerCase();
        int idx = dn.indexOf(44);
        this.name = idx != -1 ? dn.substring(0, idx) : dn;
    }

    public SMSFlatFileTreeNode getParentNode() {
        return this.parentNode;
    }

    public boolean addChild(SMSFlatFileTreeNode child) {
        boolean added = false;
        String childDN = child.id;
        String parentDN = "," + this.id;
        if (childDN.endsWith(parentDN)) {
            String rdn = child.distinguishedName.substring(0, child.distinguishedName.length() - parentDN.length());
            if (rdn.indexOf(44) == -1) {
                this.children.add(child);
                child.parentNode = this;
                added = true;
            } else {
                Iterator i = this.children.iterator();
                while (i.hasNext() && !added) {
                    SMSFlatFileTreeNode c = (SMSFlatFileTreeNode)i.next();
                    added = c.addChild(child);
                }
            }
        }
        return added;
    }

    public boolean removeChild(SMSFlatFileTreeNode node, String baseDir) {
        boolean removed = false;
        Iterator i = this.children.iterator();
        while (i.hasNext() && !removed) {
            SMSFlatFileTreeNode c = (SMSFlatFileTreeNode)i.next();
            if (!c.equals(node)) continue;
            i.remove();
            node.clear(baseDir);
            removed = true;
        }
        return removed;
    }

    private void clear(String baseDir) {
        this.parentNode = null;
        File file = new File(this.getAttributeFilename(baseDir));
        if (file.exists()) {
            file.delete();
        }
        for (SMSFlatFileTreeNode c : this.children) {
            c.clear(baseDir);
        }
    }

    public String getAttributeFilename(String dn, String baseDir) {
        SMSFlatFileTreeNode child = this.getChild(dn);
        return child != null ? child.getAttributeFilename(baseDir) : null;
    }

    public String getAttributeFilename(String baseDir) {
        String hash = Hash.hash((String)this.distinguishedName);
        hash = hash.replace('/', '_');
        return baseDir + File.separator + hash;
    }

    public boolean isExists(String baseDir, String dn) {
        String hash = Hash.hash((String)dn);
        hash = hash.replace('/', '_');
        File file = new File(baseDir + File.separator + hash);
        return file.exists() || this.isNodeExists(dn);
    }

    private boolean isNodeExists(String dn) {
        boolean exist = this.distinguishedName.equalsIgnoreCase(dn);
        if (!exist) {
            Iterator i = this.children.iterator();
            while (i.hasNext() && !exist) {
                SMSFlatFileTreeNode c = (SMSFlatFileTreeNode)i.next();
                exist = c.isNodeExists(dn);
            }
        }
        return exist;
    }

    public SMSFlatFileTreeNode getChild(String dn) {
        SMSFlatFileTreeNode child = null;
        if (this.distinguishedName.equalsIgnoreCase(dn)) {
            child = this;
        } else {
            Iterator i = this.children.iterator();
            while (i.hasNext() && child == null) {
                SMSFlatFileTreeNode c = (SMSFlatFileTreeNode)i.next();
                child = c.getChild(dn);
            }
        }
        return child;
    }

    public Set searchChildren(NodeNameFilter filter, boolean recursive) {
        HashSet set = new HashSet();
        this.getChildren(recursive, set);
        HashSet<SMSFlatFileTreeNode> results = new HashSet<SMSFlatFileTreeNode>();
        for (SMSFlatFileTreeNode node : set) {
            if (filter != null && !filter.accept(node.getName())) continue;
            results.add(node);
        }
        return results;
    }

    private void getChildren(boolean recursive, Set results) {
        for (SMSFlatFileTreeNode c : this.children) {
            results.add(c);
            if (!recursive) continue;
            c.getChildren(true, results);
        }
    }

    public String getDN() {
        return this.distinguishedName;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        boolean same = false;
        if (o instanceof SMSFlatFileTreeNode) {
            same = ((SMSFlatFileTreeNode)o).id.equals(this.id);
        }
        return same;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer();
        if (this.parentNode == null) {
            xml.append(XML_DIRECTIVES).append(XML_ROOT_START_TAG).append("\n");
        }
        Object[] dn = new Object[]{this.distinguishedName};
        xml.append(MessageFormat.format(XML_NODE_START_TAG, dn)).append("\n");
        for (SMSFlatFileTreeNode c : this.children) {
            xml.append(c.toXML());
        }
        xml.append(XML_NODE_END_TAG).append("\n");
        if (this.parentNode == null) {
            xml.append(XML_ROOT_END_TAG).append("\n");
        }
        return xml.toString();
    }

    public static SMSFlatFileTreeNode createTree(String xml, Debug debug) throws Exception {
        SMSFlatFileTreeNode root = null;
        Document doc = XMLUtils.toDOMDocument((String)xml, (Debug)debug);
        Node rootNode = XMLUtils.getRootNode((Document)doc, (String)XML_ROOT_ELEMENT);
        if (rootNode != null) {
            root = SMSFlatFileTreeNode.createNode(XMLUtils.getChildNode((Node)rootNode, (String)XML_NODE_ELEMENT));
        }
        return root;
    }

    private static SMSFlatFileTreeNode createNode(Node parentNode) throws SMSException {
        SMSFlatFileTreeNode node = new SMSFlatFileTreeNode(XMLUtils.getNodeAttributeValue((Node)parentNode, (String)XML_NODE_DN_ATTR_NAME));
        Set children = XMLUtils.getChildNodes((Node)parentNode, (String)XML_NODE_ELEMENT);
        if (children != null && !children.isEmpty()) {
            for (Node n : children) {
                SMSFlatFileTreeNode child = SMSFlatFileTreeNode.createNode(n);
                node.addChild(child);
            }
        }
        return node;
    }
}

