/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.manifest;

import com.sun.identity.tools.manifest.GeneralFileFilter;
import com.sun.identity.tools.manifest.ManifestConstants;
import com.sun.identity.tools.manifest.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class FilesDigester
implements ManifestConstants {
    protected LinkedList includePattern;
    protected LinkedList excludePattern;
    protected char wildCard;
    protected boolean recursive;

    public FilesDigester(LinkedList includePattern, LinkedList excludePattern, char wildCard, boolean recursive) {
        this.includePattern = includePattern;
        this.excludePattern = excludePattern;
        this.wildCard = wildCard;
        this.recursive = recursive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void digestWarFile(String hashAlg, Properties digestResult, JarFile wfile, boolean intoJar) {
        Enumeration<JarEntry> wEnum = wfile.entries();
        byte[] digestCode = null;
        String wename = null;
        InputStream in = null;
        try {
            while (wEnum.hasMoreElements()) {
                JarEntry we = wEnum.nextElement();
                if (we.isDirectory()) continue;
                wename = we.getName();
                if (wename.endsWith(".jar") && intoJar) {
                    in = wfile.getInputStream(we);
                    digestCode = this.digestJarFile(hashAlg, in);
                    in.close();
                } else {
                    in = wfile.getInputStream(we);
                    digestCode = Utils.getHash(hashAlg, in);
                    in.close();
                }
                this.appendResult(digestResult, wename, digestCode);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
                in = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] digestJarFile(String hashAlg, InputStream in) {
        JarInputStream jin = null;
        try {
            jin = new JarInputStream(in);
            JarEntry je = null;
            MessageDigest md = MessageDigest.getInstance(hashAlg);
            while ((je = jin.getNextJarEntry()) != null) {
                if (!je.isDirectory()) {
                    md = Utils.hashing(md, jin);
                }
                jin.closeEntry();
            }
            jin.close();
            byte[] byArray = md.digest();
            return byArray;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        finally {
            if (jin != null) {
                try {
                    jin.close();
                }
                catch (IOException ignored) {}
                jin = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void digest(String hashAlg, File file, Properties digestResult, String ignoredPath, boolean intoJar, boolean intoWar) {
        if (file.exists()) {
            if (file.isDirectory()) {
                if (this.recursive) {
                    File[] tempFiles = null;
                    tempFiles = this.includePattern != null ? file.listFiles(new GeneralFileFilter(this.includePattern)) : file.listFiles();
                    for (int i = 0; i < tempFiles.length; ++i) {
                        if (tempFiles[i].isDirectory()) {
                            this.digest(hashAlg, tempFiles[i], digestResult, ignoredPath, intoJar, intoWar);
                            continue;
                        }
                        if (this.excludePattern != null) {
                            if (Utils.isMatch(tempFiles[i].getName(), this.excludePattern, this.wildCard)) continue;
                            this.digest(hashAlg, tempFiles[i], digestResult, ignoredPath, intoJar, intoWar);
                            continue;
                        }
                        this.digest(hashAlg, tempFiles[i], digestResult, ignoredPath, intoJar, intoWar);
                    }
                }
            } else if (file.getName().endsWith(".war") && intoWar) {
                try {
                    this.digestWarFile(hashAlg, digestResult, new JarFile(file), intoJar);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                FileInputStream fin;
                byte[] digestedbyte = null;
                if (file.getName().endsWith(".jar") && intoJar) {
                    fin = null;
                    try {
                        fin = new FileInputStream(file);
                        digestedbyte = this.digestJarFile(hashAlg, fin);
                        fin.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (IOException ignored) {}
                            fin = null;
                        }
                    }
                } else {
                    fin = null;
                    try {
                        fin = new FileInputStream(file);
                        digestedbyte = Utils.getHash(hashAlg, fin);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (IOException ignored) {}
                            fin = null;
                        }
                    }
                }
                String tempPath = file.getPath();
                tempPath = tempPath.substring(tempPath.indexOf(ignoredPath) + ignoredPath.length()).replaceAll("\\\\", "/");
                if (tempPath.startsWith("/")) {
                    tempPath = tempPath.substring(1);
                }
                this.appendResult(digestResult, tempPath, digestedbyte);
            }
        }
    }

    protected void appendResult(Properties result, String path, byte[] digestedbyte) {
        result.setProperty(path, Utils.translateHashToString(digestedbyte));
    }
}

