/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.FAMSecurityToken;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.sts.ClientUserToken;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.STSUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class STSClientUserToken
implements ClientUserToken {
    FAMSecurityToken famToken = null;
    String tokenType = null;
    String tokenValue = null;

    public STSClientUserToken() {
    }

    public void init(Object credential) throws FAMSTSException {
        block9: {
            try {
                if (credential instanceof SSOToken) {
                    this.famToken = new FAMSecurityToken((SSOToken)credential);
                    this.tokenType = "urn:sun:wss:ssotoken";
                    break block9;
                }
                if (credential instanceof Element) {
                    Element element = (Element)credential;
                    if (!"Assertion".equals(element.getLocalName())) {
                        throw new FAMSTSException(STSUtils.bundle.getString("unsupportedcredential"));
                    }
                    String ns = element.getNamespaceURI();
                    if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(ns)) {
                        this.tokenType = "urn:sun:wss:samltoken";
                    } else if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(ns)) {
                        this.tokenType = "urn:sun:wss:saml2token";
                    } else {
                        throw new FAMSTSException(STSUtils.bundle.getString("unsupportedcredential"));
                    }
                    this.tokenValue = XMLUtils.print((Node)((Element)credential));
                    break block9;
                }
                throw new FAMSTSException(STSUtils.bundle.getString("unsupportedcredential"));
            }
            catch (SecurityException sse) {
                throw new FAMSTSException(sse.getMessage());
            }
        }
    }

    public STSClientUserToken(Element element) throws FAMSTSException {
        this.parse(element);
    }

    public void parse(Element element) throws FAMSTSException {
        if (element == null) {
            throw new FAMSTSException(STSUtils.bundle.getString("nullinput"));
        }
        String localName = element.getLocalName();
        if (!"FAMToken".equals(localName)) {
            throw new FAMSTSException(STSUtils.bundle.getString("invalidelementname"));
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        if (length == 0) {
            throw new FAMSTSException(STSUtils.bundle.getString("invalidelementname"));
        }
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("TokenValue")) {
                this.tokenValue = XMLUtils.getChildrenValue((Element)((Element)child));
                continue;
            }
            if (!childName.equals("TokenType")) continue;
            this.tokenType = XMLUtils.getElementValue((Element)((Element)child));
        }
    }

    public Element getTokenValue() {
        Document document = XMLUtils.toDOMDocument((String)this.toString(), (Debug)STSUtils.debug);
        return document.getDocumentElement();
    }

    public String getTokenId() {
        return this.tokenValue;
    }

    public String getPrincipalName() throws FAMSTSException {
        try {
            SSOToken ssoToken = SSOTokenManager.getInstance().createSSOToken(this.tokenValue);
            return ssoToken.getPrincipal().getName();
        }
        catch (SSOException se) {
            throw new FAMSTSException(se.getMessage());
        }
    }

    public String toString() {
        if (this.famToken != null) {
            try {
                return XMLUtils.print((Node)this.famToken.toDocumentElement());
            }
            catch (SecurityException se) {
                throw new RuntimeException(se.getMessage());
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<fam:FAMToken xmlns:fam=\"").append("http://www.sun.com/identity/famtoken").append("\"").append(">").append("\n").append("<fam:TokenValue>").append(this.tokenValue).append("</fam:TokenValue>").append("\n").append("<fam:TokenType>").append(this.tokenType).append("</fam:TokenType>").append("\n").append("</fam:FAMToken>");
        return sb.toString();
    }

    public String getType() {
        return this.tokenType;
    }
}

