/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import java.security.AccessController;

public class SMServiceListener
implements ServiceListener {
    private static SMServiceListener serviceListener;
    private String listenerId;
    private Debug debug = DelegationManager.debug;

    private SMServiceListener() {
    }

    public static SMServiceListener getInstance() {
        if (serviceListener == null) {
            serviceListener = new SMServiceListener();
        }
        return serviceListener;
    }

    public void registerForNotifications() {
        if (this.listenerId != null) {
            return;
        }
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceConfigManager scm = null;
            try {
                scm = new ServiceConfigManager("sunAMDelegationService", token);
                if (scm.getOrganizationConfig("/", null) == null) {
                    scm = null;
                }
            }
            catch (SMSException sMSException) {
                // empty catch block
            }
            if (scm == null) {
                scm = new ServiceConfigManager("iPlanetAMAuthService", token);
            }
            this.listenerId = scm.addListener(this);
        }
        catch (SMSException ex) {
            this.debug.error("Unable to register SMS notification for Delegation", (Throwable)ex);
        }
        catch (SSOException ex) {
            this.debug.error("Unable to register SMS notification for Delegation", (Throwable)((Object)ex));
        }
    }

    public void schemaChanged(String serviceName, String version) {
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        block15: {
            if (serviceComponent == null || serviceComponent.length() == 0) {
                int index = orgName.indexOf(",ou=services,");
                if (index > 0) {
                    orgName = orgName.substring(index + 13);
                }
                if (type == 2) {
                    DeleteDelegationPolicyTask task = new DeleteDelegationPolicyTask(orgName);
                    if (this.debug.messageEnabled()) {
                        this.debug.message("SMServiceListener.occ scheduling policies to be removed for org: " + orgName + " GN: " + groupName + " SC: " + serviceComponent);
                    }
                    SystemTimer.getTimer().schedule((TaskRunnable)task, 0L);
                } else if (type == 1) {
                    SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    try {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("SMServiceListener.occ creating policies for the org: " + orgName + " GN: " + groupName + " SC: " + serviceComponent);
                        }
                        if (ServiceManager.isCoexistenceMode()) {
                            DelegationUtils.createRealmPrivileges(token, orgName);
                        } else {
                            OrganizationConfigManager ocm = new OrganizationConfigManager(token, orgName);
                            OrganizationConfigManager parentOrg = ocm.getParentOrgConfigManager();
                            DelegationUtils.copyRealmPrivilegesFromParent(token, parentOrg, ocm);
                        }
                    }
                    catch (SSOException ssoe) {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("Creating delegation permissions for: " + orgName + " failed", (Throwable)((Object)ssoe));
                        }
                    }
                    catch (SMSException smse) {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("Creating delegation permissions for: " + orgName + " failed", (Throwable)smse);
                        }
                    }
                    catch (DelegationException de) {
                        if (!this.debug.messageEnabled()) break block15;
                        this.debug.message("Creating delegation permissions for: " + orgName + " failed", (Throwable)de);
                    }
                }
            }
        }
    }

    private class DeleteDelegationPolicyTask
    extends GeneralTaskRunnable {
        private String realm;

        private DeleteDelegationPolicyTask(String realm) {
            this.realm = realm;
        }

        public void run() {
            block7: {
                SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                try {
                    new OrganizationConfigManager(token, this.realm);
                }
                catch (SMSException e) {
                    try {
                        if (SMServiceListener.this.debug.messageEnabled()) {
                            SMServiceListener.this.debug.message("Deleting delegation privilegs for realm" + this.realm);
                        }
                        DelegationUtils.deleteRealmPrivileges(token, this.realm);
                    }
                    catch (SSOException ex) {
                        if (SMServiceListener.this.debug.messageEnabled()) {
                            SMServiceListener.this.debug.message("Error deleting delegation privilegs for realm" + this.realm, (Throwable)((Object)ex));
                        }
                    }
                    catch (DelegationException ex) {
                        if (!SMServiceListener.this.debug.messageEnabled()) break block7;
                        SMServiceListener.this.debug.message("Error deleting delegation privilegs for realm" + this.realm, (Throwable)ex);
                    }
                }
            }
        }

        public boolean addElement(Object key) {
            return false;
        }

        public boolean removeElement(Object key) {
            return false;
        }

        public boolean isEmpty() {
            return true;
        }

        public long getRunPeriod() {
            return -1L;
        }
    }
}

