/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.ILogRecord;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.shared.encode.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Formatter;

public class RemoteFormatter
extends Formatter {
    public String format(LogRecord logRecord) {
        String logName = logRecord.getLoggerName();
        Map logInfo = logRecord.getLogInfoMap();
        String loggedBySid = null;
        if (logInfo != null && (loggedBySid = (String)logInfo.get("LoggedBySid")) == null) {
            if (Debug.warningEnabled()) {
                Debug.warning("RemoteFormatter : returning null because logRecord doesn't have loggedBySid");
            }
            return null;
        }
        Object[] parameters = logRecord.getParameters();
        StringBuffer xml = new StringBuffer();
        xml.append("<logRecWrite><log logName=\"");
        xml.append(logName);
        xml.append("\" sid=\"");
        xml.append(loggedBySid);
        xml.append("\"></log><logRecord><level>");
        xml.append(logRecord.getLevel().intValue());
        xml.append("</level><recMsg>");
        String msg = this.formatMessage(logRecord);
        if (msg == null || msg.length() == 0) {
            msg = "Not Available";
        }
        msg = Base64.encode((byte[])msg.getBytes());
        xml.append(msg);
        xml.append("</recMsg>");
        if (logInfo != null) {
            Set keys = logInfo.keySet();
            Iterator keysIter = keys.iterator();
            xml.append("<logInfoMap>");
            while (keysIter.hasNext()) {
                String key = (String)keysIter.next();
                xml.append("<logInfo> <infoKey>");
                xml.append(key);
                xml.append("</infoKey><infoValue>");
                String infoValue = (String)logInfo.get(key);
                if (key.equalsIgnoreCase("Data")) {
                    infoValue = Base64.encode((byte[])infoValue.getBytes());
                }
                xml.append(infoValue);
                xml.append("</infoValue></logInfo>");
            }
            xml.append("</logInfoMap>");
        }
        if (parameters != null && parameters.length > 0) {
            xml.append("<parameters>");
            for (int i = 0; i < parameters.length; ++i) {
                xml.append("<parameter><paramIndex>");
                xml.append(String.valueOf(i));
                xml.append("</paramIndex><paramValue>");
                xml.append(parameters[i].toString());
                xml.append("</paramValue></parameter>");
            }
            xml.append("</parameters>");
        }
        xml.append("</logRecord></logRecWrite>");
        if (Debug.messageEnabled()) {
            Debug.message("RemoteFormatter: XML Req string = " + xml);
        }
        return xml.toString();
    }

    public String format(java.util.logging.LogRecord logRecord) {
        if (LogManagerUtil.isAMLoggingMode() && logRecord instanceof ILogRecord) {
            return this.format((LogRecord)logRecord);
        }
        String logName = logRecord.getLoggerName();
        String loggedBySid = null;
        Object[] parameters = logRecord.getParameters();
        StringBuffer xml = new StringBuffer();
        xml.append("<logRecWrite><log logName=\"");
        xml.append(logName);
        xml.append("\" sid=\"");
        xml.append(loggedBySid);
        xml.append("\"></log><logRecord><level>");
        xml.append(logRecord.getLevel().intValue());
        xml.append("</level><recMsg>");
        String msg = this.formatMessage(logRecord);
        if (msg == null || msg.length() == 0) {
            msg = "Not Available";
        }
        msg = Base64.encode((byte[])msg.getBytes());
        xml.append(msg);
        xml.append("</recMsg>");
        if (parameters != null && parameters.length > 0) {
            xml.append("<parameters>");
            for (int i = 0; i < parameters.length; ++i) {
                xml.append("<parameter><paramIndex>");
                xml.append(String.valueOf(i));
                xml.append("</paramIndex><paramValue>");
                xml.append(parameters[i].toString());
                xml.append("</paramValue></parameter>");
            }
            xml.append("</parameters>");
        }
        xml.append("</logRecord></logRecWrite>");
        if (Debug.messageEnabled()) {
            Debug.message("RemoteFormatter: XML Req string = " + xml);
        }
        return xml.toString();
    }
}

