/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.interfaces.ResourceName;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SuffixResourceName
implements ResourceName {
    private String delimiter = ",";
    private boolean caseSensitive = false;
    protected String wildcard = "*";

    public void initialize(Map configParams) {
        String wildcardConfig;
        String caseConfig;
        String delimiterConfig = (String)configParams.get("delimiter");
        if (delimiterConfig != null) {
            this.delimiter = delimiterConfig;
        }
        if ((caseConfig = (String)configParams.get("caseSensitive")) != null) {
            this.caseSensitive = caseConfig.equals("true") ? true : (caseConfig.equals("false") ? false : false);
        }
        if ((wildcardConfig = (String)configParams.get("wildcard")) != null) {
            this.wildcard = wildcardConfig;
        }
    }

    public Set getServiceTypeNames() {
        return null;
    }

    public ResourceMatch compare(String requestResource, String targetResource, boolean wildcardCompare) {
        int len;
        int beginIndex1 = 0;
        int endIndex1 = 0;
        int beginIndex2 = 0;
        int endIndex2 = 0;
        int strlen1 = 0;
        int strlen2 = 0;
        String substr = null;
        if (requestResource == null && targetResource == null) {
            return ResourceMatch.EXACT_MATCH;
        }
        if (requestResource == null || targetResource == null) {
            return ResourceMatch.NO_MATCH;
        }
        if (!this.caseSensitive) {
            requestResource = requestResource.toLowerCase();
            targetResource = targetResource.toLowerCase();
        }
        requestResource = this.reverseString(requestResource);
        targetResource = this.reverseString(targetResource);
        while (requestResource.endsWith(this.delimiter)) {
            len = requestResource.length();
            requestResource = requestResource.substring(0, len - 1);
        }
        while (targetResource.endsWith(this.delimiter)) {
            len = targetResource.length();
            targetResource = targetResource.substring(0, len - 1);
        }
        strlen1 = requestResource.length();
        strlen2 = targetResource.length();
        endIndex2 = targetResource.indexOf(this.wildcard, beginIndex2);
        if (!wildcardCompare || endIndex2 == -1) {
            if (requestResource.equals(targetResource)) {
                return ResourceMatch.EXACT_MATCH;
            }
            if (targetResource.startsWith(requestResource + this.delimiter)) {
                return ResourceMatch.SUB_RESOURCE_MATCH;
            }
            if (requestResource.startsWith(targetResource + this.delimiter)) {
                return ResourceMatch.SUPER_RESOURCE_MATCH;
            }
            return ResourceMatch.NO_MATCH;
        }
        substr = targetResource.substring(beginIndex2, endIndex2);
        if (endIndex2 > beginIndex2 && !requestResource.startsWith(substr)) {
            if (substr.startsWith(requestResource + this.delimiter)) {
                return ResourceMatch.SUB_RESOURCE_MATCH;
            }
            return ResourceMatch.NO_MATCH;
        }
        beginIndex1 += endIndex2 - beginIndex2;
        if (endIndex2 >= strlen2 - 1) {
            return ResourceMatch.WILDCARD_MATCH;
        }
        beginIndex2 = endIndex2 + 1;
        while ((endIndex2 = targetResource.indexOf(this.wildcard, beginIndex2)) != -1) {
            substr = targetResource.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2 && (beginIndex1 = requestResource.indexOf(substr, beginIndex1)) == -1) {
                return ResourceMatch.SUB_RESOURCE_MATCH;
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return ResourceMatch.WILDCARD_MATCH;
            }
            beginIndex2 = endIndex2 + 1;
        }
        substr = targetResource.substring(beginIndex2, strlen2);
        endIndex1 = requestResource.lastIndexOf(substr, strlen1 - 1);
        if (endIndex1 == -1) {
            return ResourceMatch.SUB_RESOURCE_MATCH;
        }
        if (beginIndex1 > endIndex1) {
            return ResourceMatch.SUB_RESOURCE_MATCH;
        }
        beginIndex1 = endIndex1;
        if (strlen1 - beginIndex1 == strlen2 - beginIndex2) {
            return ResourceMatch.WILDCARD_MATCH;
        }
        if ((substr = requestResource.substring(beginIndex1 += strlen2 - beginIndex2, beginIndex1 + 1)).equals(this.delimiter)) {
            return ResourceMatch.SUPER_RESOURCE_MATCH;
        }
        return ResourceMatch.SUB_RESOURCE_MATCH;
    }

    private String reverseString(String str) {
        int strlen = str.length();
        if (strlen < 2) {
            return str;
        }
        char[] chars = new char[strlen];
        for (int i = 0; i < strlen; ++i) {
            chars[i] = str.charAt(strlen - i - 1);
        }
        return new String(chars);
    }

    public String append(String superResource, String subResource) {
        return subResource + this.delimiter + superResource;
    }

    public String getSubResource(String resource, String superResource) {
        String subResource = null;
        if (!superResource.startsWith(this.delimiter)) {
            superResource = this.delimiter + superResource;
        }
        if (resource.endsWith(superResource)) {
            int endIndex = resource.length() - superResource.length();
            subResource = resource.substring(0, endIndex);
        }
        return subResource;
    }

    public String[] split(String res) {
        StringTokenizer st = new StringTokenizer(res, this.delimiter);
        int n = st.countTokens();
        String[] retVal = new String[n];
        for (int i = 0; i < n; ++i) {
            retVal[n - i - 1] = st.nextToken();
        }
        return retVal;
    }

    public String canonicalize(String res) throws PolicyException {
        return res;
    }
}

