/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.EntitlementSubjectImpl;
import com.sun.identity.entitlement.SubjectAttributesManager;
import com.sun.identity.entitlement.SubjectDecision;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeSubject
extends EntitlementSubjectImpl {
    public AttributeSubject() {
    }

    public AttributeSubject(String name, String value) {
        super(name, value);
    }

    public String getValue() {
        return this.getPSubjectName();
    }

    public void setValue(String value) {
        this.setPSubjectName(value);
    }

    @Override
    public SubjectDecision evaluate(String realm, SubjectAttributesManager mgr, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        boolean satified = false;
        Set<Object> publicCreds = subject.getPublicCredentials();
        if (publicCreds != null && !publicCreds.isEmpty()) {
            Map attributes = (Map)publicCreds.iterator().next();
            Set values = (Set)attributes.get("attribute:" + this.getID());
            satified = values != null ? values.contains(this.getValue()) : false;
        }
        return new SubjectDecision(satified ^= this.isExclusive(), Collections.EMPTY_MAP);
    }

    @Override
    public Map<String, Set<String>> getSearchIndexAttributes() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(4);
        HashSet<String> set = new HashSet<String>();
        set.add(this.getValue());
        map.put("attribute:" + this.getID(), set);
        return map;
    }

    @Override
    public Set<String> getRequiredAttributeNames() {
        HashSet<String> set = new HashSet<String>(2);
        set.add("attribute:" + this.getID());
        return set;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }
}

