/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.ldapv3;

import com.sun.identity.common.PeriodicGroupMap;
import com.sun.identity.common.ScheduleableGroupAction;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3EventService;
import com.sun.identity.idm.plugins.ldapv3.Request;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPMessage;
import com.sun.identity.shared.ldap.LDAPResponse;
import com.sun.identity.shared.ldap.LDAPSearchResult;
import com.sun.identity.shared.ldap.LDAPSearchResultReference;
import java.util.Date;
import java.util.Map;

public class LDAPv3EventServicePolling
extends LDAPv3EventService {
    private final int IS_MESSAGE_PROCESSED = 0;
    private Map map = this._requestList;

    public synchronized void removeListener(String psIdKey) {
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventServicePolling.removeListener  psIdKey=" + psIdKey);
        }
        super.removeListener(psIdKey);
    }

    protected LDAPv3EventServicePolling(Map pluginConfig, String serverNames) throws LDAPException {
        super(pluginConfig, serverNames);
        this._requestList = new PeriodicGroupMap(new ScheduleableGroupAction(){

            public void doGroupAction(Object obj) {
                Request req = (Request)LDAPv3EventServicePolling.this.map.remove(obj);
                if (req != null) {
                    try {
                        if (!req.getStopStatus()) {
                            LDAPv3EventServicePolling.this.removeListener(req);
                            LDAPv3EventServicePolling.this.addListener(req.getRequester(), req.getListener(), req.getBaseDn(), req.getScope(), req.getFilter(), req.getOperations(), req.getPluginConfig(), req.getOwner(), req.getServerNames(), req.getPsIdKey());
                        }
                    }
                    catch (IdRepoException le) {
                        if (LDAPv3EventService.debugger.messageEnabled()) {
                            LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.resetAllSearches(): IdRepException occurred while re-establishing listeners.  randomID=" + LDAPv3EventServicePolling.this.randomID, (Throwable)le);
                        }
                        int errorCode = 87;
                        LDAPv3EventServicePolling.this.processExceptionErrorCodes(le, errorCode, false);
                    }
                    catch (LDAPException e) {
                        if (LDAPv3EventService.debugger.messageEnabled()) {
                            LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.resetAllSearches(): LDAPException occurred, while trying to re-establish persistent searches. randomID=" + LDAPv3EventServicePolling.this.randomID, (Throwable)e);
                        }
                        int errorCode = e.getLDAPResultCode();
                        LDAPv3EventServicePolling.this.processExceptionErrorCodes((Exception)((Object)e), errorCode, false);
                    }
                }
            }
        }, this._idleTimeOutMills, this._idleTimeOutMills, true, this.map);
        SystemTimer.getTimer().schedule((TaskRunnable)this._requestList, new Date((System.currentTimeMillis() + this._idleTimeOutMills) / 1000L * 1000L));
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventServicePolling.constructor() exit. randomID=" + this.randomID);
        }
    }

    protected String getName() {
        return "LDAPv3EventServicePolling";
    }

    protected boolean processResponse(LDAPMessage message) {
        if (message == null && !this._requestList.isEmpty()) {
            debugger.warning("EventService.processResponse() - Received a NULL Response. Attempting to re-start persistent searches");
            this.resetErrorSearches(false);
            return true;
        }
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.processResponse() - received DS message  => " + message.toString() + " randomID=" + this.randomID);
        }
        boolean successState = true;
        Request request = this.getRequestEntry(message.getMessageID());
        if (request == null) {
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.processResponse() - Received ldap message with unknown id = " + message.getMessageID() + " randomID=" + this.randomID);
            }
        } else if (message.getMessageType() == 26) {
            this.processSearchResultMessage((LDAPSearchResult)message, request);
            TaskRunnable taskList = (TaskRunnable)this._requestList;
            taskList.removeElement((Object)request.getRequestID());
            taskList.addElement((Object)request.getRequestID());
            request.setLastUpdatedTime(System.currentTimeMillis());
        } else if (message.getMessageType() == 29) {
            LDAPResponse rsp = (LDAPResponse)message;
            successState = this.processResponseMessage(rsp, request);
        } else if (message.getMessageType() == 27) {
            this.processSearchResultRef((LDAPSearchResultReference)message, request);
        }
        return successState;
    }

    private boolean processExceptionErrorCodes(Exception ex, int errorCode, boolean interrupt) {
        boolean successState = true;
        if (this._retryErrorCodes.contains(Integer.toString(errorCode))) {
            this.resetErrorSearches(true);
        } else {
            this.processNetworkError(ex);
        }
        return successState;
    }

    protected Thread getServiceThread() {
        return this._monitorThread;
    }
}

