/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.util.DN;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Misc {
    static final String localDsameServer = SystemProperties.get("com.iplanet.am.server.host");
    private static final boolean isCaseInsensitiveDN = Boolean.valueOf(SystemProperties.get("com.sun.am.session.caseInsensitiveDN"));

    public static String getMapAttr(Map m, String name) {
        Iterator iter;
        String retVal = null;
        Set s = (Set)m.get(name);
        if (s != null && (iter = s.iterator()).hasNext() && (retVal = (String)iter.next()) != null) {
            retVal = retVal.trim();
        }
        return retVal;
    }

    public static String getMapAttr(Map m, String name, String defaultValue) {
        String tmp;
        Iterator iter;
        String retVal = defaultValue;
        Set s = (Set)m.get(name);
        if (s != null && (iter = s.iterator()).hasNext() && (tmp = (String)iter.next()) != null && (tmp = tmp.trim()).length() > 0) {
            retVal = tmp;
        }
        return retVal;
    }

    public static int getIntMapAttr(Map m, String name, String defaultValue, Debug debug) throws NumberFormatException {
        try {
            return Integer.parseInt(Misc.getMapAttr(m, name, defaultValue));
        }
        catch (Exception e) {
            debug.error("getIntMapAttr : " + name, (Throwable)e);
            return Integer.parseInt(defaultValue);
        }
    }

    public static int getIntMapAttr(Map m, String name, int defaultValue, Debug debug) {
        try {
            return Integer.parseInt(Misc.getMapAttr(m, name));
        }
        catch (Exception e) {
            debug.error("getIntMapAttr : " + name, (Throwable)e);
            return defaultValue;
        }
    }

    public static boolean isDescendantOf(String dn1, String dn2) {
        DN temp1 = new DN(dn1);
        DN temp2 = new DN(dn2);
        if (temp1.equals(temp2)) {
            return true;
        }
        return temp1.isDescendantOf(temp2);
    }

    public static String getServerMapAttr(Map m, String attrName) {
        Set attrValues = (Set)m.get(attrName);
        if (attrValues == null || attrValues.isEmpty()) {
            return null;
        }
        Iterator iter = attrValues.iterator();
        int index = -1;
        if (attrValues.size() == 1) {
            String strServer = (String)iter.next();
            if (strServer != null) {
                strServer = strServer.trim();
            }
            if (strServer.startsWith(localDsameServer) && (index = strServer.indexOf("|")) != -1) {
                return strServer.substring(index + 1);
            }
            return strServer;
        }
        while (iter.hasNext()) {
            String s = (String)iter.next();
            if (s == null || !s.startsWith(localDsameServer) || (index = s.indexOf("|")) == -1) continue;
            return s.substring(index + 1).trim();
        }
        return null;
    }

    public static String canonicalize(String dn) {
        String canonicalizedDN = new DN(dn).toRFCString();
        if (isCaseInsensitiveDN) {
            canonicalizedDN = canonicalizedDN.toLowerCase();
        }
        return canonicalizedDN;
    }
}

