/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.policy.PolicyNormalAddViewBean;
import com.sun.identity.console.policy.PolicyNormalEditViewBean;
import com.sun.identity.console.policy.PolicyOpViewBeanBase;
import com.sun.identity.console.policy.PolicyReferralAddViewBean;
import com.sun.identity.console.policy.PolicyReferralEditViewBean;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.console.policy.model.PolicyModelImpl;
import com.sun.identity.console.realm.HasEntitiesTabs;
import com.sun.identity.console.realm.RealmPropertiesBase;
import com.sun.identity.policy.Policy;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PolicyViewBean
extends RealmPropertiesBase
implements HasEntitiesTabs {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/Policy.jsp";
    private static final String TF_FILTER = "tfFilter";
    private static final String BTN_SEARCH = "btnSearch";
    private static final String TBL_SEARCH = "tblSearch";
    private static final String TBL_BUTTON_ADD = "tblButtonAddNormal";
    private static final String TBL_BUTTON_ADD_REFERRAL = "tblButtonAddReferral";
    private static final String TBL_BUTTON_DELETE = "tblButtonDelete";
    private static final String TBL_COL_NAME = "tblColName";
    private static final String TBL_DATA_NAME = "tblDataName";
    private static final String TBL_COL_RESOURCES = "tblColResources";
    private static final String TBL_DATA_RESOURCES = "tblDataResources";
    private static final String TBL_DATA_ACTION_HREF = "tblDataActionHref";
    private static final String PAGETITLE = "pgtitle";
    private CCActionTableModel tblModel = null;

    public PolicyViewBean() {
        super("Policy");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        if (!this.initialized) {
            super.initialize();
            this.createTableModel();
            this.createPageTitleModel();
            this.registerChildren();
            this.initialized = true;
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(TF_FILTER, CCTextField.class);
        this.registerChild(BTN_SEARCH, CCButton.class);
        this.registerChild(PAGETITLE, CCPageTitle.class);
        this.registerChild(TBL_SEARCH, CCActionTable.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        try {
            if (name.equals(TBL_SEARCH)) {
                SerializedField szCache = (SerializedField)this.getChild("szCache");
                this.populateTableModel((List)szCache.getSerializedObj());
                view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
            } else {
                view = name.equals(PAGETITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name)));
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.resetButtonState(TBL_BUTTON_DELETE);
        this.getPolicyNames();
        if (!this.isInlineAlertMessageSet()) {
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            PolicyModel model = (PolicyModel)this.getModel();
            String message = model.canCreatePolicy(curRealm);
            if (message != null) {
                CCButton child = (CCButton)this.getChild(TBL_BUTTON_ADD);
                child.setDisabled(true);
                child = (CCButton)this.getChild(TBL_BUTTON_ADD_REFERRAL);
                child.setDisabled(true);
                this.setInlineAlertMessage("info", "message.information", message);
            }
        }
        this.setPageTitle(this.getModel(), "page.title.policy");
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        HttpServletRequest req = rc.getRequest();
        return new PolicyModelImpl(req, this.getPageSessionAttributes());
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(this.getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblPMPolicy.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_BUTTON_ADD, (Object)"table.policy.normal.button.new");
        this.tblModel.setActionValue(TBL_BUTTON_ADD_REFERRAL, (Object)"table.policy.referral.button.new");
        this.tblModel.setActionValue(TBL_BUTTON_DELETE, (Object)"table.policy.button.delete");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"table.policy.column.name");
        this.tblModel.setActionValue(TBL_COL_RESOURCES, (Object)"table.policy.column.resources");
    }

    private void getPolicyNames() {
        PolicyModel model = (PolicyModel)this.getModel();
        String filter = (String)this.getDisplayFieldValue(TF_FILTER);
        if (filter == null || filter.length() == 0) {
            filter = "*";
            this.setDisplayFieldValue(TF_FILTER, "*");
        } else {
            filter = filter.trim();
        }
        try {
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            this.populateTableModel(model.getPolicyNames(curRealm, filter));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    private void populateTableModel(Collection policyNames) throws AMConsoleException {
        this.tblModel.clearAll();
        PolicyModel model = (PolicyModel)this.getModel();
        this.tblModel.setMaxRows(model.getPageSize());
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        if (policyNames != null && !policyNames.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>(policyNames.size());
            boolean firstEntry = true;
            Iterator iter = policyNames.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblModel.appendRow();
                }
                String name = (String)iter.next();
                this.tblModel.setValue(TBL_DATA_NAME, (Object)name);
                this.tblModel.setValue(TBL_DATA_ACTION_HREF, (Object)PolicyViewBean.stringToHex(name));
                list.add(name);
                String realm = (String)this.getPageSessionAttribute("currentRealm");
                Set resourceNames = model.getProtectedResourceNames(realm, name);
                if (resourceNames.isEmpty()) {
                    this.tblModel.setValue(TBL_DATA_RESOURCES, (Object)model.getLocalizedString("policy.resources.empty.message"));
                    continue;
                }
                StringBuffer sbResources = new StringBuffer();
                boolean first = true;
                for (String resourceName : resourceNames) {
                    if (first) {
                        first = false;
                    } else {
                        sbResources.append("<br>");
                    }
                    sbResources.append(HtmlUtil.escape((String)resourceName));
                }
                this.tblModel.setValue(TBL_DATA_RESOURCES, (Object)sbResources.toString());
            }
            szCache.setValue(list);
        } else {
            szCache.setValue(null);
        }
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleTblButtonAddNormalRequest(RequestInvocationEvent event) {
        PolicyNormalAddViewBean vb = (PolicyNormalAddViewBean)this.getViewBean(PolicyNormalAddViewBean.class);
        try {
            PolicyModel model = (PolicyModel)this.getModel();
            String id = model.cachePolicy(model.getLocalizedString("policy.create.name"), "", false, true);
            this.unlockPageTrail();
            this.setPageSessionAttribute("policyCacheID", (Serializable)((Object)id));
        }
        catch (AMConsoleException e) {
            debug.error("error with forwarding to normal page");
        }
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblButtonAddReferralRequest(RequestInvocationEvent event) {
        PolicyReferralAddViewBean vb = (PolicyReferralAddViewBean)this.getViewBean(PolicyReferralAddViewBean.class);
        try {
            PolicyModel model = (PolicyModel)this.getModel();
            String id = model.cachePolicy(model.getLocalizedString("policy.create.name"), "", true, true);
            this.unlockPageTrail();
            this.setPageSessionAttribute("policyCacheID", (Serializable)((Object)id));
        }
        catch (AMConsoleException e) {
            debug.error("error with forwarding to referral page");
        }
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblDataActionHrefRequest(RequestInvocationEvent event) {
        PolicyModel model = (PolicyModel)this.getModel();
        String policyName = PolicyViewBean.hexToString((String)this.getDisplayFieldValue(TBL_DATA_ACTION_HREF));
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        try {
            String id = model.cachePolicy(curRealm, policyName);
            this.setPageSessionAttribute("policyCacheID", (Serializable)((Object)id));
            CachedPolicy cachedPolicy = model.getCachedPolicy(id);
            Policy policy = cachedPolicy.getPolicy();
            PolicyOpViewBeanBase vb = policy.isReferralPolicy() ? (PolicyOpViewBeanBase)this.getViewBean(PolicyReferralEditViewBean.class) : (PolicyOpViewBeanBase)this.getViewBean(PolicyNormalEditViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    public void handleTblButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_SEARCH);
        table.restoreStateData();
        Integer[] selected = this.tblModel.getSelectedRows();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        List cache = (List)szCache.getSerializedObj();
        HashSet<String> names = new HashSet<String>(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            names.add((String)cache.get(selected[i]));
        }
        try {
            PolicyModel model = (PolicyModel)this.getModel();
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            model.deletePolicies(curRealm, names);
            if (selected.length == 1) {
                this.setInlineAlertMessage("info", "message.information", "policy.message.deleted");
            } else {
                this.setInlineAlertMessage("info", "message.information", "policy.message.deleted.pural");
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(this.getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/oneBtnPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)this.getBackButtonLabel());
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToRealmView(event);
    }
}

