/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.federation;

import com.sun.identity.authentication.modules.federation.FederationPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.plugin.session.impl.FMSessionProvider;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class Federation
extends AMLoginModule {
    private String userName = null;
    private Principal userPrincipal = null;
    private static final String fmAuthFederation = "fmAuthFederation";
    private static Debug debug = Debug.getInstance((String)"fmAuthFederation");
    private ResourceBundle bundle = null;
    private static String AUTH_LEVEL = "sunAMAuthFederationAuthLevel";
    private CallbackHandler callbackHandler;

    public Federation() {
        debug.message("Federation()");
    }

    public void init(Subject subject, Map sharedState, Map options) {
        String authLevelStr;
        debug.message("in initialize...");
        Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(fmAuthFederation, locale);
        if (debug.messageEnabled()) {
            debug.message("fmAuthFederation Authentication resource bundle locale=" + locale);
        }
        this.callbackHandler = this.getCallbackHandler();
        if (options != null && (authLevelStr = CollectionHelper.getMapAttr((Map)options, (String)AUTH_LEVEL)) != null) {
            try {
                this.setAuthLevel(Integer.parseInt(authLevelStr));
            }
            catch (Exception e) {
                debug.error("Unable to set auth level " + authLevelStr, (Throwable)e);
            }
        }
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        String randomSecret = null;
        String principalName = null;
        String authLevel = null;
        try {
            Callback[] cbs = new Callback[]{new NameCallback("randomSecret"), new NameCallback("principalName"), new NameCallback("AuthLevel")};
            this.callbackHandler.handle(cbs);
            randomSecret = ((NameCallback)cbs[0]).getName();
            principalName = ((NameCallback)cbs[1]).getName();
            authLevel = ((NameCallback)cbs[2]).getName();
        }
        catch (IllegalArgumentException ill) {
            throw new AuthLoginException(fmAuthFederation, "IllegalArgs", null);
        }
        catch (IOException ioe) {
            throw new AuthLoginException((Throwable)ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw new AuthLoginException(fmAuthFederation, "UnsupportedCallback", null);
        }
        if (!FMSessionProvider.matchSecret(randomSecret)) {
            throw new AuthLoginException(fmAuthFederation, "NoMatchingSecret", null);
        }
        debug.message("Module is successful");
        this.storeUsernamePasswd(principalName, null);
        this.userName = principalName;
        if (authLevel != null && authLevel.length() != 0) {
            try {
                int authLevelInt = Integer.parseInt(authLevel);
                this.setAuthLevel(authLevelInt);
            }
            catch (Exception e) {
                debug.error("Unable to set auth level " + authLevel, (Throwable)e);
            }
        }
        return -1;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal == null && this.userName != null) {
            this.userPrincipal = new FederationPrincipal(this.userName);
        }
        return this.userPrincipal;
    }

    public void destroyModuleState() {
        debug.message("clean up module state");
        this.userName = null;
        this.userPrincipal = null;
    }
}

