/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.FederationException;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.message.FSNameRegistrationRequest;
import com.sun.identity.federation.message.FSNameRegistrationResponse;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSDefaultSPAdapter
implements FederationSPAdapter {
    private final String ROOT_REALM = "/";
    private String realm = null;

    public void initialize(String hostedProviderID, Set initParams) {
        FSUtils.debug.message("In FSDefaultSPAdapter.initialize.");
        if (initParams != null && !initParams.isEmpty()) {
            for (String envValue : initParams) {
                if (!envValue.toUpperCase().startsWith("REALM=")) continue;
                try {
                    this.realm = envValue.substring("REALM=".length(), envValue.length());
                }
                catch (Exception e) {
                    if (!FSUtils.debug.warningEnabled()) break;
                    FSUtils.debug.warning("FSDefaultSPAdapter.init:Could not get realm:", (Throwable)e);
                }
                break;
            }
        }
        if (this.realm == null || this.realm.length() == 0) {
            this.realm = "/";
        }
    }

    public void preSSOFederationRequest(String hostedProviderID, String idpProviderID, HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest) {
        FSUtils.debug.message("In FSDefaultSPAdapter.preSSOFederationRequest.");
    }

    public void preSSOFederationProcess(String hostedProviderID, HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, FSAuthnResponse authnResponse, FSResponse samlResponse) throws FederationException {
        FSUtils.debug.message("In FSDefaultSPAdapter.preSSOFederationProcess.");
    }

    public boolean postSSOFederationSuccess(String hostedEntityID, HttpServletRequest request, HttpServletResponse response, Object ssoToken, FSAuthnRequest authnRequest, FSAuthnResponse authnResponse, FSResponse samlResponse) throws FederationException {
        block24: {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSDefaultSPAdapter.postFedSuccess, process " + hostedEntityID);
            }
            boolean isFederation = false;
            if (authnRequest == null) {
                FSUtils.debug.error("FSDefaultSPAdapter.postFedSuccess null");
            } else {
                String nameIDPolicy = authnRequest.getNameIDPolicy();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSDefaultSPAdapter.postSuccess " + nameIDPolicy);
                }
                if (nameIDPolicy.equals("federated")) {
                    isFederation = true;
                }
            }
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            if (isFederation && adminToken != null) {
                try {
                    String metaAlias;
                    String univId;
                    Set amIdSet;
                    String idpEntityId;
                    String nameId;
                    block25: {
                        nameId = null;
                        List assertions = null;
                        idpEntityId = null;
                        if (authnResponse != null) {
                            assertions = authnResponse.getAssertion();
                            idpEntityId = authnResponse.getProviderId();
                        } else {
                            assertions = samlResponse.getAssertion();
                        }
                        FSAssertion assertion = (FSAssertion)assertions.iterator().next();
                        if (idpEntityId == null) {
                            idpEntityId = assertion.getIssuer();
                        }
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAdapter.postSuccess: idp=" + idpEntityId);
                        }
                        for (Statement statement : assertion.getStatement()) {
                            int stmtType = statement.getStatementType();
                            if (stmtType != 1) continue;
                            FSAuthenticationStatement authStatement = (FSAuthenticationStatement)statement;
                            FSSubject subject = (FSSubject)authStatement.getSubject();
                            IDPProvidedNameIdentifier ni = subject.getIDPProvidedNameIdentifier();
                            if (ni == null) {
                                ni = subject.getNameIdentifier();
                            }
                            if (ni != null) {
                                nameId = ni.getName();
                            }
                            if (!FSUtils.debug.messageEnabled()) break;
                            FSUtils.debug.message("FSAdapter.postSuccess: found name id =" + nameId);
                            break;
                        }
                        if (nameId == null) {
                            FSUtils.debug.warning("FSAdapter.postSuc : null nameID");
                            return false;
                        }
                        HashMap map = new HashMap();
                        HashSet<String> set = new HashSet<String>();
                        set.add("|" + hostedEntityID + "|" + nameId + "|");
                        map.put("iplanet-am-user-federation-info-key", set);
                        AMIdentityRepository idRepo = new AMIdentityRepository(adminToken, ((SSOToken)ssoToken).getProperty("Organization"));
                        IdSearchControl searchControl = new IdSearchControl();
                        searchControl.setTimeOut(0);
                        searchControl.setMaxResults(0);
                        searchControl.setAllReturnAttributes(false);
                        searchControl.setSearchModifiers(IdSearchOpModifier.AND, map);
                        IdSearchResults searchResults = idRepo.searchIdentities(IdType.USER, "*", searchControl);
                        amIdSet = searchResults.getSearchResults();
                        if (amIdSet.size() <= 1) break block24;
                        univId = ((SSOToken)ssoToken).getProperty("sun.am.UniversalIdentifier");
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAdapter.postSuccess: found " + amIdSet.size() + " federation with same ID as " + univId);
                        }
                        metaAlias = null;
                        try {
                            SPDescriptorConfigElement spConfig;
                            IDFFMetaManager metaManager = new IDFFMetaManager(ssoToken);
                            if (metaManager != null && (spConfig = metaManager.getSPDescriptorConfig(this.realm, hostedEntityID)) != null) {
                                metaAlias = spConfig.getMetaAlias();
                            }
                        }
                        catch (IDFFMetaException ie) {
                            if (!FSUtils.debug.messageEnabled()) break block25;
                            FSUtils.debug.message("FSAdapter.postSuccess: couldn't find meta alias:", (Throwable)ie);
                        }
                    }
                    FSAccountManager accManager = FSAccountManager.getInstance(metaAlias);
                    FSAccountFedInfoKey fedInfoKey = new FSAccountFedInfoKey(hostedEntityID, nameId);
                    for (AMIdentity amId : amIdSet) {
                        String tmpUnivId = IdUtils.getUniversalId((AMIdentity)amId);
                        if (univId.equalsIgnoreCase(tmpUnivId)) continue;
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAdapter.postSucces, remove fed info for user " + tmpUnivId);
                        }
                        accManager.removeAccountFedInfo(tmpUnivId, fedInfoKey, idpEntityId);
                    }
                }
                catch (FSAccountMgmtException f) {
                    FSUtils.debug.warning("FSDefaultSPAdapter.postSSOSuccess", (Throwable)f);
                }
                catch (IdRepoException i) {
                    FSUtils.debug.warning("FSDefaultSPAdapter.postSSOSuccess", (Throwable)i);
                }
                catch (SSOException e) {
                    FSUtils.debug.warning("FSDefaultSPAdapter.postSSOSuccess", (Throwable)e);
                }
            }
        }
        return false;
    }

    public boolean postSSOFederationFailure(String hostedEntityID, HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, FSAuthnResponse authnResponse, FSResponse samlResponse, int failureCode) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSDefaultSPAdapter.postFedFailure, process " + hostedEntityID + "\nfailure code=" + failureCode);
        }
        String baseURL = FSServiceUtils.getBaseURL((HttpServletRequest)request);
        String relayState = null;
        if (authnRequest != null) {
            relayState = authnRequest.getRelayState();
        }
        String framedLoginPageURL = FSServiceUtils.getCommonLoginPageURL((String)FSServiceUtils.getMetaAlias((HttpServletRequest)request), (String)relayState, null, (HttpServletRequest)request, (String)baseURL);
        StringBuffer sb = new StringBuffer();
        sb.append(framedLoginPageURL).append("&").append("FailureCode").append("=").append(failureCode);
        if (failureCode == 1 || failureCode == 2) {
            Status status = null;
            status = failureCode == 1 ? authnResponse.getStatus() : samlResponse.getStatus();
            StatusCode firstLevelStatusCode = status.getStatusCode();
            if (firstLevelStatusCode == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSDefaultSPAdapter.postSSOFederationFailure: Status is null");
                }
                return false;
            }
            StatusCode secondLevelStatusCode = firstLevelStatusCode.getStatusCode();
            if (secondLevelStatusCode == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSDefaultSPAdapter.postSSOFederationFailure: Second level status is empty");
                }
                return false;
            }
            String statusValue = URLEncDec.encode((String)secondLevelStatusCode.getValue());
            sb.append("&").append("StatusCode").append("=").append(statusValue);
        }
        String redirectURL = sb.toString();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSDefaultSPAdapter.postSSOFederationFailure. URL to be redirected: " + redirectURL);
        }
        try {
            response.setHeader("Location", redirectURL);
            response.sendRedirect(redirectURL);
        }
        catch (IOException io) {
            FSUtils.debug.error("FSDefaultSPAdapter.postSSOFedFailure", (Throwable)io);
            return false;
        }
        return true;
    }

    public void postRegisterNameIdentifierSuccess(String hostedProviderID, HttpServletRequest request, HttpServletResponse response, String userDN, FSNameRegistrationRequest regRequest, FSNameRegistrationResponse regResponse, String regProfile) {
        FSUtils.debug.message("In FSDefaultSPAdapter.postRegistrationNameIdentifierSuccess");
    }

    public void postTerminationNotificationSuccess(String hostedProviderID, HttpServletRequest request, HttpServletResponse response, String userDN, FSFederationTerminationNotification notification, String termProfile) {
        FSUtils.debug.message("In FSDefaultSPAdapter.postTerminationNotificationSuccess.");
    }

    public void preSingleLogoutProcess(String hostedProviderID, HttpServletRequest request, HttpServletResponse response, String userDN, FSLogoutNotification logoutRequest, FSLogoutResponse logoutResponse, String sloProfile) {
        FSUtils.debug.message("In FSDefaultSPAdapter.preSingleLogoutProcess.");
    }

    public void postSingleLogoutSuccess(String hostedProviderID, HttpServletRequest request, HttpServletResponse response, String userDN, FSLogoutNotification logoutRequest, FSLogoutResponse logoutResponse, String sloProfile) {
        FSUtils.debug.message("In FSDefaultSPAdapter.postSingleLogoutSuccess.");
    }
}

