/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.setup.ClientConfiguratorFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class SetupClientWARSamples {
    public static final String CLIENT_WAR_CONFIG_TOP_DIR = "OpenSSOClient";
    private static final String TAG_SERVER_PROTOCOL = "SERVER_PROTOCOL";
    private static final String TRUST_ALL_CERTS = "com.iplanet.am.jssproxy.trustAllServerCerts=true\n";
    ServletContext servletContext;

    public SetupClientWARSamples(ServletContext context) {
        this.servletContext = context;
    }

    public void createAMConfigProperties(String configFile, String templateFile, Properties properties) throws IOException {
        File file;
        String parentDir;
        String consoleRemote;
        String configDir;
        URL uRL;
        String content = this.getFileContent(templateFile);
        String uriWithSlash = (String)properties.get("DEPLOY_URI");
        if (uriWithSlash != null && uriWithSlash.length() > 0) {
            if (uriWithSlash.charAt(0) != '/') {
                uriWithSlash = "/" + uriWithSlash;
                properties.put("DEPLOY_URI", uriWithSlash);
            }
            content = content.replaceAll("/@DEPLOY_URI@", uriWithSlash);
        }
        for (String string : properties.keySet()) {
            content = content.replaceAll("@" + string + "@", (String)properties.get(string));
        }
        String protocol = (String)properties.get(TAG_SERVER_PROTOCOL);
        if (protocol.equalsIgnoreCase("https")) {
            content = content + TRUST_ALL_CERTS;
        }
        if ((uRL = this.servletContext.getResource("/WEB-INF/lib/openssoclientsdk.jar")) != null) {
            String keystoreLocation = uRL.toString().substring(5);
            int index = keystoreLocation.indexOf("WEB-INF");
            keystoreLocation = keystoreLocation.substring(0, index - 1);
            content = content.replaceAll("@BASE_DIR@", keystoreLocation);
        }
        if ((configDir = (String)properties.get("CONFIG_DIR")) != null && configDir.trim().length() > 0) {
            content = content + "\ncom.iplanet.services.configpath=" + configDir + "\n";
        }
        if ((consoleRemote = (String)properties.get("CONSOLE_REMOTE")) != null && consoleRemote.equals("true")) {
            content = content.replaceAll("com.iplanet.am.sdk.remote", "com.iplanet.am.sdk.ldap");
        }
        if ((parentDir = (file = new File(configFile)).getParent()) != null && !(file = new File(parentDir)).exists()) {
            file.mkdirs();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(configFile));
        out.write(content);
        out.close();
    }

    private String getFileContent(String fileName) throws IOException {
        InputStream in = this.servletContext.getResourceAsStream(fileName);
        if (in == null) {
            throw new IOException("Unable to open " + fileName);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer buff = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            buff.append(line).append("\n");
            line = reader.readLine();
        }
        reader.close();
        return buff.toString();
    }

    public void setAMConfigProperties(String configFile) throws ServletException {
        block12: {
            FileInputStream fileStr = null;
            try {
                fileStr = new FileInputStream(configFile);
                if (fileStr != null) {
                    Properties props = new Properties();
                    props.load(fileStr);
                    SystemProperties.initializeProperties((Properties)props);
                    ClientConfiguratorFilter.isConfigured = true;
                    break block12;
                }
                throw new ServletException("Unable to open: " + configFile);
            }
            catch (FileNotFoundException fexp) {
                fexp.printStackTrace();
                throw new ServletException(fexp.getMessage());
            }
            catch (IOException ioexp) {
                ioexp.printStackTrace();
                throw new ServletException(ioexp.getMessage());
            }
            finally {
                if (fileStr != null) {
                    try {
                        fileStr.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    private void createKeystoreFile() throws IOException {
        String location = System.getProperty("user.home") + File.separator;
        InputStream in = this.servletContext.getResourceAsStream("/keystore.jks");
        byte[] b = new byte[2007];
        in.read(b);
        in.close();
        FileOutputStream fos = new FileOutputStream(location + "keystore.jks");
        fos.write(b);
        fos.flush();
        fos.close();
    }

    public static String getNormalizedRealPath(ServletContext servletCtx) throws ServletException {
        String path = null;
        if (servletCtx != null && (path = SetupClientWARSamples.getAppResource(servletCtx)) != null) {
            String realPath = servletCtx.getRealPath("/");
            if (realPath != null && realPath.length() > 0) {
                realPath = realPath.replace('\\', '/');
                path = realPath.replaceAll("/", "_");
            } else {
                path = path.replaceAll("/", "_");
            }
            int idx = path.indexOf(":");
            if (idx != -1) {
                path = path.substring(idx + 1);
            }
        }
        return path;
    }

    private static String getAppResource(ServletContext servletCtx) throws ServletException {
        if (servletCtx != null) {
            try {
                URL turl = servletCtx.getResource("/");
                return turl.getPath();
            }
            catch (MalformedURLException mue) {
                throw new ServletException(mue.getMessage());
            }
        }
        return null;
    }
}

