/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.AMTokenProvider;
import com.sun.identity.wss.security.KerberosConfiguration;
import com.sun.identity.wss.security.KerberosTokenSpec;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.security.X509TokenSpec;
import java.security.Key;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BinarySecurityToken
implements SecurityToken {
    private String[] certAlias = null;
    private String valueType = null;
    private String encodingType = null;
    private String id = null;
    private String xmlString = null;
    private String value = null;
    private static final String BINARY_SECURITY_TOKEN = "BinarySecurityToken";
    private static final String ENCODING_TYPE = "EncodingType";
    private static final String VALUE_TYPE = "ValueType";
    private static final String ID = "Id";
    private static Debug debug = WSSUtils.debug;
    private static ResourceBundle bundle = WSSUtils.bundle;
    private String tokenType = "urn:sun:wss:x509token";
    private String kerberosToken = null;
    private Key secretKey = null;
    private KerberosTokenSpec kbSpec = null;
    public static final String X509V3 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    public static final String PKCS7 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7";
    public static final String PKIPATH = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKIPath";
    public static final String BASE64BINARY = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    public static final String HEXBINARY = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#HexBinary";

    private BinarySecurityToken() {
    }

    public BinarySecurityToken(X509TokenSpec tokenSpec) throws SecurityException {
        if (tokenSpec == null) {
            throw new SecurityException(bundle.getString("invalidTokenSpec"));
        }
        this.valueType = tokenSpec.getValueType();
        this.encodingType = tokenSpec.getEncodingType();
        this.certAlias = tokenSpec.getSubjectCertAlias();
        if (this.valueType == null || this.encodingType == null || this.certAlias == null || this.certAlias.length == 0) {
            debug.error("BinarySecurityToken.constructor: invalid token spec");
            throw new SecurityException(bundle.getString("invalidTokenSpec"));
        }
        byte[] data = null;
        try {
            if (PKIPATH.equals(this.valueType)) {
                List certs = AMTokenProvider.getX509Certificates(this.certAlias);
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                CertPath path = factory.generateCertPath(certs);
                data = path.getEncoded();
            } else if (X509V3.equals(this.valueType)) {
                X509Certificate certificate = AMTokenProvider.getX509Certificate(this.certAlias[0]);
                data = certificate.getEncoded();
            } else {
                debug.error("BinarySecurityToken.constructor: unsupportedvalue type. " + this.valueType);
                throw new SecurityException(bundle.getString("invalidTokenSpec"));
            }
            this.value = Base64.encode((byte[])data);
        }
        catch (CertificateEncodingException cee) {
            debug.error("BinarySecurityToken.constructor:: Certificate Encoding Exception", (Throwable)cee);
            throw new SecurityException(bundle.getString("invalidCertificate"));
        }
        catch (CertificateException ce) {
            debug.error("BinarySecurityToken.constructor:: Certificate Exception", (Throwable)ce);
            throw new SecurityException(bundle.getString("invalidCertificate"));
        }
        this.id = SAMLUtils.generateID();
    }

    public BinarySecurityToken(X509Certificate cert, String valueType, String encodingType) throws SecurityException {
        byte[] data;
        try {
            data = cert.getEncoded();
        }
        catch (CertificateEncodingException ce) {
            debug.error("BinarySecurityToken. Invalid Certifcate", (Throwable)ce);
            throw new SecurityException(bundle.getString("invalidCertificate"));
        }
        this.value = Base64.encode((byte[])data);
        this.valueType = valueType;
        this.encodingType = encodingType;
    }

    public BinarySecurityToken(KerberosTokenSpec kbSpec) throws SecurityException {
        this.kbSpec = kbSpec;
        this.getKerberosToken();
        this.value = this.kerberosToken;
        this.valueType = kbSpec.getValueType();
        this.encodingType = kbSpec.getEncodingType();
        this.tokenType = "urn:sun:wss:kerberostoken";
        this.id = SAMLUtils.generateID();
    }

    public BinarySecurityToken(Element token) throws SecurityException {
        if (token == null) {
            debug.error("BinarySecurityToken: null input token");
            throw new IllegalArgumentException(bundle.getString("nullInputParameter"));
        }
        String elementName = token.getLocalName();
        if (elementName == null) {
            debug.error("BinarySecurityToken: local name missing");
            throw new SecurityException(bundle.getString("nullInput"));
        }
        if (!elementName.equals(BINARY_SECURITY_TOKEN)) {
            debug.error("BinarySecurityToken: invalid binary token");
            throw new SecurityException(bundle.getString("invalidElement") + ":" + elementName);
        }
        NamedNodeMap nm = token.getAttributes();
        if (nm == null) {
            debug.error("BinarySecurityToken: missing token attrs in element");
            throw new SecurityException(bundle.getString("missingAttribute"));
        }
        int len = nm.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)nm.item(i);
            String localName = attr.getLocalName();
            if (localName == null) continue;
            if (localName.equals(ID)) {
                this.id = attr.getValue();
                continue;
            }
            if (localName.equals(ENCODING_TYPE)) {
                this.encodingType = this.trimPrefix(attr.getValue());
                continue;
            }
            if (!localName.equals(VALUE_TYPE)) continue;
            this.valueType = this.trimPrefix(attr.getValue());
        }
        if (this.id == null || this.id.length() == 0) {
            debug.error("BinarySecurityToken: ID missing");
            throw new SecurityException(bundle.getString("missingAttribute") + " : " + ID);
        }
        if (this.encodingType == null) {
            debug.error("BinarySecurityToken: encoding type missing");
            throw new SecurityException(bundle.getString("missingAttribute") + " : " + ENCODING_TYPE);
        }
        if (this.valueType == null) {
            debug.error("BinarySecurityToken: valueType missing");
            throw new SecurityException(bundle.getString("missingAttribute") + " : " + VALUE_TYPE);
        }
        if (this.valueType.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ")) {
            this.tokenType = "urn:sun:wss:kerberostoken";
        }
        try {
            NodeList nodelist = token.getChildNodes();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                Node childNode = nodelist.item(i);
                if (childNode.getNodeType() == 1 || childNode.getNodeType() != 3) continue;
                this.value = SAMLUtils.removeNewLineChars((String)childNode.getNodeValue().trim());
            }
        }
        catch (Exception e) {
            debug.error("BinarySecurityToken: unable to get value", (Throwable)e);
            this.value = null;
        }
        if (this.value == null || this.value.length() == 0) {
            debug.error("BinarySecurityToken: value missing");
            throw new SecurityException(bundle.getString("missingValue"));
        }
        this.xmlString = XMLUtils.print((Node)token);
    }

    private void getKerberosToken() throws SecurityException {
        Subject clientSubject = this.getKerberosSubject();
        final String serviceName = this.kbSpec.getServicePrincipal();
        try {
            Subject.doAs(clientSubject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    GSSManager manager = GSSManager.getInstance();
                    Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
                    GSSName serverName = manager.createName(serviceName, null);
                    GSSContext context = manager.createContext(serverName, krb5Oid, null, 0);
                    byte[] token = new byte[]{};
                    token = context.initSecContext(token, 0, token.length);
                    String encodeToken = Base64.encode((byte[])token);
                    BinarySecurityToken.this.kerberosToken = encodeToken;
                    return null;
                }
            });
        }
        catch (Exception ge) {
            debug.error("BinarySecurityToken.getKerberosToken: GSS Error", (Throwable)ge);
            throw new SecurityException(ge.getMessage());
        }
        Set<Object> creds = clientSubject.getPrivateCredentials();
        for (Object privObject : creds) {
            KerberosTicket kerbTicket;
            if (!(privObject instanceof KerberosTicket) || !(kerbTicket = (KerberosTicket)privObject).getServer().getName().equals(serviceName)) continue;
            this.secretKey = kerbTicket.getSessionKey();
            break;
        }
    }

    private Subject getKerberosSubject() throws SecurityException {
        String kdcRealm = this.kbSpec.getKDCDomain();
        String kdcServer = this.kbSpec.getKDCServer();
        System.setProperty("java.security.krb5.realm", kdcRealm);
        System.setProperty("java.security.krb5.kdc", kdcServer);
        Configuration config = Configuration.getConfiguration();
        KerberosConfiguration kc = null;
        if (config instanceof KerberosConfiguration) {
            kc = (KerberosConfiguration)config;
            kc.setRefreshConfig("true");
            kc.setPrincipalName(this.kbSpec.getServicePrincipal());
            kc.setTicketCacheDir(this.kbSpec.getTicketCacheDir());
        } else {
            kc = new KerberosConfiguration(config);
            kc.setRefreshConfig("true");
            kc.setPrincipalName(this.kbSpec.getServicePrincipal());
            kc.setTicketCacheDir(this.kbSpec.getTicketCacheDir());
        }
        Configuration.setConfiguration(kc);
        try {
            LoginContext lc = new LoginContext("com.sun.identity.wss.webservicesclient");
            lc.login();
            return lc.getSubject();
        }
        catch (LoginException ex) {
            throw new SecurityException(ex.getMessage());
        }
    }

    private String trimPrefix(String val) {
        if (val.indexOf("wsse") == -1) {
            return val;
        }
        int pos = val.indexOf(":");
        if (pos == -1) {
            return val;
        }
        if (pos == val.length()) {
            return "";
        }
        return val.substring(pos + 1);
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getId() {
        return this.id;
    }

    public String getTokenValue() {
        return this.value;
    }

    public Key getSecretKey() {
        return this.secretKey;
    }

    public String toString() {
        if (this.xmlString == null) {
            StringBuffer sb = new StringBuffer(300);
            sb.append("<").append("wsse").append(":").append(BINARY_SECURITY_TOKEN).append(" ").append("xmlns:wsse").append("=\"").append("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd").append("\" ").append("xmlns:wsu").append("=\"").append("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd").append("\" ").append("wsu:Id").append("=\"").append(this.id).append("\" ").append(VALUE_TYPE).append("=\"").append(this.valueType).append("\" ").append(ENCODING_TYPE).append("=\"").append(this.encodingType).append("\">\n").append(this.value.toString()).append("\n").append("</").append("wsse").append(":").append(BINARY_SECURITY_TOKEN).append(">\n");
            this.xmlString = sb.toString();
        }
        return this.xmlString;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String[] getSubjectCertAlias() {
        return this.certAlias;
    }

    public String getSigningId() {
        return this.id;
    }

    public Element toDocumentElement() throws SecurityException {
        Document document = XMLUtils.toDOMDocument((String)this.toString(), (Debug)WSSUtils.debug);
        if (document == null) {
            throw new SecurityException(WSSUtils.bundle.getString("cannotConvertToDocument"));
        }
        return document.getDocumentElement();
    }
}

