/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.WSSUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FAMSecurityToken
implements SecurityToken {
    private static Debug debug = WSSUtils.debug;
    private String tokenID = null;
    private String tokenType = null;

    public FAMSecurityToken(SSOToken ssoToken) throws SecurityException {
        try {
            SSOTokenManager.getInstance().validateToken(ssoToken);
            this.tokenID = ssoToken.getTokenID().toString();
            this.tokenType = "urn:sun:wss:ssotoken";
        }
        catch (SSOException se) {
            throw new SecurityException(se.getMessage());
        }
    }

    public FAMSecurityToken(Element element) throws SecurityException {
        if (element == null) {
            throw new SecurityException(WSSUtils.bundle.getString("nullInput"));
        }
        String localName = element.getLocalName();
        if (!"FAMToken".equals(localName)) {
            throw new SecurityException(WSSUtils.bundle.getString("invalidElement"));
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        if (length == 0) {
            throw new SecurityException(WSSUtils.bundle.getString("invalidElement"));
        }
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("TokenValue")) {
                this.tokenID = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (!childName.equals("TokenType")) continue;
            this.tokenType = XMLUtils.getElementValue((Element)((Element)child));
        }
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getTokenID() {
        return this.tokenID;
    }

    public Element toDocumentElement() throws SecurityException {
        StringBuffer sb = new StringBuffer();
        sb.append("<fam:FAMToken xmlns:fam=\"").append("http://www.sun.com/identity/famtoken").append("\"").append(">").append("\n").append("<fam:TokenValue>").append(this.tokenID).append("</fam:TokenValue>").append("\n").append("<fam:TokenType>").append(this.tokenType).append("</fam:TokenType>").append("\n").append("</fam:FAMToken>");
        Document document = XMLUtils.toDOMDocument((String)sb.toString(), (Debug)debug);
        return document.getDocumentElement();
    }
}

