/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.assertion.AttributeStatement;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.SubjectConfirmation;
import com.sun.identity.saml2.assertion.SubjectConfirmationData;
import com.sun.identity.wss.security.SAML2Token;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityPrincipal;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.WSSUtils;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.w3c.dom.Element;

public class SAML2TokenUtils {
    public static X509Certificate getCertificate(SecurityToken securityToken) throws SecurityException {
        SAML2Token saml2Token = (SAML2Token)securityToken;
        if (saml2Token.isSenderVouches()) {
            return null;
        }
        Assertion assertion = saml2Token.getAssertion();
        Element keyInfo = SAML2TokenUtils.getKeyInfo(assertion);
        return WSSUtils.getCertificate(keyInfo);
    }

    public static Element getKeyInfo(Assertion assertion) {
        try {
            com.sun.identity.saml2.assertion.Subject subj = assertion.getSubject();
            List list = subj.getSubjectConfirmation();
            if (list == null) {
                return null;
            }
            SubjectConfirmation subjConfirmation = (SubjectConfirmation)list.get(0);
            SubjectConfirmationData subjConfirmationData = subjConfirmation.getSubjectConfirmationData();
            if (subjConfirmationData == null) {
                if (WSSUtils.debug.messageEnabled()) {
                    WSSUtils.debug.message("SAML2TokenUtils.getKeyInfo: No subject confirmation data");
                }
                return null;
            }
            List content = subjConfirmationData.getContent();
            if (content == null || content.isEmpty()) {
                if (WSSUtils.debug.messageEnabled()) {
                    WSSUtils.debug.message("SAMLTokenUtils.getKeyInfo: KeyInfo not found");
                }
                return null;
            }
            return (Element)content.get(0);
        }
        catch (Exception e) {
            WSSUtils.debug.error("SAML2TokenUtils.getKeyInfo Exception: ", (Throwable)e);
            return null;
        }
    }

    public static boolean validateAssertion(Assertion assertion, Subject subject, Map secureAttrs) throws SecurityException {
        if (assertion.getConditions() != null && !assertion.getConditions().checkDateValidity(System.currentTimeMillis() + WSSUtils.getTimeSkew())) {
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("SAML2TokenUtils.validateAssertionToken:: assertion time is not valid");
            }
            return false;
        }
        com.sun.identity.saml2.assertion.Subject sub = assertion.getSubject();
        if (sub == null) {
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("SAML2TokenUtils.validateAssertio:: Assertion does not have subject");
            }
            return false;
        }
        NameID ni = sub.getNameID();
        if (ni == null) {
            return false;
        }
        SecurityPrincipal principal = new SecurityPrincipal(ni.getValue());
        subject.getPrincipals().add(principal);
        Element keyInfo = SAML2TokenUtils.getKeyInfo(assertion);
        if (keyInfo != null) {
            X509Certificate cert = WSSUtils.getCertificate(keyInfo);
            subject.getPublicCredentials().add(cert);
        }
        WSSUtils.setRoles(subject, ni.getValue());
        List attributeStatements = assertion.getAttributeStatements();
        if (!attributeStatements.isEmpty()) {
            AttributeStatement attribStatement = (AttributeStatement)attributeStatements.get(0);
            List attributes = attribStatement.getAttribute();
            for (Attribute attribute : attributes) {
                secureAttrs.put(attribute.getName(), attribute.getAttributeValueString());
            }
        }
        return true;
    }
}

