/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security.handler;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.provider.ProviderConfig;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.security.SecurityPrincipal;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.security.handler.HTTPRequestHandlerInterface;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

public class HTTPRequestHandler
implements HTTPRequestHandlerInterface {
    private static final String GOTO = "goto";
    private static final String AUTHENTICATED_USERS = "AUTHENTICATED_USERS";
    private static Debug debug = WSSUtils.debug;
    private static ResourceBundle bundle = WSSUtils.bundle;
    private static final String PROVIDER_NAME = "providername";
    private String providername = null;

    public void init(Map config) {
        this.providername = (String)config.get(PROVIDER_NAME);
    }

    public boolean shouldAuthenticate(Subject subject, HttpServletRequest request) {
        if (this.setTokenInSubject(subject, request)) {
            if (debug.messageEnabled()) {
                debug.message("HTTPRequestHandler.shouldAuthenticate:: valid SSOToken exists");
            }
            return false;
        }
        if (debug.messageEnabled()) {
            debug.message("HTTPRequestHandler.shouldAuthenticate:: providername : " + this.providername);
        }
        if (this.providername == null || this.providername.length() == 0) {
            return true;
        }
        try {
            ProviderConfig pc = ProviderConfig.getProvider(this.providername, "WSCAgent");
            if (pc == null) {
                return true;
            }
            List secMechs = pc.getSecurityMechanisms();
            if (secMechs.contains("urn:sun:liberty:discovery:security")) {
                return true;
            }
            if (!pc.forceUserAuthentication()) {
                this.setPrincipal(subject);
                return false;
            }
        }
        catch (ProviderException pe) {
            debug.error("HTTPProvider.shouldAuthenticate::  provider exception", (Throwable)pe);
        }
        return true;
    }

    private boolean setTokenInSubject(Subject subject, HttpServletRequest request) {
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken ssoToken = manager.createSSOToken(request);
            if (manager.isValidToken(ssoToken)) {
                this.setPrincipal(subject);
                this.addSSOToken(ssoToken, subject);
                if (debug.messageEnabled()) {
                    debug.message("HTTPRequestHandler.setTokenInSubject:  Valid SSOToken ");
                }
                return true;
            }
            return false;
        }
        catch (SSOException se) {
            if (debug.messageEnabled()) {
                debug.message("HTTPRequestHandler.setTokenInSubject: Invalid SSOToken ");
            }
            return false;
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("HTTPRequestHandler.setTokenInSubject: Can not set SSOToken in Subject ", (Throwable)e);
            }
            return false;
        }
    }

    public String getLoginURL(HttpServletRequest request) {
        String loginURL = SystemConfigurationUtil.getProperty((String)"com.sun.identity.loginurl");
        StringBuffer requestURL = request.getRequestURL();
        String gotoparam = SystemConfigurationUtil.getProperty((String)"com.sun.identity.httpprovider.goto", (String)GOTO);
        loginURL = loginURL + "?" + gotoparam + "=" + requestURL.toString();
        String query = request.getQueryString();
        if (query != null) {
            loginURL = loginURL + "&" + query;
        }
        return loginURL;
    }

    private void addSSOToken(SSOToken ssoToken, Subject subject) throws Exception {
        final SSOToken sToken = ssoToken;
        final Subject subj = subject;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                subj.getPrivateCredentials().add(sToken);
                return null;
            }
        });
    }

    private void setPrincipal(Subject subject) {
        SecurityPrincipal p = new SecurityPrincipal(SystemConfigurationUtil.getProperty((String)"com.sun.identity.jsr196.authenticated.user", (String)AUTHENTICATED_USERS));
        subject.getPrincipals().add(p);
    }
}

