/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts;

import com.iplanet.sso.SSOToken;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.config.FAMSTSConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class STSUtils {
    private static final String AGENT_TYPE_ATTR = "AgentType";
    private static final String WSP_ENDPOINT = "WSPEndpoint";
    public static Debug debug = Debug.getInstance((String)"WebServicesSecurity");
    public static ResourceBundle bundle = ResourceBundle.getBundle("famSTS");

    public static Map getAgentAttributes(String endpoint, String endPointAtrrName, Set attrNames, String agentType) {
        try {
            SSOToken adminToken = WSSUtils.getAdminToken();
            AMIdentityRepository idRepo = new AMIdentityRepository(adminToken, "/");
            IdSearchControl control = new IdSearchControl();
            control.setAllReturnAttributes(true);
            control.setTimeOut(0);
            HashMap kvPairMap = new HashMap();
            HashSet<String> set = new HashSet<String>();
            set.add(agentType);
            kvPairMap.put(AGENT_TYPE_ATTR, set);
            set = new HashSet();
            set.add(endpoint);
            if (endPointAtrrName == null || endPointAtrrName.length() == 0) {
                endPointAtrrName = WSP_ENDPOINT;
            }
            kvPairMap.put(endPointAtrrName, set);
            control.setSearchModifiers(IdSearchOpModifier.OR, kvPairMap);
            IdSearchResults results = idRepo.searchIdentities(IdType.AGENTONLY, "*", control);
            Set agents = results.getSearchResults();
            if (!agents.isEmpty()) {
                Map attrs = results.getResultAttributes();
                AMIdentity provider = (AMIdentity)agents.iterator().next();
                Map agentConfig = null;
                agentConfig = attrNames != null ? provider.getAttributes(attrNames) : provider.getAttributes();
                agentConfig.put("Name", provider.getName());
                return agentConfig;
            }
            return new HashMap();
        }
        catch (Exception ex) {
            debug.error("STSUtils.getAgentAttributes: Exception", (Throwable)ex);
            return new HashMap();
        }
    }

    public static Map getSTSSAMLAttributes(FAMSTSConfiguration stsConfig) {
        String nameIDMapper;
        String ns;
        HashMap<String, Set> map = new HashMap<String, Set>();
        HashSet<String> set = null;
        Set attributes = stsConfig.getSAMLAttributeMapping();
        if (attributes != null) {
            map.put("SAMLAttributeMapping", attributes);
        }
        if ((ns = stsConfig.getSAMLAttributeNamespace()) != null) {
            set = new HashSet<String>();
            set.add(ns);
            map.put("AttributeNamespace", set);
        }
        if ((nameIDMapper = stsConfig.getNameIDMapper()) != null) {
            set = new HashSet();
            set.add(nameIDMapper);
            map.put("NameIDMapper", set);
        }
        set = new HashSet();
        set.add(Boolean.toString(stsConfig.shouldIncludeMemberships()));
        map.put("includeMemberships", set);
        return map;
    }

    public static String getAppliesTo(Element element) {
        NodeList nl = element.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address");
        if (nl.getLength() == 0) {
            return null;
        }
        Element addressE = (Element)nl.item(0);
        return XMLUtils.getElementValue((Element)addressE);
    }

    public static SOAPMessage prepareSOAPMessage(String url, String wstVersion) throws FAMSTSException {
        try {
            String soapVersion = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.soapversion", (String)"1.2");
            MessageFactory mf = null;
            mf = soapVersion.equals("1.2") ? MessageFactory.newInstance((String)"SOAP 1.2 Protocol") : MessageFactory.newInstance();
            SOAPMessage soapMessage = mf.createMessage();
            SOAPEnvelope envelope = soapMessage.getSOAPPart().getEnvelope();
            SOAPHeader header = envelope.getHeader();
            if (header == null) {
                header = soapMessage.getSOAPPart().getEnvelope().addHeader();
            }
            header.setAttribute("xmlns:wsa", "http://www.w3.org/2005/08/addressing");
            SOAPPart soapPart = soapMessage.getSOAPPart();
            Element to = soapPart.createElementNS("http://www.w3.org/2005/08/addressing", "wsa:To");
            Text txtNode = soapPart.createTextNode(url);
            to.appendChild(txtNode);
            header.appendChild((Node)to);
            Element action = soapMessage.getSOAPPart().createElementNS("http://www.w3.org/2005/08/addressing", "wsa:Action");
            String issueAction = "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue";
            if ("1.3".equals(wstVersion)) {
                issueAction = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue";
            }
            txtNode = soapPart.createTextNode(issueAction);
            action.appendChild(txtNode);
            header.appendChild((Node)action);
            Element replyTo = soapMessage.getSOAPPart().createElementNS("http://www.w3.org/2005/08/addressing", "wsa:ReplyTo");
            Element address = soapMessage.getSOAPPart().createElementNS("http://www.w3.org/2005/08/addressing", "wsa:Address");
            txtNode = soapPart.createTextNode("http://www.w3.org/2005/08/addressing/anonymous");
            address.appendChild(txtNode);
            replyTo.appendChild(address);
            header.appendChild((Node)replyTo);
            Element messageID = soapMessage.getSOAPPart().createElementNS("http://www.w3.org/2005/08/addressing", "wsa:MessageID");
            txtNode = soapPart.createTextNode(SAMLUtils.generateID());
            messageID.appendChild(txtNode);
            header.appendChild((Node)messageID);
            soapMessage.saveChanges();
            return soapMessage;
        }
        catch (SOAPException se) {
            throw new FAMSTSException(se.getMessage());
        }
    }

    public static SOAPMessage createSOAPMessage(InputStream is) throws FAMSTSException {
        try {
            String soapVersion = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.soapversion", (String)"1.2");
            MessageFactory mf = null;
            String contentType = "text/xml";
            if (soapVersion.equals("1.2")) {
                mf = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
                contentType = "application/soap+xml";
            } else {
                mf = MessageFactory.newInstance();
            }
            MimeHeaders headers = new MimeHeaders();
            headers.addHeader("Content-Type", contentType);
            return mf.createMessage(headers, is);
        }
        catch (IOException ie) {
            throw new FAMSTSException(ie.getMessage());
        }
        catch (SOAPException se) {
            throw new FAMSTSException(se.getMessage());
        }
    }
}

