/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMRoleImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.SearchControl;
import java.util.Map;
import java.util.Set;

class AMFilteredRoleImpl
extends AMRoleImpl
implements AMFilteredRole {
    public AMFilteredRoleImpl(SSOToken ssoToken, String DN2) {
        super(ssoToken, DN2, 8);
    }

    public void addUsers(Set users) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeUsers(Set users) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Set searchUsers(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        if (level != 1 && level != 2) {
            throw new AMException(AMSDKBundle.getString("123", this.locale), "123");
        }
        if (wildcard == null || wildcard.length() == 0) {
            throw new AMException(AMSDKBundle.getString("122", this.locale), "122");
        }
        String userFilter = "(&(" + AMNamingAttrManager.getNamingAttr(1) + "=" + wildcard + ")" + this.getFilter() + ")";
        String filter = null;
        if (avPairs == null) {
            filter = userFilter;
        } else if (avPairs.size() == 0) {
            filter = userFilter;
        } else {
            StringBuffer filterSB = new StringBuffer();
            filterSB.append("(&").append(userFilter).append("(|");
            for (String attributeName : avPairs.keySet()) {
                for (String attributeValue : (Set)avPairs.get(attributeName)) {
                    filterSB.append("(").append(attributeName).append("=").append(attributeValue).append(")");
                }
            }
            filterSB.append("))");
            filter = filterSB.toString();
        }
        return this.dsServices.search(this.token, this.getOrganizationDN(), filter, level);
    }

    public AMSearchResults searchUsers(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        int level = searchControl.getSearchScope();
        if (level != 1 && level != 2) {
            throw new AMException(AMSDKBundle.getString("123", this.locale), "123");
        }
        if (wildcard == null || wildcard.length() == 0) {
            throw new AMException(AMSDKBundle.getString("122", this.locale), "122");
        }
        String userFilter = "(&(" + AMNamingAttrManager.getNamingAttr(1) + "=" + wildcard + ")" + this.getFilter() + ")";
        String filter = null;
        if (avPairs == null) {
            filter = userFilter;
        } else if (avPairs.size() == 0) {
            filter = userFilter;
        } else {
            StringBuffer filterSB = new StringBuffer();
            filterSB.append("(&").append(userFilter).append("(|");
            for (String attributeName : avPairs.keySet()) {
                for (String attributeValue : (Set)avPairs.get(attributeName)) {
                    filterSB.append("(").append(attributeName).append("=").append(attributeValue).append(")");
                }
            }
            filterSB.append("))");
            filter = filterSB.toString();
        }
        SearchControl sc = searchControl.getSearchControl();
        String[] returnAttrs = searchControl.getReturnAttributes();
        return this.dsServices.search(this.token, this.getOrganizationDN(), filter, sc, returnAttrs);
    }

    public AMSearchResults searchUsers(AMSearchControl searchControl, String avFilter) throws AMException, SSOException {
        int level = searchControl.getSearchScope();
        if (level != 1 && level != 2) {
            throw new AMException(AMSDKBundle.getString("123", this.locale), "123");
        }
        String filter = "(&" + this.getFilter() + avFilter + ")";
        if (debug.messageEnabled()) {
            debug.message("AMFilteredRoleImpl.searchUsers: " + filter);
        }
        searchControl.setSearchScope(2);
        SearchControl sc = searchControl.getSearchControl();
        String[] returnAttrs = searchControl.getReturnAttributes();
        return this.dsServices.search(this.token, this.getOrganizationDN(), filter, sc, returnAttrs);
    }

    public String getFilter() throws AMException, SSOException {
        return this.getStringAttribute("nsRoleFilter");
    }

    public void setFilter(String filter) throws AMException, SSOException {
        this.setStringAttribute("nsRoleFilter", filter);
        this.store();
    }
}

