/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.ThreadPoolException;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;

public class ThreadPool {
    private int poolSize;
    private int threshold;
    private String poolName;
    private Debug debug;
    private ArrayList taskList;
    private int busyThreadCount;
    private int currentThreadCount;
    private boolean shutdownThePool;
    private boolean daemon;
    private WorkerThread[] threads;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool(String name, int poolSize, int threshold, boolean daemon, Debug debug) {
        this.debug = debug;
        this.poolSize = poolSize;
        this.threshold = threshold;
        this.poolName = name;
        this.taskList = threshold > 0 ? new ArrayList(threshold) : new ArrayList();
        this.busyThreadCount = 0;
        this.currentThreadCount = 0;
        this.daemon = daemon;
        this.shutdownThePool = false;
        this.threads = new WorkerThread[poolSize];
        if (debug.messageEnabled()) {
            debug.message("Initiating login thread pool size = " + this.poolSize + "\nThreshold = " + threshold);
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.createThreads(poolSize);
        }
    }

    protected void createThreads(int threadsToCreate) {
        if (threadsToCreate > this.poolSize) {
            threadsToCreate = this.poolSize;
        }
        for (int i = this.currentThreadCount; i < threadsToCreate; ++i) {
            this.threads[i - this.busyThreadCount] = new WorkerThread(this.poolName, this);
            this.threads[i - this.busyThreadCount].setDaemon(this.daemon);
            this.threads[i - this.busyThreadCount].start();
        }
        this.currentThreadCount = threadsToCreate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerThread getAvailableThread() {
        WorkerThread t = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.currentThreadCount == this.busyThreadCount) {
                this.createThreads(this.poolSize);
            }
            t = this.threads[this.currentThreadCount - this.busyThreadCount - 1];
            this.threads[this.currentThreadCount - this.busyThreadCount - 1] = null;
            ++this.busyThreadCount;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(Runnable task) throws ThreadPoolException {
        WorkerThread t = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.shutdownThePool) {
                throw new ThreadPoolException(this.poolName + " thread pool's being shutdown.");
            }
            if (this.busyThreadCount == this.poolSize) {
                if (this.threshold > 0 && this.taskList.size() >= this.threshold) {
                    throw new ThreadPoolException(this.poolName + " thread pool's task queue is full.");
                }
                this.taskList.add(task);
            } else {
                t = this.getAvailableThread();
            }
        }
        if (t != null && task != null) {
            t.runTask(task);
        }
    }

    protected synchronized void deductCurrentThreadCount() {
        --this.currentThreadCount;
        --this.busyThreadCount;
        if (!this.taskList.isEmpty()) {
            WorkerThread t = this.getAvailableThread();
            t.runTask((Runnable)this.taskList.remove(0));
        } else if (this.shutdownThePool && this.busyThreadCount == 0) {
            this.notify();
        }
    }

    protected synchronized void returnThread(WorkerThread t) {
        if (!this.taskList.isEmpty()) {
            t.runTask((Runnable)this.taskList.remove(0));
        } else if (this.shutdownThePool) {
            t.terminate();
            --this.busyThreadCount;
            --this.currentThreadCount;
            if (this.busyThreadCount == 0) {
                this.notify();
            }
        } else {
            --this.busyThreadCount;
            this.threads[this.currentThreadCount - this.busyThreadCount - 1] = t;
        }
    }

    public synchronized void shutdown() {
        if (!this.shutdownThePool) {
            this.shutdownThePool = true;
            if (this.daemon) {
                this.taskList.clear();
            } else {
                while (!this.taskList.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (Exception ex) {
                        this.debug.error("ThreadPool.shutdown Excetion while waiting for tasks/threads to complete", (Throwable)ex);
                    }
                }
            }
            for (int i = 0; i < this.currentThreadCount - this.busyThreadCount; ++i) {
                if (this.threads[i] == null) continue;
                this.threads[i].terminate();
            }
            while (this.busyThreadCount != 0) {
                try {
                    this.wait();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.busyThreadCount = 0;
            this.currentThreadCount = 0;
            this.threads = null;
        }
    }

    public synchronized int getCurrentThreadCount() {
        return this.currentThreadCount;
    }

    public int getCurrentSize() {
        return this.taskList.size();
    }

    private class WorkerThread
    extends Thread {
        private Runnable task = null;
        private ThreadPool pool;
        private boolean needReturn;
        private boolean shouldTerminate;

        public WorkerThread(String name, ThreadPool pool) {
            this.setName(name);
            this.pool = pool;
            this.shouldTerminate = false;
            this.needReturn = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean localShouldTerminate = false;
            Runnable localTask = null;
            WorkerThread t = this;
            do {
                try {
                    WorkerThread workerThread = this;
                    synchronized (workerThread) {
                        if (this.task == null && !this.shouldTerminate) {
                            this.wait();
                        }
                        localShouldTerminate = this.shouldTerminate;
                        localTask = this.task;
                        this.task = null;
                    }
                    if (!localShouldTerminate) {
                        if (localTask == null) continue;
                        localTask.run();
                        continue;
                    }
                    break;
                }
                catch (RuntimeException ex) {
                    ThreadPool.this.debug.error("Running task " + this.task, (Throwable)ex);
                    this.pool.deductCurrentThreadCount();
                    localShouldTerminate = true;
                    this.needReturn = false;
                }
                catch (Exception ex) {
                    ThreadPool.this.debug.error("Running task " + this.task, (Throwable)ex);
                }
                catch (Throwable e) {
                    ThreadPool.this.debug.error("Running task " + this.task, e);
                    this.pool.deductCurrentThreadCount();
                    localShouldTerminate = true;
                    this.needReturn = false;
                    throw new Error(e);
                }
                finally {
                    if (this.needReturn) {
                        this.pool.returnThread(t);
                    }
                }
            } while (!localShouldTerminate);
        }

        public synchronized void runTask(Runnable toRun) {
            this.task = toRun;
            this.notify();
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.needReturn = false;
            this.notify();
        }
    }
}

