/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.aci;

import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.ldap.aci.ACIParser;
import com.iplanet.services.ldap.aci.ACR;
import com.iplanet.services.ldap.aci.BindRuleBuilder;
import com.iplanet.services.ldap.aci.BindRuleTokenizer;
import com.iplanet.services.ldap.aci.QualifiedCollection;
import java.util.Collection;

class ACRParser {
    ACRParser() {
    }

    static ACR parse(String text) throws ACIParseException {
        int peLength;
        String permissionExpression;
        int aclNameLength;
        String aclName;
        ACR acr = new ACR();
        if (text.length() < 6) {
            throw new ACIParseException("Malformed aci");
        }
        if ((text = text.substring(1, text.length() - 1).trim()).charAt(text.length() - 1) != ';') {
            throw new ACIParseException("Malformed aci");
        }
        String lcText = text.toLowerCase();
        int colonIndex = 0;
        if (lcText.indexOf("version") == 0) {
            colonIndex = (text = text.substring("version".length()).trim()).indexOf(";");
            if (colonIndex < 0 || colonIndex == text.length() - 1) {
                throw new ACIParseException("Malformed aci");
            }
        } else {
            throw new ACIParseException("Malformed aci");
        }
        String version = text.substring(0, colonIndex).trim();
        acr.setVersion(version);
        text = text.substring(colonIndex + 1);
        text = text.trim();
        lcText = text.toLowerCase();
        if (lcText.indexOf("acl") == 0 || lcText.indexOf("aci") == 0) {
            colonIndex = (text = text.substring("acl".length()).trim()).indexOf(";");
            if (colonIndex < 0 || colonIndex == text.length() - 1) {
                throw new ACIParseException("Malformed aci");
            }
            aclName = text.substring(0, colonIndex).trim();
            aclNameLength = aclName.length();
            if (aclNameLength < 3 || aclName.charAt(0) != '\"' || aclName.charAt(aclNameLength - 1) != '\"') {
                throw new ACIParseException("Malformed aci");
            }
        } else {
            throw new ACIParseException("Malformed aci");
        }
        aclName = aclName.substring(1, aclNameLength - 1);
        acr.setName(aclName);
        text = text.substring(colonIndex + 1);
        boolean allowed = false;
        boolean denied = false;
        String permissionMode = null;
        text = text.trim();
        lcText = text.toLowerCase();
        if (lcText.indexOf("allow") == 0) {
            allowed = true;
            permissionMode = "allow";
        } else if (lcText.indexOf("deny") == 0) {
            denied = true;
            permissionMode = "deny";
        }
        if (allowed || denied) {
            colonIndex = text.indexOf(";");
            if (colonIndex < 0 || colonIndex != text.length() - 1) {
                throw new ACIParseException("Malformed aci");
            }
            text = text.substring(0, colonIndex);
            text = text.substring(permissionMode.length()).trim();
            int parenthIndex = text.indexOf(")");
            permissionExpression = text.substring(0, parenthIndex + 1);
            text = text.substring(parenthIndex + 1).trim();
            peLength = permissionExpression.length();
            if (peLength < 3 || permissionExpression.charAt(0) != '(' || permissionExpression.charAt(peLength - 1) != ')') {
                throw new ACIParseException("Malformed aci-invlaid permission expression : " + permissionExpression);
            }
        } else {
            throw new ACIParseException("Malformed aci");
        }
        permissionExpression = permissionExpression.substring(1, peLength - 1);
        Collection permissions = ACIParser.getTokens(permissionExpression, ",");
        QualifiedCollection qc = new QualifiedCollection(permissions, denied);
        acr.setPermissions(qc);
        BindRuleTokenizer tokenizer = new BindRuleTokenizer(text);
        BindRuleBuilder brBuilder = new BindRuleBuilder();
        String token = null;
        while ((token = tokenizer.nextToken()) != null) {
            brBuilder.addToken(token);
        }
        acr.setBindRule(brBuilder.getBindRule());
        return acr;
    }
}

