/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.msisdn;

import com.sun.identity.authentication.modules.msisdn.MSISDNPrincipal;
import com.sun.identity.authentication.modules.msisdn.MSISDNValidation;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class MSISDN
extends AMLoginModule {
    private ResourceBundle bundle = null;
    private Locale locale;
    private static Debug debug = null;
    private static final int DEFAULT_MSISDN_AUTH_LEVEL = 0;
    private String userTokenId;
    private String errorMsgKey = null;
    private MSISDNPrincipal userPrincipal;
    private Map options;
    private Set gatewayList;
    private Set parameterNameList;
    private Set searchHeaderList;
    private String userSearchAttr;
    private String serverHost;
    private int serverPort;
    private String startSearchLoc;
    private String principleUser;
    private String principlePasswd;
    private String useSSL;
    private boolean validGateway = false;
    private boolean searchAllHeaders = false;
    private static final String amAuthMSISDN = "amAuthMSISDN";
    private static final String TRUSTED_GATEWAY_LIST = "sunAMAuthMSISDNTrustedGatewayList";
    private static final String MSISDN_PARAMETER_NAME = "sunAMAuthMSISDNParameterNameList";
    private static final String MSISDN_AUTH_LEVEL = "sunAMAuthMSISDNAuthLevel";
    private static final String MSISDN_HEADER_SEARCH = "sunAMAuthMSISDNHeaderSearch";
    private static final String SEARCH_COOKIE = "searchCookie";
    private static final String SEARCH_HEADER = "searchRequest";
    private static final String SEARCH_PARAM = "searchParam";
    private static final int SUBMITTED_CREDENTIALS = 0;

    public void init(Subject subject, Map sharedState, Map options) {
        this.locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(amAuthMSISDN, this.locale);
        if (debug.messageEnabled()) {
            debug.message("MSISDN resbundle locale=" + this.locale);
        }
        this.options = options;
        this.initAuthConfig();
    }

    private void initAuthConfig() {
        if (this.options != null) {
            debug.message("MSISDN: getting attributes.");
            this.gatewayList = (Set)this.options.get(TRUSTED_GATEWAY_LIST);
            if (this.gatewayList != null && !this.gatewayList.isEmpty() && this.gatewayList.contains("none")) {
                if (debug.messageEnabled()) {
                    debug.message("No gateways trusted ");
                }
                this.errorMsgKey = "MSISDNInvalidGateway";
            } else {
                this.parameterNameList = (Set)this.options.get(MSISDN_PARAMETER_NAME);
                this.searchHeaderList = (Set)this.options.get(MSISDN_HEADER_SEARCH);
                if (this.searchHeaderList == null || this.searchHeaderList.isEmpty()) {
                    this.searchAllHeaders = true;
                    if (debug.messageEnabled()) {
                        debug.message("searchAllHeaders :" + this.searchAllHeaders);
                    }
                }
                this.setMSISDNAuthLevel();
            }
        } else {
            debug.error("options is null");
            this.errorMsgKey = "MSISDNValidateEx";
        }
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        debug.message("MSISDN : in process ..");
        if (this.errorMsgKey != null) {
            debug.message("Error initalizing config");
            throw new AuthLoginException(amAuthMSISDN, this.errorMsgKey, null);
        }
        HttpServletRequest req = this.getHttpServletRequest();
        String gateway = null;
        String msisdnNumber = null;
        if (req != null) {
            gateway = req.getRemoteAddr();
            msisdnNumber = this.getMSISDNNumberFromRequest(req);
        } else {
            debug.message("Null request calling sendCallback");
            Map map = this.sendCallback();
            if (map != null) {
                msisdnNumber = (String)map.get("msisdnNumber");
                gateway = (String)map.get("gateway");
            }
        }
        if (!this.isValidGateway(gateway) || msisdnNumber == null) {
            debug.error("Gateway is invalid OR msisdn number is null");
            throw new AuthLoginException(amAuthMSISDN, "MSISDNValidateEx", null);
        }
        MSISDNValidation msisdnValidation = new MSISDNValidation(this.options, debug, this.bundle, this.locale);
        this.userTokenId = msisdnValidation.getUserId(msisdnNumber);
        this.storeUsernamePasswd(this.userTokenId, null);
        return -1;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal == null && this.userTokenId != null) {
            this.userPrincipal = new MSISDNPrincipal(this.userTokenId);
        }
        return this.userPrincipal;
    }

    private Map sendCallback() {
        HashMap<String, String> map;
        block5: {
            map = null;
            try {
                CallbackHandler callbackHandler = this.getCallbackHandler();
                if (callbackHandler == null) {
                    throw new AuthLoginException(amAuthMSISDN, "NoCallbackHandler", null);
                }
                Callback[] callbacks = new Callback[]{new NameCallback(this.bundle.getString("gateway")), new PasswordCallback(this.bundle.getString("msisdn"), true)};
                callbackHandler.handle(callbacks);
                map = new HashMap<String, String>();
                for (Callback cb : callbacks) {
                    String gateway;
                    if (cb instanceof PasswordCallback) {
                        char[] pass = ((PasswordCallback)cb).getPassword();
                        if (pass == null) continue;
                        map.put("msisdnNumber", new String(pass));
                        continue;
                    }
                    if (!(cb instanceof NameCallback) || (gateway = ((NameCallback)cb).getName()) == null) continue;
                    map.put("gateway", gateway);
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block5;
                debug.message("sendCallback", (Throwable)e);
            }
        }
        return map;
    }

    private void setMSISDNAuthLevel() {
        String tmp = CollectionHelper.getMapAttr((Map)this.options, (String)MSISDN_AUTH_LEVEL);
        int authLevel = 0;
        if (tmp != null && tmp.length() > 0) {
            try {
                authLevel = Integer.parseInt(tmp);
            }
            catch (Exception e) {
                debug.error("Invalid auth level " + tmp);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Set auth level to " + authLevel);
        }
        this.setAuthLevel(authLevel);
    }

    private boolean isValidGateway(String gateway) {
        return this.gatewayList != null && (this.gatewayList.isEmpty() || this.gatewayList.contains(gateway));
    }

    private String getMSISDNNumberFromRequest(HttpServletRequest req) {
        String msisdnNumber = null;
        if (this.parameterNameList != null && !this.parameterNameList.isEmpty()) {
            Iterator it = this.parameterNameList.iterator();
            String parameterName = null;
            while (it.hasNext()) {
                parameterName = it.next().toString();
                if (debug.messageEnabled()) {
                    debug.message("parameterName : " + parameterName);
                }
                if (this.searchAllHeaders || this.searchHeaderList.contains(SEARCH_COOKIE)) {
                    Cookie[] cookieArray = req.getCookies();
                    if (cookieArray != null) {
                        for (int i = 0; i < cookieArray.length; ++i) {
                            String cookieName = cookieArray[i].getName();
                            if (cookieName == null || !cookieName.equalsIgnoreCase(parameterName)) continue;
                            msisdnNumber = cookieArray[i].getValue();
                            break;
                        }
                    }
                    if (msisdnNumber != null) break;
                }
                if (this.searchAllHeaders || this.searchHeaderList.contains(SEARCH_HEADER)) {
                    msisdnNumber = req.getHeader(parameterName);
                }
                if (msisdnNumber != null) break;
                if (this.searchAllHeaders || this.searchHeaderList.contains(SEARCH_PARAM)) {
                    msisdnNumber = req.getParameter(parameterName);
                }
                if (msisdnNumber == null) continue;
                break;
            }
        }
        return msisdnNumber;
    }

    public void destroyModuleState() {
        this.userPrincipal = null;
        this.userTokenId = null;
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.locale = null;
        this.errorMsgKey = null;
        this.options = null;
        this.gatewayList = null;
        this.parameterNameList = null;
        this.searchHeaderList = null;
        this.userSearchAttr = null;
        this.serverHost = null;
        this.startSearchLoc = null;
        this.principleUser = null;
        this.principlePasswd = null;
        this.useSSL = null;
    }

    static {
        debug = Debug.getInstance((String)amAuthMSISDN);
    }
}

