/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class UnregisterAuthModule
extends SchemaCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String authModule = this.getStringOptionValue("authmodule");
        ServiceSchema ss = this.getServiceSchema("iPlanetAMAuthService", null, "Global");
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{"iPlanetAMAuthService"};
            this.writeLog(0, Level.INFO, "ATTEMPT_UNREGISTER_AUTH_MODULE", params);
            Map attrValues = ss.getAttributeDefaults();
            Set values = (Set)attrValues.get("iplanet-am-auth-authenticators");
            boolean removed = false;
            if (values != null && !values.isEmpty()) {
                removed = values.remove(authModule);
                ss.setAttributeDefaults("iplanet-am-auth-authenticators", values);
            }
            if (removed) {
                outputWriter.printlnMessage(this.getResourceString("unregister-auth-module-succeeded"));
            } else {
                outputWriter.printlnMessage(this.getResourceString("unregister-auth-module-notfound"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_UNREGISTER_AUTH_MODULE", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{"iPlanetAMAuthService", e.getMessage()};
            this.debugError("UnregisterAuthModule.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_UNREGISTER_AUTH_MODULE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{"iPlanetAMAuthService", e.getMessage()};
            this.debugError("UnregisterAuthModule.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_UNREGISTER_AUTH_MODULE", args);
            throw new CLIException(e, 127);
        }
    }
}

