/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class GetAssignableServices
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String idName = this.getStringOptionValue("idname");
        String type = this.getStringOptionValue("idtype");
        IdType idType = this.convert2IdType(type);
        String[] params = new String[]{realm, type, idName};
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            Set set = amir.getAllowedIdOperations(idType);
            if (!set.contains(IdOperation.SERVICE)) {
                throw new CLIException(MessageFormat.format(this.getResourceString("realm-does-not-support-service"), params), 127);
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_GET_ASSIGNABLE_SERVICES", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
            Set services = amid.getAssignableServices();
            if (idType.equals(IdType.USER)) {
                services.remove("iPlanetAMUserService");
                services.remove("iPlanetAMAuthConfiguration");
                services.remove("iPlanetAMSAMLService");
            }
            if (services != null && !services.isEmpty()) {
                String msg = this.getResourceString("assignable-service-result");
                String[] arg = new String[]{""};
                Iterator i = services.iterator();
                while (i.hasNext()) {
                    arg[0] = (String)i.next();
                    outputWriter.printlnMessage(MessageFormat.format(msg, arg));
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("no-service-assignable"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_GET_ASSIGNABLE_SERVICES", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("GetAssignableServices.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_GET_ASSIGNABLE_SERVICES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("GetAssignableServices.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_GET_ASSIGNABLE_SERVICES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }

    private void discardServicesWithoutAttributeSchema(SSOToken adminSSOToken, Set serviceNames, IdType type) throws SMSException, SSOException {
        Iterator iter = serviceNames.iterator();
        while (iter.hasNext()) {
            String serviceName = (String)iter.next();
            ServiceSchemaManager mgr = new ServiceSchemaManager(serviceName, adminSSOToken);
            String url = mgr.getPropertiesViewBeanURL();
            if (url != null) continue;
            ServiceSchema serviceSchema = mgr.getSchema(type.getName());
            Set attributes = serviceSchema.getAttributeSchemas();
            if (attributes == null || attributes.isEmpty()) {
                iter.remove();
                continue;
            }
            if (this.hasI18nKeys(attributes)) continue;
            iter.remove();
        }
    }

    private boolean hasI18nKeys(Set attributeSchemes) {
        boolean has = false;
        Iterator i = attributeSchemes.iterator();
        while (i.hasNext() && !has) {
            AttributeSchema as = (AttributeSchema)i.next();
            String i18nKey = as.getI18NKey();
            has = i18nKey != null && i18nKey.length() > 0;
        }
        return has;
    }
}

