/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.FormatUtils;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;

public class RealmGetAttributeValues
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String serviceName = this.getStringOptionValue("servicename");
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{realm, serviceName};
            this.writeLog(0, Level.INFO, "ATTEMPT_GET_REALM_SERVICE_ATTR_VALUES", params);
            OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, realm);
            Map attributeValues = ocm.getAttributes(serviceName);
            if (attributeValues != null && !attributeValues.isEmpty()) {
                outputWriter.printlnMessage(FormatUtils.printAttributeValues(this.getResourceString("get-attr-values-of-realm-result"), attributeValues));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("get-attr-values-of-realm-no-values"), params));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_GET_REALM_SERVICE_ATTR_VALUES", params);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmAttributeValues.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_GET_REALM_SERVICE_ATTR_VALUES", args);
            throw new CLIException(e, 127);
        }
    }
}

