/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.FormatUtils;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.ServiceSchema;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class GetAttributeDefaults
extends SchemaCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String schemaType = this.getStringOptionValue("schematype");
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        ServiceSchema ss = this.getServiceSchema();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{serviceName, schemaType, subSchemaName};
        this.writeLog(0, Level.INFO, "ATTEMPT_GET_SCHEMA_ATTR_DEFAULTS", params);
        Map attrValues = ss.getAttributeDefaults();
        this.retainValues(rc, attrValues);
        this.maskPasswordValues(ss, attrValues);
        if (!attrValues.isEmpty()) {
            outputWriter.printlnMessage(FormatUtils.printAttributeValues(this.getResourceString("schema-get-attribute-defaults-result"), attrValues));
            outputWriter.printlnMessage(this.getResourceString("schema-get-attribute-defaults-succeed"));
        } else {
            outputWriter.printlnMessage(this.getResourceString("schema-get-attribute-defaults-no-matching-attr"));
        }
        this.writeLog(0, Level.INFO, "SUCCEED_GET_SCHEMA_ATTR_DEFAULTS", params);
    }

    private void retainValues(RequestContext rc, Map attrValues) {
        List attrNames = rc.getOption("attributenames");
        if (attrNames != null && !attrNames.isEmpty()) {
            HashSet attributeNames = new HashSet();
            attributeNames.addAll(attrNames);
            Iterator i = attrValues.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (attributeNames.contains(name)) continue;
                i.remove();
            }
        }
    }

    private void maskPasswordValues(ServiceSchema ss, Map attrValues) {
        for (String name : attrValues.keySet()) {
            AttributeSchema attrSchema;
            AttributeSchema.Syntax syntax;
            Set values = (Set)attrValues.get(name);
            if (values == null || (syntax = (attrSchema = ss.getAttributeSchema(name)).getSyntax()) != AttributeSchema.Syntax.PASSWORD) continue;
            attrValues.put(name, this.maskPasswordField(values));
        }
    }

    private Set maskPasswordField(Set pwdValues) {
        int size = pwdValues.size();
        HashSet<String> masked = new HashSet<String>(size * 2);
        for (int i = 0; i < size; ++i) {
            masked.add("********");
        }
        return masked;
    }
}

