/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.serverconfig.ServerConfigBase;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.sm.SMSException;
import java.util.List;
import java.util.logging.Level;

public class RemoveSiteMembers
extends ServerConfigBase {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String siteName = this.getStringOptionValue("sitename");
        List serverNames = rc.getOption("servernames");
        String[] params = new String[]{siteName};
        this.writeLog(0, Level.INFO, "ATTEMPT_REMOVE_SITE_MEMBERS", params);
        IOutput outputWriter = this.getOutputWriter();
        try {
            if (SiteConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            if (SiteConfiguration.isSiteExist(adminSSOToken, siteName)) {
                SiteConfiguration.removeServersFromSite(adminSSOToken, siteName, serverNames);
                outputWriter.printlnMessage(this.getResourceString("remove-site-members-succeeded"));
            } else {
                outputWriter.printlnMessage(this.getResourceString("remove-site-members-site-not-exist"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_REMOVE_SITE_MEMBERS", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("RemoveSiteMembers.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_SITE_MEMBERS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("RemoveSiteMembers.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_SITE_MEMBERS", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("RemoveSiteMembers.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_SITE_MEMBERS", args);
            throw new CLIException(e, 127);
        }
    }
}

