/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SSOServerMonConfig;
import com.sun.identity.monitoring.SSOServerRealmInfo;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConfigMonitoring {
    Debug debug;
    SSOToken ssoToken;
    private ArrayList realmList;
    private boolean skipGettingAuthModules = true;

    public void configureMonitoring() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date1 = new Date();
        String startDate = sdf.format(date1);
        this.debug = Debug.getInstance((String)"amMonitoring");
        String classMethod = "ConfigMonitoring.configureMonitoring: ";
        try {
            this.ssoToken = this.getSSOToken();
        }
        catch (SSOException ssoe) {
            this.debug.error(classMethod + "Could not get proper SSOToken", (Throwable)((Object)ssoe));
            return;
        }
        boolean isSessFOEnabled = false;
        try {
            SessionService ssvc = SessionService.getSessionService();
            if (ssvc != null) {
                isSessFOEnabled = ssvc.isSessionFailoverEnabled();
            } else {
                this.debug.error(classMethod + "unable to get session service");
            }
        }
        catch (Exception ex) {
            this.debug.error(classMethod + "exception getting session service; " + ex.getMessage());
        }
        Agent.setSFOStatus(isSessFOEnabled);
        if (this.getMonServiceAttrs() != 0) {
            return;
        }
        HashMap<String, String> puMap = new HashMap<String, String>();
        HashMap<String, String> siteMap = new HashMap<String, String>();
        try {
            Set siteNames = SiteConfiguration.getSites(this.ssoToken);
            if (siteNames.size() > 0) {
                for (String site : siteNames) {
                    String purl = SiteConfiguration.getSitePrimaryURL(this.ssoToken, site);
                    puMap.put(site, purl);
                    siteMap.put(purl, site);
                }
            }
        }
        catch (SMSException smex) {
            this.debug.error(classMethod + "SMS exception: " + smex.getMessage());
        }
        catch (SSOException ssoex) {
            this.debug.error(classMethod + "SSO exception: " + ssoex.getMessage());
        }
        Agent.siteNames(puMap, siteMap);
        this.getRealmsList("/");
        Agent.realmsConfig(this.realmList);
        if (!this.skipGettingAuthModules) {
            this.getAllRealms("/");
        }
        this.getAllRealmsSpecific("/");
        this.doSubRealms("/");
        date1 = new Date();
        if (this.debug.messageEnabled()) {
            this.debug.message(classMethod + "\n" + "    Start time " + startDate + "\n" + "    End time = " + sdf.format(date1));
        }
        Agent.setMonitoringConfig(true);
    }

    private SSOToken getSSOToken() throws SSOException {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    private void getRealmsList(String startRealm) {
        String classMethod = "ConfigMonitoring.getRealmsList: ";
        try {
            int rlmCnt = 1;
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.ssoToken, startRealm);
            Set orgs = orgMgr.getSubOrganizationNames("*", true);
            this.realmList = new ArrayList(rlmCnt += orgs.size());
            this.realmList.add(startRealm);
            Iterator it = orgs.iterator();
            while (it.hasNext()) {
                String ss = "/" + (String)it.next();
                this.realmList.add(ss);
            }
        }
        catch (SMSException e) {
            this.debug.error(classMethod + "SMSException getting OrgConfigMgr: " + e.getMessage());
        }
    }

    private void getAllRealms(String startRealm) {
        String classMethod = "ConfigMonitoring.getAllRealms: ";
        StringBuffer sb = new StringBuffer(classMethod);
        if (this.debug.messageEnabled()) {
            sb.append("orgnames starting from ").append(startRealm).append(":\n").append("  ").append(startRealm).append("\n");
        }
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.ssoToken, startRealm);
            Set orgs = orgMgr.getSubOrganizationNames("*", true);
            HashMap<String, String> authHM = this.getRealmAuthMods("/");
            if (this.debug.messageEnabled()) {
                this.getAgentTypes();
            }
            SSOServerRealmInfo srInfo = new SSOServerRealmInfo.SSOServerRealmInfoBuilder("/").authModules(authHM).build();
            Agent.realmConfigMonitoringAgent(srInfo);
            Iterator it = orgs.iterator();
            while (it.hasNext()) {
                String ss = "/" + (String)it.next();
                if (this.debug.messageEnabled()) {
                    sb.append("  ").append(ss).append("\n");
                }
                try {
                    AMIdentityRepository idRepo = new AMIdentityRepository(this.ssoToken, ss);
                    AMIdentity thisRealmAMId = idRepo.getRealmIdentity();
                    String currentRealmAMIdName = thisRealmAMId.getRealm();
                    Set s1 = this.getAuthModules(currentRealmAMIdName);
                    authHM = new HashMap<String, String>();
                    if (!s1.isEmpty()) {
                        for (AMAuthenticationInstance ai : s1) {
                            String stname = ai.getName();
                            String sttype = ai.getType();
                            authHM.put(stname, sttype);
                        }
                        authHM.put("Application", "Application");
                    }
                    srInfo = new SSOServerRealmInfo.SSOServerRealmInfoBuilder(ss).authModules(authHM).build();
                    Agent.realmConfigMonitoringAgent(srInfo);
                }
                catch (IdRepoException ire) {
                    this.debug.error(classMethod + "IdRepoException getting AMIdentityRepository" + " object for realm: " + ss + ": " + ire.getMessage());
                }
                catch (SSOException ssoe) {
                    this.debug.error(classMethod + "SSOException getting info for realm " + ss + ": " + ssoe.getMessage());
                }
            }
            if (this.debug.messageEnabled()) {
                this.debug.message(sb.toString());
            }
        }
        catch (SMSException e) {
            this.debug.error(classMethod + "SMSException getting OrgConfigMgr: " + e.getMessage());
        }
    }

    private void getAllRealmsSpecific(String startRealm) {
        String classMethod = "ConfigMonitoring.getAllRealmsSpecific: ";
        StringBuffer sb = new StringBuffer(classMethod);
        if (this.debug.messageEnabled()) {
            sb.append("orgnames starting from ").append(startRealm).append(":\n").append("  ").append(startRealm).append("\n");
        }
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.ssoToken, startRealm);
            Set orgs = orgMgr.getSubOrganizationNames("*", true);
            AMIdentityRepository idRepo = null;
            AMIdentity thisRealmAMId = null;
            String currentRealmAMIdName = null;
            try {
                idRepo = new AMIdentityRepository(this.ssoToken, "/");
                thisRealmAMId = idRepo.getRealmIdentity();
                currentRealmAMIdName = thisRealmAMId.getRealm();
                this.getAgentsAndGroupsInfo("/", idRepo, thisRealmAMId);
            }
            catch (IdRepoException ire) {
                this.debug.error(classMethod + "IdRepoException getting AMIdentityRepository" + " object for realm: /: " + ire.getMessage());
            }
            catch (SSOException ssoe) {
                this.debug.error(classMethod + "SSOException getting info for realm /: " + ssoe.getMessage());
            }
            Iterator it = orgs.iterator();
            while (it.hasNext()) {
                String ss = "/" + (String)it.next();
                if (this.debug.messageEnabled()) {
                    sb.append("  ").append(ss).append("\n");
                }
                try {
                    idRepo = new AMIdentityRepository(this.ssoToken, ss);
                    thisRealmAMId = idRepo.getRealmIdentity();
                    currentRealmAMIdName = thisRealmAMId.getRealm();
                    this.getAgentsAndGroupsInfo(ss, idRepo, thisRealmAMId);
                }
                catch (IdRepoException ire) {
                    this.debug.error(classMethod + "IdRepoException getting AMIdentityRepository" + " object for realm: " + ss + ": " + ire.getMessage());
                }
                catch (SSOException ssoe) {
                    this.debug.error(classMethod + "SSOException getting info for realm " + ss + ": " + ssoe.getMessage());
                }
            }
            if (this.debug.messageEnabled()) {
                this.debug.message(sb.toString());
            }
        }
        catch (SMSException e) {
            this.debug.error(classMethod + "SMSException getting OrgConfigMgr: " + e.getMessage());
        }
    }

    HashMap getRealmAuthMods(String realmName) {
        String classMethod = "ConfigMonitoring.getRealmAuthMods: ";
        HashMap<String, String> aMods = new HashMap<String, String>();
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(this.ssoToken, realmName);
            Set insts = mgr.getAuthenticationInstances();
            for (AMAuthenticationInstance ai : insts) {
                String stname = ai.getName();
                String sttype = ai.getType();
                aMods.put(stname, sttype);
            }
            aMods.put("Application", "Application");
        }
        catch (AMConfigurationException e) {
            this.debug.error(classMethod + "getting auth instances; " + e.getMessage());
        }
        return aMods;
    }

    private void doSubRealms(String realm) {
        String classMethod = "ConfigMonitoring.doSubRealms: ";
        try {
            Set subRealms;
            AMIdentityRepository idRepo = new AMIdentityRepository(this.ssoToken, realm);
            AMIdentity thisRealmAMId = idRepo.getRealmIdentity();
            String currentRealmAMIdName = thisRealmAMId.getRealm();
            String currentAMIdName = thisRealmAMId.getName();
            if (this.debug.messageEnabled()) {
                this.debug.message(classMethod + "this realm name = '" + currentRealmAMIdName + "', name = '" + currentAMIdName + "'");
            }
            if ((subRealms = idRepo.searchIdentities(IdType.REALM, "*", new IdSearchControl()).getSearchResults()).isEmpty()) {
                if (this.debug.messageEnabled()) {
                    this.debug.message(classMethod + currentAMIdName + " has no subrealms");
                }
            } else {
                if (this.debug.messageEnabled()) {
                    this.debug.message(classMethod + currentAMIdName + " has " + subRealms.size() + " subrealms");
                }
                int num = 0;
                for (AMIdentity amid : subRealms) {
                    String ss = amid.getName();
                    Set svcs = amid.getAssignedServices();
                    StringBuffer sb2 = new StringBuffer(ss);
                    if (this.debug.messageEnabled()) {
                        sb2.append(" has ").append(svcs.size()).append(" assigned services:\n");
                        Iterator it3 = svcs.iterator();
                        while (it3.hasNext()) {
                            sb2.append("    ").append(it3.next()).append("\n");
                        }
                        this.debug.message(classMethod + sb2.toString());
                    }
                    Set insts = this.getAuthModules(currentRealmAMIdName);
                    if (this.debug.messageEnabled()) {
                        StringBuffer sb3 = new StringBuffer(ss);
                        sb3.append(" has ").append(insts.size()).append(" auth modules:\n");
                        for (AMAuthenticationInstance ai : insts) {
                            sb3.append("    ").append(ai.getName()).append("\n");
                        }
                        this.debug.message(classMethod + sb3.toString());
                    }
                    insts = this.getSupportedEntityTypes(currentRealmAMIdName);
                    if (this.debug.messageEnabled()) {
                        sb2 = new StringBuffer("Supported Entity types for ");
                        sb2.append(currentAMIdName).append(":\n");
                        for (IdType type : insts) {
                            String stype = type.getName();
                            sb2.append("    ").append(stype);
                        }
                        this.debug.message(classMethod + sb2.toString());
                        this.debug.message(classMethod + currentAMIdName + "'s subrealm #" + num++ + " is " + ss);
                    }
                    this.doSubRealms(amid.getRealm());
                }
            }
        }
        catch (IdRepoException ire) {
            this.debug.error(classMethod + "IdRepoException getting AMIdentityRepository" + " object for root realm: " + ire.getMessage());
        }
        catch (SSOException ssoe) {
            this.debug.error(classMethod + "SSOException getting subrealms for root realm: " + ssoe.getMessage());
        }
    }

    private Set getAuthModules(String realm) {
        String classMethod = "ConfigMonitoring.getAuthModules: ";
        Set insts = Collections.EMPTY_SET;
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(this.ssoToken, realm);
            insts = mgr.getAuthenticationInstances();
        }
        catch (AMConfigurationException e) {
            this.debug.error(classMethod + "getting auth instances; " + e.getMessage());
        }
        return insts;
    }

    private Set getSupportedEntityTypes(String realm) {
        String classMethod = "ConfigMonitoring.getSupportedEntityTypes: ";
        Set supportedTypes = Collections.EMPTY_SET;
        try {
            AMIdentityRepository repo = new AMIdentityRepository(this.ssoToken, realm);
            supportedTypes = repo.getSupportedIdTypes();
        }
        catch (IdRepoException e) {
            this.debug.error(classMethod + "idrepo exception getting supported entity types; " + e.getMessage());
        }
        catch (SSOException e) {
            this.debug.error(classMethod + "sso exception getting supported entity types; " + e.getMessage());
        }
        return supportedTypes;
    }

    private void getAgentTypes() {
        String classMethod = "ConfigMonitoring.getAgentTypes: ";
        Set agents = null;
        try {
            agents = AgentConfiguration.getAgentTypes();
        }
        catch (SMSException sme) {
            this.debug.error(classMethod + "sms exception: " + sme.getMessage());
            return;
        }
        catch (SSOException sse) {
            this.debug.error(classMethod + "sso exception: " + sse.getMessage());
            return;
        }
        StringBuffer sb = new StringBuffer(classMethod);
        if (this.debug.messageEnabled()) {
            sb.append("number of AgentTypes = ").append(agents.size()).append(":\n");
        }
        for (String s : agents) {
            sb.append("  ").append(s).append("\n");
        }
        if (this.debug.messageEnabled()) {
            this.debug.error(sb.toString());
        }
    }

    private void getAgents(String realm) {
        String classMethod = "ConfigMonitoring.getAgents: ";
        StringBuffer sb = new StringBuffer(classMethod);
        try {
            IdSearchControl isc = new IdSearchControl();
            isc.setMaxResults(0);
            isc.setTimeOut(3000);
            isc.setAllReturnAttributes(false);
            AMIdentityRepository airepo = new AMIdentityRepository(this.ssoToken, realm);
            IdSearchResults isr = airepo.searchIdentities(IdType.AGENT, "*", isc);
            Set results = isr.getSearchResults();
            sb = new StringBuffer("Agents for realm ");
            sb.append(realm).append("; size = ").append(results.size()).append(":\n");
            for (AMIdentity aid : results) {
                this.processAgentIdentity(aid, sb);
            }
            this.debug.error(classMethod + sb.toString());
        }
        catch (IdRepoException e) {
            this.debug.error(classMethod + "idrepo error getting agents: " + e.getMessage());
        }
        catch (SSOException e) {
            this.debug.error(classMethod + "sso error getting agents: " + e.getMessage());
        }
    }

    private void getAgentGroups(String realm) {
        String classMethod = "ConfigMonitoring.getAgentGroups: ";
        StringBuffer sb = new StringBuffer(classMethod);
        try {
            IdSearchControl isc = new IdSearchControl();
            isc.setMaxResults(0);
            isc.setTimeOut(3000);
            isc.setAllReturnAttributes(false);
            AMIdentityRepository airepo = new AMIdentityRepository(this.ssoToken, realm);
            IdSearchResults isr = airepo.searchIdentities(IdType.AGENTGROUP, "*", isc);
            Set results = isr.getSearchResults();
            sb = new StringBuffer("AgentGroups for realm ");
            sb.append(realm).append("; size = ").append(results.size()).append(":\n");
            for (AMIdentity aid : results) {
                this.processAgentIdentity(aid, sb);
            }
            this.debug.error(classMethod + sb.toString());
        }
        catch (IdRepoException e) {
            this.debug.error(classMethod + "idrepo error getting agents: " + e.getMessage());
        }
        catch (SSOException e) {
            this.debug.error(classMethod + "sso error getting agents: " + e.getMessage());
        }
    }

    private void getAgentsAndGroupsInfo(String realm, AMIdentityRepository airepo, AMIdentity amid) {
        String classMethod = "ConfigMonitoring.getAgentsAndGroupsInfo: ";
        StringBuffer sb = new StringBuffer(classMethod);
        try {
            Map m;
            IdSearchControl isc = new IdSearchControl();
            isc.setMaxResults(0);
            isc.setTimeOut(3000);
            isc.setAllReturnAttributes(false);
            IdSearchResults isr = airepo.searchIdentities(IdType.AGENTONLY, "*", isc);
            Set results = isr.getSearchResults();
            sb = new StringBuffer("\n  Agents for realm ");
            if (this.debug.messageEnabled()) {
                sb.append(realm).append("; quantity = ").append(results.size()).append(":\n");
            }
            HashMap<String, Map> raMap = new HashMap<String, Map>();
            for (AMIdentity aid : results) {
                m = this.processAgentIdentitySpecific(realm, aid, sb, true);
                raMap.put(aid.getName(), m);
            }
            if (!raMap.isEmpty()) {
                Agent.configAgentsOnly(realm, raMap);
            }
            isc = new IdSearchControl();
            isc.setMaxResults(0);
            isc.setTimeOut(3000);
            isc.setAllReturnAttributes(false);
            isr = airepo.searchIdentities(IdType.AGENTGROUP, "*", isc);
            results = isr.getSearchResults();
            if (this.debug.messageEnabled()) {
                sb.append("\n  Agent Groups for realm ");
                sb.append(realm).append("; quantity = ").append(results.size()).append(":\n");
            }
            raMap = new HashMap();
            for (AMIdentity aid : results) {
                m = this.processAgentIdentitySpecific(realm, aid, sb, false);
                raMap.put(aid.getName(), m);
            }
            if (!raMap.isEmpty()) {
                Agent.configAgentGroups(realm, raMap);
            }
            if (this.debug.messageEnabled()) {
                this.debug.message(classMethod + sb.toString());
            }
        }
        catch (IdRepoException e) {
            this.debug.error(classMethod + "idrepo error getting agents: " + e.getMessage());
        }
        catch (SSOException e) {
            this.debug.error(classMethod + "sso error getting agents: " + e.getMessage());
        }
    }

    private void processAgentIdentity(AMIdentity aid, StringBuffer sb) {
        String classMethod = "ConfigMonitoring.processAgentIdentity: ";
        sb.append("  name = ").append(aid.getName()).append(", type = ").append(aid.getType().toString());
        Map attrv = null;
        Set attrs = null;
        try {
            attrv = aid.getAttributes();
            attrs = (Set)attrv.get("AgentType");
        }
        catch (IdRepoException e) {
            this.debug.error(classMethod + "idrepo error getting attrs");
            return;
        }
        catch (SSOException e) {
            this.debug.error(classMethod + "sso error getting attrs");
            return;
        }
        String atype = "UNKNOWN";
        if (attrs != null && !attrs.isEmpty()) {
            atype = (String)attrs.iterator().next();
        }
        sb.append(", agent type = ").append(atype).append(",\n         memberships =");
        Set mships = null;
        try {
            mships = aid.getMemberships(IdType.AGENTGROUP);
        }
        catch (IdRepoException e) {
            this.debug.error(classMethod + "idrepo error getting agentgroups");
            return;
        }
        catch (SSOException e) {
            this.debug.error(classMethod + "sso error getting agentgroups");
            return;
        }
        if (mships != null && !mships.isEmpty()) {
            for (AMIdentity amd : mships) {
                sb.append(" ").append(amd.getName());
            }
        } else {
            sb.append(" NONE");
        }
        sb.append("\n");
        try {
            Map amap = aid.getAttributes();
            sb.append("         Attributes:\n");
            if (amap.size() < 1) {
                sb.append("          NONE\n");
            } else {
                for (String attrName : amap.keySet()) {
                    sb.append("           ").append(attrName).append(" = ");
                    Set attrv2 = (Set)amap.get(attrName);
                    if (attrv2.size() == 0) {
                        sb.append("NONE");
                    } else {
                        Iterator iu = attrv2.iterator();
                        String attrval = (String)iu.next();
                        sb.append(attrval);
                        if (attrv2.size() > 1) {
                            while (iu.hasNext()) {
                                attrval = (String)iu.next();
                                sb.append(", ").append(attrval);
                            }
                        }
                    }
                    sb.append("\n");
                }
            }
            Set iattrs = AgentConfiguration.getInheritedAttributeNames(aid);
            Iterator it3 = iattrs.iterator();
            sb.append("         Inherited Attribute names:\n");
            if (iattrs.size() < 1) {
                sb.append("          NONE");
            } else {
                while (it3.hasNext()) {
                    String attrName = (String)it3.next();
                    sb.append("           ").append(attrName).append("\n");
                }
            }
            sb.append("\n");
        }
        catch (IdRepoException ex) {
            this.debug.error(classMethod + "idrepo error getting attrs");
        }
        catch (SSOException ex) {
            this.debug.error(classMethod + "sso error getting attrs");
        }
        catch (SMSException ex) {
            this.debug.error(classMethod + "sms error getting attrs");
        }
    }

    private Map processAgentIdentitySpecific(String realm, AMIdentity aid, StringBuffer sb, boolean isAgentOnly) {
        String classMethod = "ConfigMonitoring.processAgentIdentitySpecific: ";
        String agentOrGroup = aid.getType().toString();
        sb.append("  name = ").append(aid.getName());
        sb.append(", type = ").append(agentOrGroup).append(", ");
        Map attrv = null;
        Object attrs = null;
        HashSet<String> attrsToGet = new HashSet<String>();
        attrsToGet.add("AgentType");
        attrsToGet.add("com.sun.identity.agents.config.agenturi.prefix");
        attrsToGet.add("com.sun.identity.agents.config.login.url");
        attrsToGet.add("wspendpoint");
        attrsToGet.add("wspproxyendpoint");
        attrsToGet.add("stsendpoint");
        attrsToGet.add("discoveryendpoint");
        attrsToGet.add("authnserviceendpoint");
        attrsToGet.add("com.sun.identity.client.notification.url");
        try {
            attrv = aid.getAttributes(attrsToGet);
        }
        catch (IdRepoException e) {
            this.debug.error(classMethod + "idrepo error getting attrs");
            return null;
        }
        catch (SSOException e) {
            this.debug.error(classMethod + "sso error getting attrs");
            return null;
        }
        String atype = this.getValFromSet(attrv, "AgentType");
        attrsToGet = new HashSet();
        if (!atype.equalsIgnoreCase("2.2_Agent")) {
            if (atype.equalsIgnoreCase("WSCAgent")) {
                attrsToGet.add("wspendpoint");
                attrsToGet.add("wspproxyendpoint");
            } else if (atype.equalsIgnoreCase("STSAgent")) {
                attrsToGet.add("stsendpoint");
            } else if (atype.equalsIgnoreCase("DiscoveryAgent")) {
                attrsToGet.add("discoveryendpoint");
                attrsToGet.add("authnserviceendpoint");
            } else if (atype.equalsIgnoreCase("J2EEAgent")) {
                attrsToGet.add("com.sun.identity.agents.config.login.url");
                attrsToGet.add("com.sun.identity.client.notification.url");
            } else if (atype.equalsIgnoreCase("WSPAgent")) {
                attrsToGet.add("wspendpoint");
                attrsToGet.add("wspproxyendpoint");
            } else if (atype.equalsIgnoreCase("WebAgent")) {
                attrsToGet.add("com.sun.identity.agents.config.agenturi.prefix");
                attrsToGet.add("com.sun.identity.agents.config.login.url");
            }
        }
        HashMap<String, String> attrMap = new HashMap<String, String>();
        HashMap agtMap = new HashMap();
        attrMap.put("AgentType", atype);
        sb.append("agent type = ").append(atype).append("\n");
        if (attrsToGet.size() > 0) {
            sb.append("    RETRIEVED Attributes/values:\n");
            for (String key : attrsToGet) {
                int ind;
                String val = this.getValFromSet(attrv, key);
                if (key.equalsIgnoreCase("com.sun.identity.client.notification.url") && (ind = val.lastIndexOf("/notification")) > -1) {
                    val = val.substring(0, ind);
                }
                sb.append("      attr = ").append(key).append("\n      ").append("value = ").append(val).append("\n");
                attrMap.put(key, val);
            }
        } else {
            sb.append("    No attributes to display\n");
        }
        if (isAgentOnly) {
            sb.append("    MEMBERSHIP(s) =");
            Set mships = null;
            try {
                mships = aid.getMemberships(IdType.AGENTGROUP);
            }
            catch (IdRepoException e) {
                this.debug.error(classMethod + "idrepo error getting agentgroups");
                sb.append("ERROR");
            }
            catch (SSOException e) {
                this.debug.error(classMethod + "sso error getting agentgroups");
                sb.append("ERROR");
            }
            if (mships != null && !mships.isEmpty()) {
                for (AMIdentity amd : mships) {
                    String grp = amd.getName();
                    sb.append(" ").append(grp);
                    attrMap.put("groupmembership", grp);
                }
            } else {
                sb.append(" NONE");
            }
        }
        sb.append("\n");
        return attrMap;
    }

    private String getValFromSet(Map values, String valAttr) {
        Set set = (Set)values.get(valAttr);
        if (set.size() > 0) {
            return (String)set.iterator().next();
        }
        return "NONE";
    }

    private int getMonServiceAttrs() {
        String classMethod = "ConfigMonitoring.getMonServiceAttrs: ";
        try {
            SSOServerMonConfig sMonInfo;
            int i;
            ServiceSchemaManager schemaManager = new ServiceSchemaManager("iPlanetAMMonitoringService", this.ssoToken);
            ServiceSchema smsMonSchema = schemaManager.getGlobalSchema();
            Map monAttrs = smsMonSchema.getAttributeDefaults();
            boolean monEna = Boolean.valueOf(CollectionHelper.getMapAttr((Map)monAttrs, (String)"iplanet-am-monitoring-enabled"));
            if (!monEna) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning(classMethod + "monitoring is disabled");
                }
                return -1;
            }
            boolean httpEna = Boolean.valueOf(CollectionHelper.getMapAttr((Map)monAttrs, (String)"iplanet-am-monitoring-http-enabled"));
            int httpPort = Integer.valueOf(CollectionHelper.getMapAttr((Map)monAttrs, (String)"iplanet-am-monitoring-http-port"));
            int rmiPort = Integer.valueOf(CollectionHelper.getMapAttr((Map)monAttrs, (String)"iplanet-am-monitoring-rmi-port"));
            boolean rmiEna = Boolean.valueOf(CollectionHelper.getMapAttr((Map)monAttrs, (String)"iplanet-am-monitoring-rmi-enabled"));
            int snmpPort = Integer.valueOf(CollectionHelper.getMapAttr((Map)monAttrs, (String)"iplanet-am-monitoring-snmp-port"));
            boolean snmpEna = Boolean.valueOf(CollectionHelper.getMapAttr((Map)monAttrs, (String)"iplanet-am-monitoring-snmp-enabled"));
            if (this.debug.messageEnabled()) {
                this.debug.message(classMethod + "\n" + "     monitoring enabled = " + monEna + "\n" + "     httpPort = " + httpPort + "\n" + "     httpPort enabled = " + httpEna + "\n" + "     rmiPort = " + rmiPort + "\n" + "     rmiPort enabled = " + rmiEna + "\n" + "     snmpPort = " + snmpPort + "\n" + "     snmpPort enabled = " + snmpEna + "\n");
            }
            if ((i = Agent.startAgent(sMonInfo = new SSOServerMonConfig.SSOServerMonInfoBuilder(monEna).htmlPort(httpPort).snmpPort(snmpPort).rmiPort(rmiPort).monHtmlEnabled(httpEna).monRmiEnabled(rmiEna).monSnmpEnabled(snmpEna).build())) != 0) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning(classMethod + "Monitoring Agent not started (" + i + ")");
                }
                return i;
            }
        }
        catch (Exception ex) {
            this.debug.error(classMethod + "error reading Monitoring attributes: " + ex.getMessage());
            return -1;
        }
        return 0;
    }
}

