/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.config.wizard;

import com.sun.identity.config.util.AjaxPage;
import com.sun.identity.setup.AMSetupServlet;
import java.io.File;
import net.sf.click.control.ActionLink;

public class Step2
extends AjaxPage {
    public ActionLink validateConfigDirLink = new ActionLink("validateConfigDir", (Object)this, "validateConfigDir");

    public void onInit() {
        String val = (String)this.getContext().getSessionAttribute("serverURL");
        if (val == null) {
            val = this.getServerURL();
        }
        this.add("serverURL", val);
        val = (String)this.getContext().getSessionAttribute("cookieDomain");
        if (val == null) {
            val = this.getCookieDomain();
        }
        this.add("cookieDomain", val);
        val = (String)this.getContext().getSessionAttribute("platformLocale");
        if (val == null) {
            val = "en_US";
        }
        this.add("platformLocale", val);
        String baseDir = null;
        String presetDir = AMSetupServlet.getPresetConfigDir();
        if (presetDir == null || presetDir.trim().length() == 0) {
            this.add("fixDir", "onkeyup=\"APP.callDelayed(this, validateConfigDir)\"");
            val = (String)this.getContext().getSessionAttribute("configDirectory");
            if (val == null) {
                val = this.getBaseDir(this.getContext().getRequest());
            }
            this.add("configDirectory", val);
            baseDir = val;
        } else {
            this.add("fixDir", "disabled");
            this.add("configDirectory", presetDir);
            baseDir = presetDir;
        }
        if (Step2.hasWritePermission(baseDir)) {
            this.add("canWriteDir", "");
        } else {
            this.add("canWriteDir", this.getLocalizedString("configuration.wizard.step2.no.write.permission.to.basedir"));
        }
        super.onInit();
    }

    private static boolean hasWritePermission(String dirName) {
        File f;
        for (f = new File(dirName); f != null && !f.exists(); f = f.getParentFile()) {
        }
        return f == null ? false : f.isDirectory() && f.canWrite();
    }

    public boolean validateConfigDir() {
        String configDir = this.toString("dir");
        if (configDir == null) {
            this.writeToResponse(this.getLocalizedString("missing.required.field"));
        } else if (!Step2.hasWritePermission(configDir)) {
            this.writeToResponse(this.getLocalizedString("configuration.wizard.step2.no.write.permission.to.basedir"));
        } else {
            this.getContext().setSessionAttribute("configDirectory", (Object)configDir);
            this.writeToResponse("true");
        }
        this.setPath(null);
        return false;
    }

    private String getServerURL() {
        String hostname = this.getContext().getRequest().getServerName();
        int portnum = this.getContext().getRequest().getServerPort();
        String protocol = this.getContext().getRequest().getScheme();
        return protocol + "://" + hostname + ":" + portnum;
    }

    private void add(String key, String value) {
        this.addModel(key, value);
        this.getContext().setSessionAttribute(key, (Object)value);
    }
}

