/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.config.wizard;

import com.iplanet.am.util.SSLSocketFactoryManager;
import com.sun.identity.config.util.AjaxPage;
import com.sun.identity.config.wizard.Wizard;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.util.DN;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import net.sf.click.Context;
import net.sf.click.control.ActionLink;

public class Step4
extends AjaxPage {
    public static final String LDAP_STORE_SESSION_KEY = "wizardCustomUserStore";
    public ActionLink validateUMHostLink = new ActionLink("validateUMHost", (Object)this, "validateUMHost");
    public ActionLink validateUMDomainNameLink = new ActionLink("validateUMDomainName", (Object)this, "validateUMDomainName");
    public ActionLink setSSLLink = new ActionLink("setSSL", (Object)this, "setSSL");
    public ActionLink setUMEmbedded = new ActionLink("setUMEmbedded", (Object)this, "setUMEmbedded");
    public ActionLink resetUMEmbedded = new ActionLink("resetUMEmbedded", (Object)this, "resetUMEmbedded");
    public ActionLink setHostLink = new ActionLink("setHost", (Object)this, "setHost");
    public ActionLink setDomainNameLink = new ActionLink("setDomainName", (Object)this, "setDomainName");
    public ActionLink setPortLink = new ActionLink("setPort", (Object)this, "setPort");
    public ActionLink setRootSuffixLink = new ActionLink("setRootSuffix", (Object)this, "setRootSuffix");
    public ActionLink setLoginIDLink = new ActionLink("setLoginID", (Object)this, "setLoginID");
    public ActionLink setPasswordLink = new ActionLink("setPassword", (Object)this, "setPassword");
    public ActionLink setStoreTypeLink = new ActionLink("setStoreType", (Object)this, "setStoreType");
    private String responseString = "ok";

    public void onInit() {
        String smsType;
        super.onInit();
        Context ctx = this.getContext();
        if (ctx.getSessionAttribute("userStoreHostName") == null) {
            String val = this.getAttribute("DATA_STORE", "embedded");
            if (!val.equals("embedded")) {
                val = this.getAttribute("configStoreSSL", "SIMPLE");
                ctx.setSessionAttribute("userStoreSSL", (Object)val);
                val = this.getAttribute("configStoreHost", this.getHostName());
                ctx.setSessionAttribute("userStoreHostName", (Object)val);
                val = this.getAttribute("configStorePort", "389");
                ctx.setSessionAttribute("userStorePort", (Object)val);
                val = this.getAttribute("configStoreLoginId", Wizard.defaultUserName);
                ctx.setSessionAttribute("userStoreLoginID", (Object)val);
                val = this.getAttribute("rootSuffix", Wizard.defaultRootSuffix);
                ctx.setSessionAttribute("userStoreRootSuffix", (Object)val);
            }
            ctx.setSessionAttribute("EXT_DATA_STORE", (Object)"true");
            ctx.setSessionAttribute("userStoreType", (Object)"LDAPv3ForSUNDS");
        }
        if (!(smsType = this.getAttribute("DATA_STORE", "embedded")).equals("embedded")) {
            ctx.setSessionAttribute("EXT_DATA_STORE", (Object)"true");
            this.addModel("radioDataTypeDisabled", "disabled");
        } else {
            this.addModel("radioDataTypeDisabled", "");
        }
        String val = this.getAttribute("userStoreHostName", this.getHostName());
        ctx.setSessionAttribute("userStoreHostName", (Object)val);
        this.addModel("userStoreHost", val);
        val = this.getAttribute("userStoreSSL", "SIMPLE");
        ctx.setSessionAttribute("userStoreSSL", (Object)val);
        if (val.equals("SSL")) {
            this.addModel("selectUserStoreSSL", "checked=\"checked\"");
        } else {
            this.addModel("selectUserStoreSSL", "");
        }
        val = this.getAttribute("userStorePort", "389");
        ctx.setSessionAttribute("userStorePort", (Object)val);
        this.addModel("userStorePort", val);
        val = this.getAttribute("userStoreLoginID", Wizard.defaultUserName);
        ctx.setSessionAttribute("userStoreLoginID", (Object)val);
        this.addModel("userStoreLoginId", val);
        val = this.getAttribute("userStoreRootSuffix", Wizard.defaultRootSuffix);
        ctx.setSessionAttribute("userStoreRootSuffix", (Object)val);
        this.addModel("userStoreRootSuffix", val);
        val = this.getAttribute("userStoreType", "LDAPv3ForSUNDS");
        if (val.equals("LDAPv3ForAD")) {
            this.addModel("selectLDAPv3ad", "checked=\"checked\"");
            this.addModel("selectLDAPv3addc", "");
            this.addModel("selectLDAPv3sunds", "");
            this.addModel("selectLDAPv3opends", "");
            this.addModel("selectLDAPv3tivoli", "");
        } else if (val.equals("LDAPv3ForADDC")) {
            this.addModel("selectLDAPv3addc", "checked=\"checked\"");
            this.addModel("selectLDAPv3ad", "");
            this.addModel("selectLDAPv3sunds", "");
            this.addModel("selectLDAPv3opends", "");
            this.addModel("selectLDAPv3tivoli", "");
        } else if (val.equals("LDAPv3ForSUNDS")) {
            this.addModel("selectLDAPv3sunds", "checked=\"checked\"");
            this.addModel("selectLDAPv3ad", "");
            this.addModel("selectLDAPv3addc", "");
            this.addModel("selectLDAPv3opends", "");
            this.addModel("selectLDAPv3tivoli", "");
        } else if (val.equals("LDAPv3ForOpenDS")) {
            this.addModel("selectLDAPv3opends", "checked=\"checked\"");
            this.addModel("selectLDAPv3ad", "");
            this.addModel("selectLDAPv3addc", "");
            this.addModel("selectLDAPv3sunds", "");
            this.addModel("selectLDAPv3tivoli", "");
        } else {
            this.addModel("selectLDAPv3tivoli", "checked=\"checked\"");
            this.addModel("selectLDAPv3ad", "");
            this.addModel("selectLDAPv3addc", "");
            this.addModel("selectLDAPv3sunds", "");
            this.addModel("selectLDAPv3opends", "");
        }
        val = this.getAttribute("EXT_DATA_STORE", "true");
        this.addModel("EXT_DATA_STORE", val);
        if (val.equals("true")) {
            this.addModel("selectEmbeddedUM", "");
            this.addModel("selectExternalUM", "checked=\"checked\"");
        } else {
            this.addModel("selectEmbeddedUM", "checked=\"checked\"");
            this.addModel("selectExternalUM", "");
        }
    }

    public boolean setAll() {
        this.setPath(null);
        return false;
    }

    public boolean setSSL() {
        String ssl = this.toString("ssl");
        if (ssl != null && ssl.length() > 0) {
            this.getContext().setSessionAttribute("userStoreSSL", (Object)ssl);
        } else {
            this.getContext().setSessionAttribute("userStoreSSL", (Object)"SIMPLE");
        }
        this.writeToResponse(this.getLocalizedString(this.responseString));
        this.setPath(null);
        return false;
    }

    public boolean setDomainName() {
        String domainname = this.toString("domainname");
        if (domainname != null && domainname.length() > 0) {
            this.getContext().setSessionAttribute("userStoreDomainName", (Object)domainname);
            this.getContext().setSessionAttribute("EXT_DATA_STORE", (Object)"true");
        } else {
            this.responseString = "missing.domain.name";
        }
        this.writeToResponse(this.getLocalizedString(this.responseString));
        this.setPath(null);
        return false;
    }

    public boolean setHost() {
        String host = this.toString("host");
        if (host != null && host.length() > 0) {
            this.getContext().setSessionAttribute("userStoreHostName", (Object)host);
        } else {
            this.responseString = "missing.host.name";
        }
        this.writeToResponse(this.getLocalizedString(this.responseString));
        this.setPath(null);
        return false;
    }

    public boolean setUMEmbedded() {
        this.getContext().setSessionAttribute("EXT_DATA_STORE", (Object)"false");
        this.setPath(null);
        return false;
    }

    public boolean resetUMEmbedded() {
        this.getContext().setSessionAttribute("EXT_DATA_STORE", (Object)"true");
        this.setPath(null);
        return false;
    }

    public boolean setPort() {
        String port = this.toString("port");
        if (port != null && port.length() > 0) {
            int intValue = Integer.parseInt(port);
            if (intValue > 0 && intValue < 65535) {
                this.getContext().setSessionAttribute("userStorePort", (Object)port);
            } else {
                this.responseString = "invalid.port.number";
            }
        } else {
            this.responseString = "missing.host.port";
        }
        this.writeToResponse(this.getLocalizedString(this.responseString));
        this.setPath(null);
        return false;
    }

    public boolean setLoginID() {
        String dn = this.toString("dn");
        if (dn != null && dn.length() > 0) {
            this.getContext().setSessionAttribute("userStoreLoginID", (Object)dn);
        } else {
            this.responseString = "missing.login.id";
        }
        this.writeToResponse(this.getLocalizedString(this.responseString));
        this.setPath(null);
        return false;
    }

    public boolean setPassword() {
        String pwd = this.toString("password");
        if (pwd != null && pwd.length() > 0) {
            this.getContext().setSessionAttribute("userStoreLoginPassword", (Object)pwd);
        } else {
            this.responseString = "missing.password";
        }
        this.writeToResponse(this.getLocalizedString(this.responseString));
        this.setPath(null);
        return false;
    }

    public boolean setRootSuffix() {
        String rootsuffix = this.toString("rootsuffix");
        if (rootsuffix != null && rootsuffix.length() > 0) {
            if (DN.isDN((String)rootsuffix)) {
                this.getContext().setSessionAttribute("userStoreRootSuffix", (Object)rootsuffix);
            } else {
                this.responseString = "invalid.dn";
            }
        } else {
            this.responseString = "missing.root.suffix";
        }
        this.writeToResponse(this.getLocalizedString(this.responseString));
        this.setPath(null);
        return false;
    }

    public boolean setStoreType() {
        String type = this.toString("type");
        if (type != null && type.length() > 0) {
            this.getContext().setSessionAttribute("userStoreType", (Object)type);
        }
        this.writeToResponse(this.responseString);
        this.setPath(null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean validateUMHost() {
        ctx = this.getContext();
        strSSL = (String)ctx.getSessionAttribute("userStoreSSL");
        ssl = strSSL != null && strSSL.equals("SSL") != false;
        host = (String)ctx.getSessionAttribute("userStoreHostName");
        strPort = (String)ctx.getSessionAttribute("userStorePort");
        port = Integer.parseInt(strPort);
        bindDN = (String)ctx.getSessionAttribute("userStoreLoginID");
        rootSuffix = (String)ctx.getSessionAttribute("userStoreRootSuffix");
        bindPwd = (String)ctx.getSessionAttribute("userStoreLoginPassword");
        ld = null;
        try {
            ld = ssl != false ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
            ld.setConnectTimeout(300);
            ld.connect(3, host, port, bindDN, bindPwd);
            filter = "cn=\"" + rootSuffix + "\"";
            attrs = new String[]{""};
            ld.search(rootSuffix, 0, filter, attrs, false);
            this.writeToResponse("ok");
        }
        catch (LDAPException lex) {
            switch (lex.getLDAPResultCode()) {
                case 91: {
                    this.writeToResponse(this.getLocalizedString("ldap.connect.error"));
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 81: {
                    this.writeToResponse(this.getLocalizedString("ldap.server.down"));
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                case 34: {
                    this.writeToResponse(this.getLocalizedString("ldap.invalid.dn"));
                    ** break;
lbl34:
                    // 1 sources

                    break;
                }
                case 32: {
                    this.writeToResponse(this.getLocalizedString("ldap.nosuch.object"));
                    ** break;
lbl38:
                    // 1 sources

                    break;
                }
                case 49: {
                    this.writeToResponse(this.getLocalizedString("ldap.invalid.credentials"));
                    ** break;
lbl42:
                    // 1 sources

                    break;
                }
                case 53: {
                    this.writeToResponse(this.getLocalizedString("ldap.unwilling"));
                    ** break;
lbl46:
                    // 1 sources

                    break;
                }
                case 48: {
                    this.writeToResponse(this.getLocalizedString("ldap.inappropriate"));
                    ** break;
lbl50:
                    // 1 sources

                    break;
                }
                case 19: {
                    this.writeToResponse(this.getLocalizedString("ldap.constraint"));
                    ** break;
lbl54:
                    // 1 sources

                    break;
                }
                default: {
                    this.writeToResponse(this.getLocalizedString("cannot.connect.to.SM.datastore"));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.writeToResponse(this.getLocalizedString("cannot.connect.to.SM.datastore"));
        }
        finally {
            if (ld != null) {
                try {
                    ld.disconnect();
                }
                catch (LDAPException ex) {}
            }
        }
        this.setPath(null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean validateUMDomainName() {
        ctx = this.getContext();
        strSSL = (String)ctx.getSessionAttribute("userStoreSSL");
        ssl = strSSL != null && strSSL.equals("SSL") != false;
        domainName = (String)ctx.getSessionAttribute("userStoreDomainName");
        rootSuffixAD = Step4.dnsDomainToDN(domainName);
        this.getContext().setSessionAttribute("userStoreRootSuffix", (Object)rootSuffixAD);
        hostAndPort = new String[]{""};
        try {
            hostAndPort = this.getLdapHostAndPort(domainName);
        }
        catch (NamingException nex) {
            this.writeToResponse(this.getLocalizedString("cannot.connect.to.UM.datastore"));
        }
        catch (IOException ioex) {
            this.writeToResponse(this.getLocalizedString("cannot.connect.to.UM.datastore"));
        }
        host = hostAndPort[0];
        port = Integer.parseInt(hostAndPort[1]);
        bindDN = (String)ctx.getSessionAttribute("userStoreLoginID");
        rootSuffix = (String)ctx.getSessionAttribute("userStoreRootSuffix");
        bindPwd = (String)ctx.getSessionAttribute("userStoreLoginPassword");
        ld = null;
        try {
            ld = ssl != false ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
            ld.setConnectTimeout(300);
            ld.connect(3, host, port, bindDN, bindPwd);
            filter = "cn=\"" + rootSuffix + "\"";
            attrs = new String[]{""};
            ld.search(rootSuffix, 0, filter, attrs, false);
            this.writeToResponse("ok");
        }
        catch (LDAPException lex) {
            switch (lex.getLDAPResultCode()) {
                case 91: {
                    this.writeToResponse(this.getLocalizedString("ldap.connect.error"));
                    ** break;
lbl37:
                    // 1 sources

                    break;
                }
                case 81: {
                    this.writeToResponse(this.getLocalizedString("ldap.server.down"));
                    ** break;
lbl41:
                    // 1 sources

                    break;
                }
                case 34: {
                    this.writeToResponse(this.getLocalizedString("ldap.invalid.dn"));
                    ** break;
lbl45:
                    // 1 sources

                    break;
                }
                case 32: {
                    this.writeToResponse(this.getLocalizedString("ldap.nosuch.object"));
                    ** break;
lbl49:
                    // 1 sources

                    break;
                }
                case 49: {
                    this.writeToResponse(this.getLocalizedString("ldap.invalid.credentials"));
                    ** break;
lbl53:
                    // 1 sources

                    break;
                }
                case 53: {
                    this.writeToResponse(this.getLocalizedString("ldap.unwilling"));
                    ** break;
lbl57:
                    // 1 sources

                    break;
                }
                case 48: {
                    this.writeToResponse(this.getLocalizedString("ldap.inappropriate"));
                    ** break;
lbl61:
                    // 1 sources

                    break;
                }
                case 19: {
                    this.writeToResponse(this.getLocalizedString("ldap.constraint"));
                    ** break;
lbl65:
                    // 1 sources

                    break;
                }
                default: {
                    this.writeToResponse(this.getLocalizedString("cannot.connect.to.UM.datastore"));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.writeToResponse(this.getLocalizedString("cannot.connect.to.UM.datastore"));
        }
        finally {
            if (ld != null) {
                try {
                    ld.disconnect();
                }
                catch (LDAPException ex) {}
            }
        }
        this.setPath(null);
        return false;
    }

    private String[] getLdapHostAndPort(String domainName) throws NamingException, IOException {
        if (!domainName.endsWith(".")) {
            domainName = domainName + '.';
        }
        InitialDirContext ictx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        ictx = new InitialDirContext(env);
        Attributes attributes = ictx.getAttributes(domainName, new String[]{"A"});
        Attribute attrib = attributes.get("A");
        if (attrib == null) {
            throw new NamingException();
        }
        String serverHostName = null;
        String serverPortStr = null;
        String ldapServer = "_ldap._tcp." + domainName;
        Attributes attributes2 = ictx.getAttributes(ldapServer, new String[]{"SRV"});
        Attribute attr = attributes2.get("SRV");
        if (attr == null) {
            throw new NamingException();
        }
        String[] srv = attr.get().toString().split(" ");
        String hostNam = srv[3];
        serverHostName = hostNam.substring(0, hostNam.length() - 1);
        if (serverHostName != null && serverHostName.length() > 0) {
            this.getContext().setSessionAttribute("userStoreHostName", (Object)serverHostName);
        }
        serverPortStr = srv[2];
        int serverPort = Integer.parseInt(serverPortStr);
        if (serverPort > 0 && serverPort < 65535) {
            this.getContext().setSessionAttribute("userStorePort", (Object)serverPortStr);
        }
        new Socket(serverHostName, serverPort).close();
        String[] hostAndPort = new String[]{serverHostName, serverPortStr};
        return hostAndPort;
    }

    static String dnsDomainToDN(String domainName) {
        StringBuilder buf = new StringBuilder();
        for (String token : domainName.split("\\.")) {
            if (token.length() == 0) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append("DC=").append(token);
        }
        return buf.toString();
    }
}

