/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm.model;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.dm.model.ContainerModel;
import com.sun.identity.console.dm.model.DMModelBase;
import com.sun.identity.console.property.PropertyXMLBuilderBase;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ContainerModelImpl
extends DMModelBase
implements ContainerModel {
    private static final String CREATE_PROPERTIES = "<section name=\"attributes\" defaultValue=\"\" ><property><label name=\"lblPcName\" defaultValue=\"label.name\" labelFor=\"tfPCName\" /><cc name=\"tfPCName\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" /></property></section>";

    public ContainerModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Set getContainers(String location, String filter) {
        AMStoreConnection sc = this.getAMStoreConnection();
        AMSearchResults results = null;
        AMSearchControl searchControl = new AMSearchControl();
        searchControl.setSearchScope(2);
        this.setSearchControlLimits(searchControl);
        this.setSearchControlAttributes(location, "GroupContainer", 4, searchControl, "groupContainers");
        boolean bOrganization = false;
        try {
            String[] params = new String[]{location, filter};
            switch (this.getObjectType(location)) {
                case 2: {
                    bOrganization = true;
                    this.logEvent("ATTEMPT_DIR_MGR_GET_CONTAINERS_FROM_ORGANIZATION", params);
                    AMOrganization org = sc.getOrganization(location);
                    results = org.searchOrganizationalUnits(filter, null, searchControl);
                    this.logEvent("SUCCEED_DIR_MGR_GET_CONTAINERS_FROM_ORGANIZATION", params);
                    break;
                }
                case 3: {
                    this.logEvent("ATTEMPT_DIR_MGR_GET_CONTAINERS_FROM_CONTAINER", params);
                    AMOrganizationalUnit orgUnit = sc.getOrganizationalUnit(location);
                    results = orgUnit.searchSubOrganizationalUnits(filter, null, searchControl);
                    this.logEvent("SUCCEED_DIR_MGR_GET_CONTAINERS_FROM_CONTAINER", params);
                    break;
                }
                default: {
                    if (debug.warningEnabled()) {
                        debug.warning("ContainerModel.getContainersinvalid location " + this.locationType);
                    }
                    break;
                }
            }
        }
        catch (SSOException e) {
            this.searchErrorMsg = this.getErrorString((Throwable)((Object)e));
            String msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_GET_CONTAINERS_FROM_ORGANIZATION" : "SSO_EXCEPTION_DIR_MGR_GET_CONTAINERS_FROM_CONTAINER";
            String[] paramsEx = new String[]{location, filter, this.searchErrorMsg};
            this.logEvent(msgId, paramsEx);
            debug.warning("ContainerModel.getContainers", (Throwable)((Object)e));
        }
        catch (AMException e) {
            this.searchErrorMsg = this.getErrorString(e);
            String msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_GET_CONTAINERS_FROM_ORGANIZATION" : "AM_EXCEPTION_DIR_MGR_GET_CONTAINERS_FROM_CONTAINER";
            String[] paramsEx = new String[]{location, filter, this.searchErrorMsg};
            this.logEvent(msgId, paramsEx);
            debug.warning("ContainerModel.getContainers", (Throwable)e);
        }
        return this.setSearchResults(results);
    }

    public void createContainer(String location, Map data) throws AMConsoleException {
        if (data == null || data.isEmpty()) {
            throw new AMConsoleException(this.getLocalizedString("createFailure.message"));
        }
        Set tmp = (Set)data.remove("tfPCName");
        if (tmp == null || tmp.isEmpty()) {
            throw new AMConsoleException(this.getLocalizedString("message.missing.name"));
        }
        String name = (String)tmp.iterator().next();
        if (name == null || name.length() == 0) {
            throw new AMConsoleException(this.getLocalizedString("message.missing.name"));
        }
        HashMap<String, Map> input = new HashMap<String, Map>(2);
        input.put(name, data);
        boolean bOrganization = false;
        try {
            String[] params = new String[]{location, name};
            int locType = this.getObjectType(location);
            if (locType == 2) {
                bOrganization = true;
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_CONTAINER_UNDER_ORGANIZATION", params);
                AMOrganization parent = this.getAMStoreConnection().getOrganization(location);
                parent.createOrganizationalUnits(input);
                this.logEvent("SUCCEED_DIR_MGR_CREATE_CONTAINER_UNDER_ORGANIZATION", params);
            } else if (locType == 3) {
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_CONTAINER_UNDER_CONTAINER", params);
                AMOrganizationalUnit parent = this.getAMStoreConnection().getOrganizationalUnit(location);
                parent.createSubOrganizationalUnits(input);
                this.logEvent("SUCCEED_DIR_MGR_CREATE_CONTAINER_UNDER_CONTAINER", params);
            }
        }
        catch (AMException e) {
            String msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_CREATE_CONTAINER_UNDER_ORGANIZATION" : "AM_EXCEPTION_DIR_MGR_CREATE_CONTAINER_UNDER_CONTAINER";
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{location, name, strError};
            this.logEvent(msgId, paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_CREATE_CONTAINER_UNDER_ORGANIZATION" : "SSO_EXCEPTION_DIR_MGR_CREATE_CONTAINER_UNDER_CONTAINER";
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{location, name, strError};
            this.logEvent(msgId, paramsEx);
            debug.error("error in sso", (Throwable)((Object)e));
        }
    }

    public String getCreateContainerXML() {
        StringBuffer buff = new StringBuffer(2000);
        buff.append(PropertyXMLBuilderBase.getXMLDefinitionHeader()).append("<propertysheet>\n").append(CREATE_PROPERTIES);
        this.getPropertyXML("iPlanetAMEntrySpecificService", "GroupContainer", SchemaType.GLOBAL, buff);
        buff.append("</propertysheet>\n");
        return buff.toString();
    }

    public Map getDataMap() {
        HashMap<String, Set> map = new HashMap<String, Set>();
        try {
            Set attrSchemas;
            ServiceSchema sub = this.getSubSchema("iPlanetAMEntrySpecificService", SchemaType.GLOBAL, "GroupContainer");
            if (sub != null && (attrSchemas = sub.getAttributeSchemas()) != null) {
                for (AttributeSchema as : attrSchemas) {
                    map.put(as.getName().toLowerCase(), Collections.EMPTY_SET);
                }
            }
            map.put("tfPCName", Collections.EMPTY_SET);
        }
        catch (SMSException e) {
            debug.error("ContainerModel.getDataMap", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("ContainerModel.getDataMap error in sso", (Throwable)((Object)e));
        }
        return map;
    }

    public boolean hasDisplayProperties() {
        Map tmp = this.getDataMap();
        tmp.remove("tfPCName");
        return !tmp.isEmpty();
    }

    public Map getAssignedServices(String location) {
        HashMap<String, String> names = null;
        try {
            String[] param = new String[]{location};
            this.logEvent("ATTEMPT_DIR_MGR_GET_ASSIGNED_SERVICE_TO_CONTAINER", param);
            AMOrganizationalUnit ou = this.getAMStoreConnection().getOrganizationalUnit(location);
            Set tmp = ou.getRegisteredServiceNames();
            if (tmp != null && !tmp.isEmpty()) {
                names = new HashMap<String, String>(tmp.size() * 2);
                for (String name : tmp) {
                    String displayName;
                    if (name.equals(displayName = this.getLocalizedServiceName(name))) continue;
                    names.put(name, displayName);
                }
            }
            this.logEvent("SUCCEED_DIR_MGR_GET_ASSIGNED_SERVICE_TO_CONTAINER", param);
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{location, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_GET_ASSIGNED_SERVICE_TO_CONTAINER", paramsEx);
            debug.warning("ContainerModelImpl.getOrganizations", (Throwable)((Object)e));
        }
        catch (AMException e) {
            String[] paramsEx = new String[]{location, this.getErrorString(e)};
            this.logEvent("AM_EXCEPTION_DIR_MGR_GET_ASSIGNED_SERVICE_TO_CONTAINER", paramsEx);
            debug.warning("ContainerModelImpl.getOrganizations", (Throwable)e);
        }
        return names == null ? Collections.EMPTY_MAP : names;
    }
}

