/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.idm;

import com.iplanet.am.util.Locale;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.idm.EntityEditViewBean;
import com.sun.identity.console.idm.ServicesEditViewBean;
import com.sun.identity.console.idm.ServicesSelectViewBean;
import com.sun.identity.console.idm.ServicesTiledView;
import com.sun.identity.console.idm.model.EntitiesModel;
import com.sun.identity.console.service.model.SCUtils;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class EntityServicesViewBean
extends EntityEditViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/idm/EntityServices.jsp";
    private static final String CHILD_TBL_TILED_VIEW = "tableTiledView";
    private static final String TBL_SEARCH = "tblSearch";
    private static final String TBL_BUTTON_ADD = "tblButtonAdd";
    private static final String TBL_BUTTON_DELETE = "tblButtonDelete";
    private static final String TBL_COL_NAME = "tblColName";
    private static final String TBL_DATA_NAME = "tblDataName";
    private static final String TBL_DATA_NAME_EX = "tblDataNameEx";
    static final String TBL_DATA_ACTION_HREF = "tblDataActionHref";
    private CCActionTableModel tblModel = null;

    public EntityServicesViewBean() {
        super("EntityServices", DEFAULT_DISPLAY_URL);
        this.createTableModel();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(TBL_SEARCH, CCActionTable.class);
        this.registerChild(CHILD_TBL_TILED_VIEW, ServicesTiledView.class);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(CHILD_TBL_TILED_VIEW)) {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            this.populateTableModelEx((List)szCache.getSerializedObj());
            view = new ServicesTiledView((View)this, this.tblModel, name);
        } else if (name.equals(TBL_SEARCH)) {
            ServicesTiledView tView = (ServicesTiledView)this.getChild(CHILD_TBL_TILED_VIEW);
            CCActionTable child = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
            child.setTiledView((ContainerView)tView);
            view = child;
        } else {
            view = this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : super.createChild(name);
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.resetButtonState(TBL_BUTTON_DELETE);
        this.getServiceNames();
    }

    protected void disableSaveAndResetButton() {
    }

    protected void setSelectedTab() {
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/oneBtnPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)this.getBackButtonLabel("tab.sub.subjects.label"));
        this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)Integer.toString(1)));
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblEntityServices.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_BUTTON_ADD, (Object)"table.services.button.new");
        this.tblModel.setActionValue(TBL_BUTTON_DELETE, (Object)"table.services.button.delete");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"table.services.name.column.name");
    }

    private void getServiceNames() {
        EntitiesModel model = (EntitiesModel)this.getModel();
        try {
            String universalId = (String)this.getPageSessionAttribute("universalId");
            this.populateTableModel(model.getAssignedServiceNames(universalId));
            if (model.getAssignableServiceNames(universalId).isEmpty()) {
                this.disableButton(TBL_BUTTON_ADD, true);
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.disableButton(TBL_BUTTON_ADD, !model.isServicesSupported());
    }

    private void populateTableModelEx(List serviceNames) {
        if (serviceNames != null && !serviceNames.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>(serviceNames.size() * 2);
            EntitiesModel model = (EntitiesModel)this.getModel();
            for (String serviceName : serviceNames) {
                map.put(serviceName, model.getLocalizedServiceName(serviceName));
            }
            this.populateTableModel(map);
        }
    }

    private void populateTableModel(Map nameToDisplayNames) {
        this.tblModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        if (nameToDisplayNames != null && !nameToDisplayNames.isEmpty()) {
            Map reverseMap = AMFormatUtils.reverseStringMap(nameToDisplayNames);
            EntitiesModel model = (EntitiesModel)this.getModel();
            List list = AMFormatUtils.sortKeyInMap(reverseMap, model.getUserLocale());
            ArrayList<String> cache = new ArrayList<String>(list.size());
            boolean firstEntry = true;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblModel.appendRow();
                }
                String displayName = (String)iter.next();
                String name = (String)reverseMap.get(displayName);
                this.tblModel.setValue(TBL_DATA_NAME_EX, (Object)"");
                this.tblModel.setValue(TBL_DATA_NAME, (Object)displayName);
                this.tblModel.setValue(TBL_DATA_ACTION_HREF, (Object)name);
                cache.add(name);
            }
            szCache.setValue(cache);
        } else {
            szCache.setValue(null);
        }
    }

    public void handleTblButtonAddRequest(RequestInvocationEvent event) {
        ServicesSelectViewBean vb = (ServicesSelectViewBean)this.getViewBean(ServicesSelectViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        block6: {
            CCActionTable table = (CCActionTable)this.getChild(TBL_SEARCH);
            table.restoreStateData();
            Integer[] selected = this.tblModel.getSelectedRows();
            HashSet<String> names = new HashSet<String>(selected.length * 2);
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            List cache = (List)szCache.getSerializedObj();
            if (selected.length > 0) {
                for (int i = 0; i < selected.length; ++i) {
                    names.add((String)cache.get(selected[i]));
                }
                try {
                    EntitiesModel model = (EntitiesModel)this.getModel();
                    String universalId = (String)this.getPageSessionAttribute("universalId");
                    model.unassignServices(universalId, names);
                    if (selected.length == 1) {
                        this.setInlineAlertMessage("info", "message.information", "entities.message.service.unassigned");
                        break block6;
                    }
                    this.setInlineAlertMessage("info", "message.information", "entities.message.service.unassigned.pural");
                }
                catch (AMConsoleException e) {
                    this.setInlineAlertMessage("error", "message.error", e.getMessage());
                }
            } else {
                this.setInlineAlertMessage("error", "message.error", "entities.message.service.unassigned.non.selected");
            }
        }
        this.forwardTo();
    }

    public void handleTblDataActionHrefRequest(String serviceName) throws ModelControlException {
        EntitiesModel model = (EntitiesModel)this.getModel();
        SCUtils utils = new SCUtils(serviceName, model);
        String propertiesViewBeanURL = utils.getServiceDisplayURL();
        String universalId = (String)this.getPageSessionAttribute("universalId");
        if (serviceName.equals("iPlanetAMAuthConfiguration")) {
            propertiesViewBeanURL = null;
        }
        if (propertiesViewBeanURL != null && propertiesViewBeanURL.trim().length() > 0) {
            try {
                String realm = (String)this.getPageSessionAttribute("currentRealm");
                String pageTrailID = (String)this.getPageSessionAttribute("pageTrailID");
                this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)Integer.toString(1)));
                propertiesViewBeanURL = propertiesViewBeanURL + "?ServiceName=" + serviceName + "&User=" + Locale.URLEncodeField(EntityServicesViewBean.stringToHex(universalId), this.getCharset(model)) + "&Op=" + "edit" + "&realm=" + Locale.URLEncodeField(realm, this.getCharset(model)) + "&" + "pageTrailID" + "=" + pageTrailID;
                HttpServletResponse response = this.getRequestContext().getResponse();
                response.sendRedirect(propertiesViewBeanURL);
            }
            catch (UnsupportedEncodingException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
            catch (IOException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
        } else {
            ServicesEditViewBean vb = (ServicesEditViewBean)this.getViewBean(ServicesEditViewBean.class);
            this.setPageSessionAttribute("serviceName", (Serializable)((Object)serviceName));
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
    }

    protected AMPropertySheetModel handleNoAttributeToDisplay(AMConsoleException e) {
        this.hasNoAttributeToDisplay = true;
        return new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertyBlank.xml"));
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        this.removePageSessionAttribute(this.getTrackingTabIDName());
        this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)Integer.toString(0)));
        this.forwardToEntitiesViewBean();
    }
}

