/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.policy.SubjectOpViewBeanBase;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.text.MessageFormat;
import java.util.Set;

public class SubjectEditViewBean
extends SubjectOpViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/SubjectEdit.jsp";
    public static final String EDIT_SUBJECT_NAME = "editSubjectName";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";

    SubjectEditViewBean(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    public SubjectEditViewBean() {
        super("SubjectEdit", DEFAULT_DISPLAY_URL);
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : super.createChild(name);
        return view;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        PolicyModel model = (PolicyModel)this.getModel();
        String i18nName = (String)this.propertySheetModel.getValue("tfSubjectTypeName");
        String title = model.getLocalizedString("page.title.policy.subject.edit");
        String[] param = new String[]{i18nName};
        this.ptModel.setPageTitleText(MessageFormat.format(title, param));
    }

    protected String getPropertyXMLFileName(boolean readonly) {
        return readonly ? "com/sun/identity/console/propertyPMSubjectEdit_Readonly.xml" : "com/sun/identity/console/propertyPMSubjectEdit.xml";
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        try {
            this.handleButton1Request(this.getCachedPolicy());
        }
        catch (AMConsoleException e) {
            debug.warning("SubjectEditViewBean.handleButton1Request", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToPolicyViewBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleButton1Request(CachedPolicy cachedPolicy) throws ModelControlException {
        this.submitCycle = true;
        Subject deleted = null;
        String origName = (String)this.getPageSessionAttribute(EDIT_SUBJECT_NAME);
        Policy policy = cachedPolicy.getPolicy();
        try {
            Subject subject = this.createSubject();
            if (subject != null) {
                String name = (String)this.propertySheetModel.getValue("tfSubjectName");
                if (origName.equals(name)) {
                    policy.replaceSubject(name, subject, this.isExclusive());
                } else {
                    deleted = policy.removeSubject(origName);
                    policy.addSubject(name, subject, this.isExclusive());
                }
                deleted = null;
                this.setInlineAlertMessage("info", "message.information", "policy.subject.updated");
                cachedPolicy.setPolicyModified(true);
            }
        }
        catch (NameAlreadyExistsException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (InvalidNameException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (NameNotFoundException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        finally {
            if (deleted != null) {
                try {
                    policy.addSubject(origName, deleted);
                }
                catch (NameAlreadyExistsException e) {
                    debug.warning("SubjectEditViewBean.handleButton1Request", (Throwable)e);
                }
                catch (InvalidNameException e) {
                    debug.warning("SubjectEditViewBean.handleButton1Request", (Throwable)e);
                }
            }
        }
        this.forwardTo();
    }

    protected Set getDefaultValues() {
        Set values = null;
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            String subjectName = (String)this.getPageSessionAttribute("subjectName");
            Subject subject = policy.getSubject(subjectName);
            values = subject.getValues();
        }
        catch (NameNotFoundException e) {
            debug.warning("SubjectEditViewBean.getDefaultValues", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.warning("SubjectEditViewBean.getDefaultValues", (Throwable)e);
        }
        return values;
    }

    protected boolean isSubjectExclusive() {
        boolean isExclusive = false;
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            String subjectName = (String)this.getPageSessionAttribute("subjectName");
            isExclusive = policy.isSubjectExclusive(subjectName);
        }
        catch (NameNotFoundException e) {
            debug.warning("SubjectEditViewBean.isSubjectExclusive", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.warning("SubjectEditViewBean.isSubjectExclusive", (Throwable)e);
        }
        return isExclusive;
    }

    protected boolean hasValues() {
        return true;
    }

    protected String getBreadCrumbDisplayName() {
        PolicyModel model = (PolicyModel)this.getModel();
        String origName = (String)this.getPageSessionAttribute(EDIT_SUBJECT_NAME);
        String[] arg = new String[]{origName};
        return MessageFormat.format(model.getLocalizedString("breadcrumbs.editSubject"), arg);
    }

    protected boolean startPageTrail() {
        return false;
    }
}

