/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm;

import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.realm.RMRealmViewBean;
import com.sun.identity.console.realm.RMRealmViewBeanBase;
import com.sun.identity.sm.SMSSchema;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.Serializable;
import java.text.MessageFormat;

public abstract class RealmPropertiesBase
extends RMRealmViewBeanBase {
    public CCPageTitleModel ptModel;

    public RealmPropertiesBase(String name) {
        super(name);
    }

    public void nodeClicked(RequestInvocationEvent event, int nodeID) {
        AMViewConfig amconfig = AMViewConfig.getInstance();
        try {
            AMViewBeanBase vb = this.getTabNodeAssociatedViewBean("realms", nodeID);
            String tmp = (String)this.getPageSessionAttribute("previousRealm");
            vb.setPageSessionAttribute("previousRealm", (Serializable)((Object)tmp));
            tmp = (String)this.getPageSessionAttribute("currentRealm");
            vb.setPageSessionAttribute("currentRealm", (Serializable)((Object)tmp));
            tmp = (String)this.getPageSessionAttribute("PreviousTabID");
            vb.setPageSessionAttribute("PreviousTabID", (Serializable)((Object)tmp));
            this.unlockPageTrailForSwapping();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            debug.error("RealmPropertiesBase.nodeClicked", (Throwable)e);
            this.forwardTo();
        }
    }

    protected void createTabModel() {
        if (this.tabModel == null) {
            AMViewConfig amconfig = AMViewConfig.getInstance();
            String realmName = (String)this.getPageSessionAttribute("CurrentProfileView");
            if (realmName != null) {
                this.tabModel = amconfig.getTabsModel("realms", realmName, this.getRequestContext().getRequest());
                this.registerChild("tabCommon", CCTabs.class);
            }
        }
    }

    protected void forwardToRealmView(RequestInvocationEvent event) {
        String tmp = (String)this.getPageSessionAttribute("previousRealm");
        this.setPageSessionAttribute("currentRealm", (Serializable)((Object)tmp));
        tmp = (String)this.getPageSessionAttribute("PreviousTabID");
        this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)tmp));
        RMRealmViewBean vb = (RMRealmViewBean)this.getViewBean(RMRealmViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected void setPageTitle(AMModel model, String title) {
        int index;
        AMModel m;
        String startDN;
        String realm = (String)this.getPageSessionAttribute("currentRealm");
        if (this.isRootRealm(realm, startDN = (m = this.getModel()).getStartDN())) {
            realm = AMFormatUtils.DNToName(m, m.getStartDSDN());
        }
        if ((index = realm.lastIndexOf(47)) != -1) {
            realm = realm.substring(index + 1);
        }
        String[] tmp = new String[]{SMSSchema.unescapeName(realm)};
        this.ptModel.setPageTitleText(MessageFormat.format(model.getLocalizedString(title), tmp));
    }

    protected String getBreadCrumbDisplayName() {
        int idx;
        String realm = (String)this.getPageSessionAttribute("currentRealm");
        AMModel model = this.getModel();
        String path = null;
        if (realm != null && realm.trim().length() > 0 && (idx = realm.lastIndexOf(47)) != -1 && idx < realm.length() - 1) {
            path = realm.substring(idx + 1);
        }
        if (path == null) {
            model.getStartDSDN();
            path = AMFormatUtils.DNToName(model, model.getStartDSDN());
        }
        String[] arg = new String[]{SMSSchema.unescapeName(path)};
        return MessageFormat.format(model.getLocalizedString("breadcrumbs.editRealm"), arg);
    }

    protected boolean startPageTrail() {
        return false;
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToRealmView(event);
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("page.title.back.realms");
    }
}

