/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.service.ServerEditViewBeanBase;
import com.sun.identity.console.service.model.ServerSiteModel;
import com.sun.identity.console.service.model.ServerSiteModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ServerConfigInheritViewBean
extends AMPrimaryMastHeadViewBean {
    private static final String DEFAULT_DISPLAY_URL = "/console/service/ServerConfigInherit.jsp";
    private static final String TBL_PROPERTY_NAMES = "tblPropertyNames";
    private static final String PGTITLE_THREE_BTNS = "pgtitleThreeBtns";
    static final String PG_ATTR_PROPERTY_NAMES = "pgAttrPropertyNames";
    static final String PG_ATTR_CONFIG_PAGE = "pgAttrConfigPage";
    private static final String TBL_COL_PROPERTY_NAME = "tblColPropertyName";
    private static final String TBL_COL_VALUE = "tblColValue";
    private static final String TBL_DATA_PROPERTY_NAME = "tblDataPropertyName";
    private static final String TBL_DATA_VALUE = "tblDataValue";
    private CCActionTableModel tblPropertyNamesModel = null;
    private CCPageTitleModel ptModel;
    private boolean submitCycle;
    private static final String CHILD_STATICTEXT = "StaticText";

    public ServerConfigInheritViewBean() {
        super("ServerConfigInherit");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String serverName;
        if (!this.initialized && (serverName = (String)this.getPageSessionAttribute("pgAttrServerName")) != null) {
            super.initialize();
            this.createPageTitleModel();
            this.createTableModel();
            this.registerChildren();
            this.initialized = true;
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild(TBL_PROPERTY_NAMES, CCActionTable.class);
        this.tblPropertyNamesModel.registerChildren((ContainerViewBase)this);
        this.registerChild(CHILD_STATICTEXT, CCStaticTextField.class);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_PROPERTY_NAMES)) {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            this.populatePropertyNameTableModel((List)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblPropertyNamesModel, name);
        } else {
            view = name.equals(PGTITLE_THREE_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblPropertyNamesModel.isChildSupported(name) ? this.tblPropertyNamesModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(CHILD_STATICTEXT) ? new CCStaticTextField((ContainerView)this, name, null) : super.createChild(name))));
        }
        return view;
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        Set propertyNames = (Set)this.getPageSessionAttribute(PG_ATTR_PROPERTY_NAMES);
        this.populatePropertyNameTableModel(propertyNames);
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = this.getRequestContext().getRequest();
        return new ServerSiteModelImpl(req, this.getPageSessionAttributes());
    }

    private void createTableModel() {
        this.tblPropertyNamesModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblPropertyNames.xml"));
        this.tblPropertyNamesModel.setTitleLabel("label.items");
        this.tblPropertyNamesModel.setActionValue(TBL_COL_PROPERTY_NAME, (Object)"table.inherit.property.name.column.name");
        this.tblPropertyNamesModel.setActionValue(TBL_COL_VALUE, (Object)"table.inherit.property.name.column.value");
    }

    private void populatePropertyNameTableModel(Collection propertyNames) {
        if (!this.submitCycle && propertyNames != null) {
            this.tblPropertyNamesModel.clearAll();
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
            ServerSiteModel model = (ServerSiteModel)this.getModel();
            Map defaultValues = model.getServerDefaults();
            ArrayList<String> cache = new ArrayList<String>();
            try {
                Map serverProperties = model.getServerConfiguration(serverName);
                int counter = 0;
                boolean first = false;
                Iterator iter = propertyNames.iterator();
                while (iter.hasNext()) {
                    if (counter > 0) {
                        this.tblPropertyNamesModel.appendRow();
                    }
                    String name = (String)iter.next();
                    String displayName = name.substring(3);
                    displayName = "amconfig." + displayName.replaceAll("-", ".");
                    String actualPropertyName = ServerEditViewBeanBase.getActualPropertyName(name);
                    this.tblPropertyNamesModel.setValue(TBL_DATA_PROPERTY_NAME, (Object)displayName);
                    this.tblPropertyNamesModel.setValue(TBL_DATA_VALUE, (Object)((String)defaultValues.get(actualPropertyName)));
                    this.tblPropertyNamesModel.setSelectionVisible(counter, true);
                    this.tblPropertyNamesModel.setRowSelected(!serverProperties.containsKey(actualPropertyName));
                    cache.add(name);
                    ++counter;
                }
                szCache.setValue(cache);
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        CCActionTable table = (CCActionTable)this.getChild(TBL_PROPERTY_NAMES);
        table.restoreStateData();
        Integer[] selected = this.tblPropertyNamesModel.getSelectedRows();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        List list = (List)szCache.getSerializedObj();
        HashSet<String> toInherit = new HashSet<String>(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            String name = (String)list.get(selected[i]);
            toInherit.add(ServerEditViewBeanBase.getActualPropertyName(name));
        }
        HashSet<String> notToInherit = new HashSet<String>(list.size() * 2);
        for (String name : list) {
            notToInherit.add(ServerEditViewBeanBase.getActualPropertyName(name));
        }
        notToInherit.removeAll(toInherit);
        try {
            ServerSiteModel model = (ServerSiteModel)this.getModel();
            String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
            model.updateServerConfigInheritance(serverName, toInherit, notToInherit);
            this.setInlineAlertMessage("info", "message.information", "servercfg.inheritance.updated");
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton3Request(RequestInvocationEvent event) throws ModelControlException {
        try {
            AMViewBeanBase vb = (AMViewBeanBase)this.getViewBean(Class.forName((String)this.getPageSessionAttribute(PG_ATTR_CONFIG_PAGE)));
            this.removePageSessionAttribute(PG_ATTR_CONFIG_PAGE);
            this.removePageSessionAttribute(PG_ATTR_PROPERTY_NAMES);
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (ClassNotFoundException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("page.title.server.config");
    }
}

