/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ConditionDecision;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeCondition
implements EntitlementCondition {
    public static final String REQUEST_TIME = "requestTime";
    public static final String REQUEST_TIME_ZONE = "requestTimeZone";
    private static final String DATE_FORMAT = "yyyy:MM:dd";
    private static final String[] DAYS_OF_WEEK = new String[]{"", "sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    private String startTime;
    private String endTime;
    private String startDay;
    private String endDay;
    private String startDate;
    private String endDate;
    private String enforcementTimeZone;
    private String pConditionName;

    public TimeCondition() {
    }

    public TimeCondition(String startTime, String endTime, String startDay, String endDay) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.startDay = startDay;
        this.endDay = endDay;
    }

    @Override
    public String getState() {
        return this.toString();
    }

    @Override
    public void setState(String state) {
        try {
            JSONObject jo = new JSONObject(state);
            this.startTime = jo.optString("startTime");
            this.endTime = jo.optString("endTime");
            this.startDay = jo.optString("startDay");
            this.endDay = jo.optString("endDay");
            this.startDate = jo.optString("startDate");
            this.endDate = jo.optString("endDate");
            this.pConditionName = jo.optString("pConditionName");
            this.enforcementTimeZone = jo.optString("enforcementTimeZone");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public ConditionDecision evaluate(String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        boolean allowed = false;
        long currentGmt = System.currentTimeMillis();
        TimeZone timeZone = TimeZone.getDefault();
        if (environment != null) {
            String tZone;
            String time = TimeCondition.getProperty(environment, REQUEST_TIME);
            if (time != null) {
                try {
                    currentGmt = Long.parseLong(time);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((tZone = TimeCondition.getProperty(environment, REQUEST_TIME_ZONE)) != null) {
                timeZone = TimeZone.getTimeZone(this.enforcementTimeZone);
            }
        }
        long[] effectiveRange = this.getEffectiveRange(currentGmt, timeZone);
        long timeToLive = Long.MAX_VALUE;
        if (currentGmt >= effectiveRange[0] && currentGmt <= effectiveRange[1]) {
            allowed = true;
            timeToLive = effectiveRange[1];
        } else if (currentGmt < effectiveRange[0]) {
            timeToLive = effectiveRange[0];
        }
        String sTimeToLove = Long.toString(timeToLive);
        HashSet<String> setAdvice = new HashSet<String>();
        setAdvice.add(sTimeToLove);
        HashMap<String, Set<String>> advices = new HashMap<String, Set<String>>();
        advices.put("timeToLive", setAdvice);
        return new ConditionDecision(allowed, advices);
    }

    private static String getProperty(Map<String, Set<String>> environment, String name) {
        Set<String> set = environment.get(name);
        return set != null && !set.isEmpty() ? set.iterator().next() : null;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getStartDay() {
        return this.startDay;
    }

    public void setStartDay(String startDay) {
        this.startDay = startDay;
    }

    public String getEndDay() {
        return this.endDay;
    }

    public void setEndDay(String endDay) {
        this.endDay = endDay;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getEnforcementTimeZone() {
        return this.enforcementTimeZone;
    }

    public void setEnforcementTimeZone(String enforcementTimeZone) {
        this.enforcementTimeZone = enforcementTimeZone;
    }

    public String getPConditionName() {
        return this.pConditionName;
    }

    public void setPConditionName(String pConditionName) {
        this.pConditionName = pConditionName;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("startTime", (Object)this.startTime);
        jo.put("endTime", (Object)this.endTime);
        jo.put("startDay", (Object)this.startDay);
        jo.put("endDay", (Object)this.endDay);
        jo.put("startDate", (Object)this.startDate);
        jo.put("endDate", (Object)this.endDate);
        jo.put("enforcementTimeZone", (Object)this.enforcementTimeZone);
        jo.put("pConditionName", (Object)this.pConditionName);
        return jo;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        TimeCondition object = (TimeCondition)obj;
        if (this.startDay == null ? object.getStartDay() != null : !this.startDay.equals(object.getStartDay())) {
            return false;
        }
        if (this.getEndDay() == null ? object.getEndDay() != null : !this.endDay.equals(object.getEndDay())) {
            return false;
        }
        if (this.startDate == null ? object.getStartDate() != null : !this.startDate.equals(object.getStartDate())) {
            return false;
        }
        if (this.getEndDate() == null ? object.getEndDate() != null : !this.endDate.equals(object.getEndDate())) {
            return false;
        }
        if (this.getEnforcementTimeZone() == null ? object.getEnforcementTimeZone() != null : !this.enforcementTimeZone.equals(object.getEnforcementTimeZone())) {
            return false;
        }
        return !(this.getPConditionName() == null ? object.getPConditionName() != null : !this.pConditionName.equals(object.getPConditionName()));
    }

    public int hashCode() {
        int code = 0;
        if (this.startTime != null) {
            code += this.startTime.hashCode();
        }
        if (this.startDate != null) {
            code += this.startDate.hashCode();
        }
        if (this.startDay != null) {
            code += this.startDay.hashCode();
        }
        if (this.endTime != null) {
            code += this.endTime.hashCode();
        }
        if (this.endDate != null) {
            code += this.endDate.hashCode();
        }
        if (this.endDay != null) {
            code += this.endDay.hashCode();
        }
        if (this.enforcementTimeZone != null) {
            code += this.enforcementTimeZone.hashCode();
        }
        if (this.pConditionName != null) {
            code += this.pConditionName.hashCode();
        }
        return code;
    }

    public String toString() {
        String s = null;
        try {
            s = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("TimeCondition.toString()", (Throwable)e);
        }
        return s;
    }

    private long[] getEffectiveRange(long currentGmt, TimeZone timeZone) throws EntitlementException {
        long rangeEnd;
        long rangeStart;
        int endHour;
        int startHour;
        long[] effectiveRange = new long[2];
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTime(new Date(currentGmt));
        long timeStart = Long.MIN_VALUE;
        int startT = TimeCondition.parseTimeString(this.startTime);
        int n = startHour = startT != -1 ? startT / 60 : -1;
        if (startHour != -1) {
            int startMinute = startT - startHour * 60;
            calendar.set(11, startHour);
            calendar.set(12, startMinute);
            calendar.set(13, 0);
            calendar.set(14, 0);
            timeStart = calendar.getTime().getTime();
        }
        long timeEnd = Long.MAX_VALUE;
        int endT = TimeCondition.parseTimeString(this.endTime);
        int n2 = endHour = endT != -1 ? endT / 60 : -1;
        if (endHour != -1) {
            int endMinute = endT - endHour * 60;
            calendar.set(11, endHour);
            calendar.set(12, endMinute);
            calendar.set(13, 0);
            calendar.set(14, 0);
            timeEnd = calendar.getTime().getTime();
        }
        if (timeEnd < timeStart) {
            GregorianCalendar cal = new GregorianCalendar(timeZone);
            if (currentGmt < timeStart) {
                cal.setTime(new Date(timeStart));
                ((Calendar)cal).roll(6, false);
                timeStart = cal.getTime().getTime();
            } else {
                cal.setTime(new Date(timeEnd));
                ((Calendar)cal).roll(6, true);
                timeEnd = cal.getTime().getTime();
            }
        }
        long dayStart = Long.MIN_VALUE;
        calendar.setTime(new Date(currentGmt));
        int startD = TimeCondition.parseDayString(this.startDay);
        if (startD != -1) {
            calendar.set(7, startD);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dayStart = calendar.getTime().getTime();
        }
        long dayEnd = Long.MAX_VALUE;
        int endD = TimeCondition.parseDayString(this.endDay);
        if (endD != -1) {
            calendar.set(7, endD);
            calendar.set(11, 24);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dayEnd = calendar.getTime().getTime();
        }
        if (dayEnd <= dayStart) {
            GregorianCalendar cal = new GregorianCalendar(timeZone);
            if (currentGmt < dayStart) {
                cal.setTime(new Date(dayStart));
                ((Calendar)cal).roll(3, false);
                dayStart = cal.getTime().getTime();
            } else {
                cal.setTime(new Date(dayEnd));
                ((Calendar)cal).roll(3, true);
                dayEnd = cal.getTime().getTime();
            }
        }
        long dateStart = Long.MIN_VALUE;
        DateArray dateArray = this.validateDates(this.startDate, this.endDate);
        if (dateArray.startDateArray[0] != -1) {
            calendar.set(1, dateArray.startDateArray[0]);
            calendar.set(2, dateArray.startDateArray[1]);
            calendar.set(5, dateArray.startDateArray[2]);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dateStart = calendar.getTime().getTime();
        }
        long dateEnd = Long.MAX_VALUE;
        if (dateArray.endDateArray[0] != -1) {
            calendar.set(1, dateArray.endDateArray[0]);
            calendar.set(2, dateArray.endDateArray[1]);
            calendar.set(5, dateArray.endDateArray[2]);
            calendar.set(11, 24);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dateEnd = calendar.getTime().getTime();
        }
        if (timeStart > (rangeStart = Long.MIN_VALUE)) {
            rangeStart = timeStart;
        }
        if (dayStart > rangeStart) {
            rangeStart = dayStart;
        }
        if (dateStart > rangeStart) {
            rangeStart = dateStart;
        }
        if (timeEnd < (rangeEnd = Long.MAX_VALUE)) {
            rangeEnd = timeEnd;
        }
        if (dayEnd < rangeEnd) {
            rangeEnd = dayEnd;
        }
        if (dateEnd < rangeEnd) {
            rangeEnd = dateEnd;
        }
        effectiveRange[0] = rangeStart;
        effectiveRange[1] = rangeEnd;
        return effectiveRange;
    }

    private static int parseTimeString(String timeString) throws EntitlementException {
        if (timeString == null || timeString.length() == 0) {
            return -1;
        }
        StringTokenizer st = new StringTokenizer(timeString, ":");
        if (st.countTokens() != 2) {
            Object[] args = new String[]{"time", timeString};
            throw new EntitlementException(400, args);
        }
        String token1 = st.nextToken();
        String token2 = st.nextToken();
        int hour = -1;
        int minute = -1;
        try {
            hour = Integer.parseInt(token1);
            minute = Integer.parseInt(token2);
        }
        catch (Exception e) {
            Object[] args = new String[]{"time", timeString};
            throw new EntitlementException(400, args);
        }
        if (hour < 0 || hour > 24 || minute < 0 || minute > 59) {
            Object[] args = new String[]{"time", timeString};
            throw new EntitlementException(400, args);
        }
        return hour * 60 + minute;
    }

    private static int parseDayString(String dayString) {
        int day = -1;
        if (dayString != null && dayString.length() > 0) {
            String dayStringLc = dayString.toLowerCase();
            for (int i = 1; i < 8; ++i) {
                if (!DAYS_OF_WEEK[i].equals(dayStringLc)) continue;
                day = i;
                break;
            }
        }
        return day;
    }

    private DateArray validateDates(String startDate, String endDate) throws EntitlementException {
        DateArray dateArray = new DateArray();
        if (startDate != null && startDate.length() > 0 && endDate != null && endDate.length() > 0) {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            df.setLenient(false);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date date1 = null;
            Date date2 = null;
            try {
                date1 = df.parse(startDate);
            }
            catch (Exception e) {
                Object[] args = new String[]{startDate};
                throw new EntitlementException(401, args, e);
            }
            try {
                date2 = df.parse(endDate);
            }
            catch (Exception e) {
                Object[] args = new String[]{endDate};
                throw new EntitlementException(401, args, e);
            }
            if (date1.getTime() > date2.getTime()) {
                Object[] args = new String[]{startDate, endDate};
                throw new EntitlementException(402, args);
            }
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            cal.setTime(date1);
            dateArray.startDateArray[0] = cal.get(1);
            dateArray.startDateArray[1] = cal.get(2);
            dateArray.startDateArray[2] = cal.get(5);
            cal.setTime(date2);
            dateArray.endDateArray[0] = cal.get(1);
            dateArray.endDateArray[1] = cal.get(2);
            dateArray.endDateArray[2] = cal.get(5);
        }
        return dateArray;
    }

    class DateArray {
        int[] startDateArray = new int[]{-1, 0, 0};
        int[] endDateArray = new int[]{-1, 0, 0};

        DateArray() {
        }
    }
}

