/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.DNUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AuthenticatedAgents
implements Subject {
    private static ValidValues validValues = new ValidValues(0, Collections.EMPTY_SET);
    private static String specialUser = SystemProperties.get("com.sun.identity.authentication.special.users", "");
    static Debug debug = Debug.getInstance((String)"AuthAgents");

    public void AuthenticatedAgents() {
    }

    public void initialize(Map configParams) {
    }

    public Syntax getValueSyntax(SSOToken token) {
        return Syntax.CONSTANT;
    }

    public ValidValues getValidValues(SSOToken token) {
        return validValues;
    }

    public ValidValues getValidValues(SSOToken token, String pattern) {
        return validValues;
    }

    public String getDisplayNameForValue(String value, Locale locale) {
        return value;
    }

    public Set getValues() {
        return Collections.EMPTY_SET;
    }

    public void setValues(Set names) {
    }

    public boolean isMember(SSOToken token) throws SSOException {
        if (token == null) {
            return false;
        }
        if (!SSOTokenManager.getInstance().isValidToken(token)) {
            return false;
        }
        try {
            AMIdentity amId = IdUtils.getIdentity(token);
            IdType idType = amId.getType();
            if (debug.messageEnabled()) {
                debug.message("AuthenticatedAgents:isMember:idType = " + idType + ", amId.getName() = " + amId.getName());
            }
            if (!idType.equals(IdType.AGENT)) {
                return this.isSpecialUser(token.getPrincipal().getName());
            }
        }
        catch (IdRepoException ire) {
            debug.error("AuthenticatedAgents:isMember:IdRepoException:msg = " + ire.getMessage());
            return false;
        }
        return true;
    }

    public Object clone() {
        AuthenticatedAgents theClone = null;
        try {
            theClone = (AuthenticatedAgents)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return theClone;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean isSpecialUser(String dn) {
        boolean isSpecialUser = false;
        StringTokenizer st = new StringTokenizer(specialUser, "|");
        if (debug.messageEnabled()) {
            debug.message("AuthAgents:isSpecial:dn = " + dn);
        }
        if (dn != null && specialUser != null) {
            String lcdn = DNUtils.normalizeDN(dn);
            while (st.hasMoreTokens()) {
                String specialAdminDN = st.nextToken();
                if (specialAdminDN == null) continue;
                String normSpecialAdmin = DNUtils.normalizeDN(specialAdminDN);
                if (debug.messageEnabled()) {
                    debug.message("AuthAgents:isSpecial:compare to " + normSpecialAdmin);
                }
                if (!lcdn.equals(normSpecialAdmin)) continue;
                isSpecialUser = true;
                break;
            }
        }
        return isSpecialUser;
    }
}

