/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.protocol;

import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.keystore.AMX509KeyManager;
import com.sun.identity.security.keystore.AMX509KeyManagerFactory;
import com.sun.identity.security.keystore.AMX509TrustManager;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLSocketFactoryManager {
    private static String keyStore = null;
    private static AMX509KeyManager amKeyMgr = null;
    private static KeyManager[] keyMgr = null;
    private static TrustManager[] amTrustMgr = null;
    private static SSLContext ctx = null;

    public static SSLSocketFactory getSocketFactory() {
        SSLSocketFactory sf = null;
        if (ctx != null) {
            sf = ctx.getSocketFactory();
        }
        return sf;
    }

    public static AMX509KeyManager getKeyStoreMgr() {
        return amKeyMgr;
    }

    static {
        keyStore = System.getProperty("javax.net.ssl.keyStore", null);
        try {
            if (keyStore != null) {
                amKeyMgr = AMX509KeyManagerFactory.createAMX509KeyManager();
                keyMgr = new KeyManager[]{amKeyMgr};
            }
            amTrustMgr = new TrustManager[]{new AMX509TrustManager()};
            ctx = SSLContext.getInstance("SSL");
            ctx.init(keyMgr, amTrustMgr, null);
        }
        catch (Exception e) {
            SecurityDebug.debug.error("Exception in SSLSocketFactoryManager.init()" + e.toString());
        }
    }
}

