/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.sdk.AMException;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.event.EventException;
import com.iplanet.services.util.XMLException;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.L10NMessage;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.SMSEntry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class SMSException
extends Exception
implements L10NMessage {
    transient AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    transient Debug debug = Debug.getInstance((String)"amSDK");
    private int exceptionStatus = STATUS_NONE;
    private Throwable rootCause;
    private String message;
    private String bundleName = "amSDK";
    private String errorCode;
    private Object[] args;
    public static int STATUS_NONE = -1;
    public static int STATUS_RETRY = 0;
    public static int STATUS_REPEATEDLY_FAILED = 0;
    public static int STATUS_ABORT = 1;
    public static int STATUS_QUO_ANTE = 2;
    public static int STATUS_LDAP_OP_FAILED = 3;
    public static int STATUS_CONFIG_PROBLEM = 4;
    public static int STATUS_UNKNOWN_EXCEPTION = 5;
    public static int STATUS_NO_PERMISSION = 8;
    public static int STATUS_NOT_ALLOW = 9;

    public SMSException() {
        this.exceptionStatus = STATUS_NONE;
    }

    public SMSException(int status, String errorCode) {
        this.exceptionStatus = status;
        this.errorCode = errorCode;
        this.message = this.getL10NMessage(java.util.Locale.ENGLISH);
    }

    public SMSException(int status, String exMessage, String errorCode) {
        this.exceptionStatus = status;
        this.errorCode = errorCode;
        this.message = exMessage + ": " + this.getL10NMessage(java.util.Locale.ENGLISH);
    }

    public SMSException(String msg) {
        this.exceptionStatus = STATUS_NONE;
        this.message = msg;
    }

    public SMSException(String msg, String errorCode) {
        this.exceptionStatus = STATUS_NONE;
        this.errorCode = errorCode;
        this.message = msg + ": " + this.getL10NMessage(java.util.Locale.ENGLISH);
    }

    public SMSException(Throwable t, String errorCode) {
        this.rootCause = t;
        this.errorCode = errorCode;
        this.message = this.getL10NMessage(java.util.Locale.ENGLISH);
        this.exceptionMapper();
    }

    public SMSException(String message, Throwable t, String errorCode) {
        this.rootCause = t;
        this.errorCode = errorCode;
        this.message = message + ": " + this.getL10NMessage(java.util.Locale.ENGLISH);
        this.exceptionMapper();
    }

    public SMSException(String rbName, String message, Throwable t, String errorCode) {
        this.rootCause = t;
        this.errorCode = errorCode;
        this.bundleName = rbName;
        this.message = message + ": " + this.getL10NMessage(java.util.Locale.ENGLISH);
        if (this.rootCause != null && !(this.rootCause instanceof AMException)) {
            this.exceptionMapper();
        }
    }

    public SMSException(String rbName, String errorCode, Object[] args) {
        this.exceptionStatus = STATUS_NONE;
        this.bundleName = rbName;
        this.errorCode = errorCode;
        this.args = args;
        this.message = this.getL10NMessage(java.util.Locale.ENGLISH);
    }

    public String getL10NMessage(java.util.Locale locale) {
        String result = this.errorCode;
        if (this.bundleName != null && locale != null) {
            ResourceBundle bundle = this.amCache.getResBundle(this.bundleName, locale);
            String mid = Locale.getString((ResourceBundle)bundle, (String)this.errorCode, (Debug)this.debug);
            result = this.args == null || this.args.length == 0 ? mid : MessageFormat.format(mid, this.args);
        }
        return result;
    }

    public String getResourceBundleName() {
        return this.bundleName;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public int getExceptionCode() {
        return this.exceptionStatus;
    }

    void setExceptionCode(int status) {
        this.exceptionStatus = status;
    }

    public String toString() {
        String msg;
        StringBuffer buf = new StringBuffer();
        if (this.exceptionStatus != -1) {
            buf.append("SMSException Exception Code:");
            buf.append(this.exceptionStatus);
            buf.append('\n');
        }
        if ((msg = this.message) != null && msg.length() > 0) {
            buf.append("Message:");
            buf.append(msg);
            buf.append("\n");
        }
        if (this.rootCause != null) {
            buf.append("--------------------------------------------------\n");
            buf.append("The lower level exception message\n");
            buf.append(this.rootCause.getMessage());
            buf.append('\n');
            buf.append("The lower level exception:\n");
            StringWriter sw = new StringWriter(100);
            this.rootCause.printStackTrace(new PrintWriter(sw));
            buf.append(sw.toString());
            buf.append('\n');
        }
        return buf.toString();
    }

    public String getMessage() {
        return this.message;
    }

    private String getString(String msgID) {
        this.errorCode = msgID;
        ResourceBundle bundle = null;
        if (this.bundleName != null) {
            bundle = this.amCache.getResBundle(this.bundleName, java.util.Locale.ENGLISH);
        }
        return Locale.getString(bundle, (String)msgID, (Debug)this.debug);
    }

    private void exceptionMapper() {
        if (this.rootCause == null) {
            return;
        }
        if (this.rootCause instanceof LDAPException) {
            this.message = this.mapLDAPException();
        } else if (!(this.rootCause instanceof LDAPServiceException)) {
            if (this.rootCause instanceof EventException) {
                this.exceptionStatus = STATUS_ABORT;
                this.message = this.getString("sms-EVENT_NOTIFICATION_FAILED");
            } else if (this.rootCause instanceof XMLException) {
                this.exceptionStatus = STATUS_ABORT;
                this.message = this.getString("sms-XML_PARSER_EXCEPTION");
            } else if (this.rootCause instanceof InvalidAuthContextException) {
                this.message = this.getString("sms-AUTHENTICATION_ERROR");
                this.exceptionStatus = STATUS_ABORT;
            } else if (this.rootCause instanceof SSOException) {
                this.message = this.getString("sms-AUTHENTICATION_ERROR");
                this.exceptionStatus = STATUS_ABORT;
            } else {
                this.message = this.getString("sms-UNKNOWN_EXCEPTION_OCCURED");
                this.exceptionStatus = STATUS_UNKNOWN_EXCEPTION;
            }
        }
    }

    private String mapLDAPException() {
        int resultCode = ((LDAPException)this.rootCause).getLDAPResultCode();
        String message = null;
        switch (resultCode) {
            case 80: 
            case 81: {
                message = this.getString("sms-SERVER_DOWN");
                this.exceptionStatus = STATUS_RETRY;
                break;
            }
            case 92: {
                message = this.getString("sms-LDAP_NOT_SUPPORTED");
                this.exceptionStatus = STATUS_ABORT;
                break;
            }
            case 51: {
                message = this.getString("sms-LDAP_SERVER_BUSY");
                this.exceptionStatus = STATUS_RETRY;
                break;
            }
            case 49: {
                message = this.getString("INVALID_CREDENTIALS");
                this.exceptionStatus = STATUS_CONFIG_PROBLEM;
                break;
            }
            case 32: {
                message = this.getString("sms-NO_SUCH_OBJECT");
                this.exceptionStatus = STATUS_LDAP_OP_FAILED;
                break;
            }
            case 50: {
                message = this.getString("sms-INSUFFICIENT_ACCESS_RIGHTS");
                this.exceptionStatus = STATUS_NO_PERMISSION;
                break;
            }
            case 11: {
                message = this.getString("sms-ADMIN_LIMIT_EXCEEDED");
                this.exceptionStatus = STATUS_ABORT;
                break;
            }
            case 3: {
                message = this.getString("sms-TIME_LIMIT_EXCEEDED");
                this.exceptionStatus = STATUS_ABORT;
                break;
            }
            case 10: {
                message = this.getString("sms-LDAP_REFERRAL_EXCEPTION");
                this.exceptionStatus = STATUS_CONFIG_PROBLEM;
                break;
            }
            case 2: 
            case 17: 
            case 19: 
            case 20: 
            case 34: 
            case 64: 
            case 65: 
            case 68: {
                SMSEntry.debug.error(this.rootCause.toString());
                message = this.getString("sms-LDAP_OPERATION_FAILED");
                this.exceptionStatus = STATUS_LDAP_OP_FAILED;
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                this.exceptionStatus = STATUS_QUO_ANTE;
                break;
            }
            default: {
                message = this.getString("sms-UNEXPECTED_LDAP_EXCEPTION");
                this.exceptionStatus = STATUS_UNKNOWN_EXCEPTION;
            }
        }
        return message;
    }
}

