/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.flatfile;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.flatfile.FlatFileEventManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class FileObserver
extends Thread {
    private static Debug debug = Debug.getInstance((String)"amSMSEvent");
    private Map snapShot;
    private int interval;
    private boolean running;
    private FlatFileEventManager eventManager;

    FileObserver(FlatFileEventManager eventManager) {
        this.setDaemon(true);
        this.getPollingInterval();
        this.eventManager = eventManager;
    }

    private void getPollingInterval() {
        String time = SystemProperties.get("com.sun.identity.sm.cacheTime");
        this.interval = 1;
        if (time != null) {
            try {
                this.interval = Integer.parseInt(time);
            }
            catch (NumberFormatException nfe) {
                debug.error("FileObserver.getCachePollingInterval", (Throwable)nfe);
            }
        }
        this.interval = this.interval * 60 * 1000;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stopThread() {
        this.running = false;
    }

    public void run() {
        this.running = true;
        this.snapShot = this.getCurrentSnapShot();
        try {
            while (this.running) {
                boolean needReloadRootNode = false;
                FileObserver.sleep(this.interval);
                Map newSnapShot = this.getCurrentSnapShot();
                if (this.snapShot != null) {
                    for (String filename : newSnapShot.keySet()) {
                        if (this.snapShot.containsKey(filename)) {
                            long curr;
                            long prev = (Long)this.snapShot.get(filename);
                            if (prev == (curr = ((Long)newSnapShot.get(filename)).longValue())) continue;
                            this.eventManager.notify(this.getDN(filename), 3);
                            continue;
                        }
                        if (!needReloadRootNode) {
                            this.eventManager.reloadRootNode();
                            needReloadRootNode = true;
                        }
                        this.eventManager.notify(this.getDN(filename), 0);
                    }
                    for (String filename : this.snapShot.keySet()) {
                        if (newSnapShot.containsKey(filename)) continue;
                        if (!needReloadRootNode) {
                            this.eventManager.reloadRootNode();
                            needReloadRootNode = true;
                        }
                        this.eventManager.notify(this.getDN(filename), 1);
                    }
                }
                this.snapShot = newSnapShot;
            }
        }
        catch (InterruptedException e) {
            debug.warning("FileObserver.run", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDN(String filename) {
        BufferedReader buff = null;
        String dn = null;
        try {
            buff = new BufferedReader(new FileReader(filename));
            String line = buff.readLine();
            if (line != null && line.startsWith("#")) {
                dn = line.substring(1);
            }
        }
        catch (IOException e) {
            debug.warning("FileObserver.getDN", (Throwable)e);
        }
        finally {
            if (buff != null) {
                try {
                    buff.close();
                }
                catch (IOException ex) {}
            }
        }
        return dn;
    }

    private Map getCurrentSnapShot() {
        HashMap<String, Long> snapshot = null;
        String baseDir = SystemProperties.get("com.sun.identity.sm.flatfile.root_dir");
        File dir = new File(baseDir);
        String[] files = dir.list();
        if (files.length > 0) {
            snapshot = new HashMap<String, Long>(files.length * 2);
            for (int i = 0; i < files.length; ++i) {
                String filename = baseDir + "/" + files[i];
                File f = new File(filename);
                if (f.isDirectory()) continue;
                snapshot.put(filename, new Long(f.lastModified()));
            }
        }
        return snapshot;
    }
}

