/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.constants.AMTuneConstants;
import com.sun.identity.tune.impl.TuneAS9Container;
import com.sun.identity.tune.impl.TuneDS5Impl;
import com.sun.identity.tune.impl.TuneDS6Impl;
import com.sun.identity.tune.impl.TuneFAM8Impl;
import com.sun.identity.tune.impl.TuneLinuxOS;
import com.sun.identity.tune.impl.TuneSolarisOS;
import com.sun.identity.tune.impl.TuneWS7Container;
import com.sun.identity.tune.intr.Tuning;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class AMTune {
    static AMTuneLogger pLogger = null;
    static MessageWriter mWriter = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        AMTuneConfigInfo confInfo = null;
        try {
            String confFilePath = "amtune-env";
            String passFilePath = null;
            pLogger = AMTuneLogger.getLoggerInst();
            mWriter = MessageWriter.getInstance();
            AMTuneLogger.setLogLevel("FINEST");
            if (args.length == 1) {
                File passFile = new File(args[0]);
                if (passFile.exists()) {
                    AMTuneUtil.validatePwdFilePermissions(args[0]);
                    passFilePath = args[0];
                } else if (args[0].indexOf("debug") != -1) {
                    AMTuneLogger.setLogLevel(AMTuneUtil.getLastToken(args[0], "="));
                } else if (args[0].indexOf("--help") != -1 || args[0].indexOf("-?") != -1) {
                    mWriter.writelnLocaleMsg("pt-usage");
                    System.exit(0);
                } else {
                    mWriter.writelnLocaleMsg("pt-usage");
                    System.exit(0);
                }
            }
            if (args.length == 2 && args[1].indexOf("debug") != -1) {
                AMTuneLogger.setLogLevel(AMTuneUtil.getLastToken(args[1], "="));
            }
            mWriter.writeln("=====================================================================");
            mWriter.writeln("Error log file : " + pLogger.getLogFilePath());
            mWriter.writeln("Configuration information file : " + mWriter.getConfigurationFilePath());
            mWriter.writeln("=====================================================================");
            AMTuneUtil.initializeUtil();
            confInfo = new AMTuneConfigInfo(confFilePath, passFilePath);
            List tunerList = AMTune.getTuners(confInfo);
            for (Tuning compTuner : tunerList) {
                compTuner.initialize(confInfo);
                compTuner.startTuning();
            }
        }
        catch (Exception ex) {
            if (pLogger != null) {
                pLogger.log(Level.SEVERE, "main", ex.getMessage());
                pLogger.logException("main", ex);
            } else {
                ex.printStackTrace();
            }
            if (mWriter != null) {
                mWriter.writeln(" ");
                mWriter.writeLocaleMsg("pt-error-tuning-msg");
                mWriter.writeln(ex.getMessage());
            } else {
                System.out.println("Error occured while tuning: " + ex.getMessage());
            }
        }
        finally {
            if (pLogger != null) {
                pLogger.close();
            }
            if (mWriter != null) {
                mWriter.close();
            }
        }
    }

    private static List getTuners(AMTuneConfigInfo confInfo) throws AMTuneException {
        ArrayList<AMTuneConstants> tunerList = new ArrayList<AMTuneConstants>();
        if (confInfo.isTuneOS()) {
            if (AMTuneUtil.isSunOs()) {
                tunerList.add(new TuneSolarisOS());
            } else if (AMTuneUtil.isLinux()) {
                tunerList.add(new TuneLinuxOS());
            } else {
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unsupported-os-tuning"));
            }
        }
        if (confInfo.isTuneDS()) {
            if (confInfo.getDSConfigInfo().isRemoteDS()) {
                AMTuneUtil.createRemoteDSTuningZipFile(confInfo);
            } else {
                String dsVersion = confInfo.getDSConfigInfo().getDsVersion();
                if (AMTuneUtil.isSupportedUMDSVersion(dsVersion)) {
                    if (dsVersion.indexOf("5.") != -1) {
                        tunerList.add(new TuneDS5Impl());
                    } else if (dsVersion.indexOf("6.") != -1) {
                        tunerList.add(new TuneDS6Impl());
                    }
                } else {
                    throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-ds-unsupported-msg"));
                }
            }
        }
        if (confInfo.isTuneWebContainer()) {
            if (confInfo.getWebContainer().equalsIgnoreCase("WS7")) {
                tunerList.add(new TuneWS7Container());
            } else if (confInfo.getWebContainer().equalsIgnoreCase("AS91")) {
                tunerList.add(new TuneAS9Container());
            } else {
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-unsupported-wc-tuning"));
            }
        }
        if (confInfo.isTuneFAM()) {
            tunerList.add(new TuneFAM8Impl());
        }
        return tunerList;
    }
}

