/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMObjectClassManager;
import com.iplanet.services.ldap.event.DSEvent;
import java.util.EventObject;

public class AMEvent
extends EventObject {
    private static final long serialVersionUID = 6448554078141700417L;
    public static final int OBJECT_ADDED = 1;
    public static final int OBJECT_CHANGED = 4;
    public static final int OBJECT_REMOVED = 2;
    public static final int OBJECT_EXPIRED = 9;
    public static final int OBJECT_RENAMED = 8;
    private int eventType;
    private String sourceDN;
    private int sourceType;

    public AMEvent(Object source, int eventType) {
        super(source);
        if (source instanceof DSEvent) {
            DSEvent dsEvent = (DSEvent)source;
            this.sourceDN = dsEvent.getID();
            this.sourceType = this.determineSourceType(dsEvent);
        } else if (source instanceof AMEvent) {
            this.sourceDN = ((AMEvent)source).getSourceDN();
            this.sourceType = -1;
        } else {
            this.sourceDN = null;
            this.sourceType = -1;
        }
        this.eventType = eventType;
    }

    protected AMEvent(Object source, int eventType, String sourceDN, int sourceType) {
        super(source);
        this.eventType = eventType;
        this.sourceDN = sourceDN;
        this.sourceType = sourceType;
    }

    protected AMEvent(String dn) {
        super(new String(""));
        this.eventType = 4;
        this.sourceDN = dn;
    }

    public String getSourceDN() {
        return this.sourceDN;
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    private int determineSourceType(DSEvent source) {
        if (source == null) {
            return -1;
        }
        String objectClasses = source.getClassName().toLowerCase();
        if (objectClasses.indexOf(AMObjectClassManager.getObjectClass(1)) != -1) {
            return 1;
        }
        if (objectClasses.indexOf(AMObjectClassManager.getObjectClass(6)) != -1) {
            return 6;
        }
        if (objectClasses.indexOf(AMObjectClassManager.getObjectClass(8)) != -1) {
            return 8;
        }
        if (objectClasses.indexOf(AMObjectClassManager.getObjectClass(2)) != -1) {
            return 2;
        }
        if (objectClasses.indexOf(AMObjectClassManager.getObjectClass(9)) != -1) {
            return 9;
        }
        if (objectClasses.indexOf(AMObjectClassManager.getObjectClass(12)) != -1) {
            return 12;
        }
        if (objectClasses.indexOf(AMObjectClassManager.getObjectClass(11)) != -1) {
            return 11;
        }
        if (objectClasses.indexOf(AMObjectClassManager.getObjectClass(5)) != -1) {
            return 5;
        }
        if (objectClasses.indexOf(AMObjectClassManager.getObjectClass(4)) != -1) {
            return 4;
        }
        if (objectClasses.indexOf(AMObjectClassManager.getObjectClass(3)) != -1) {
            return 3;
        }
        if (objectClasses.indexOf(AMObjectClassManager.getObjectClass(21)) != -1) {
            return 21;
        }
        return -1;
    }
}

