/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.util.Cache;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.util.DN;
import java.util.HashMap;
import java.util.Map;

public class AMSearchFilterManager {
    private static Debug debug = AMCommonUtils.debug;
    public static Map searchtemplateMap = new HashMap();
    private static Cache searchfilterMap = new Cache(1000);

    private static String modifyFilter(String filter, int objectType) {
        switch (objectType) {
            case 6: 
            case 8: {
                StringBuffer sb = new StringBuffer();
                sb.append("(&").append(filter);
                sb.append("(objectClass=ldapsubentry)").append("(!(cn=");
                sb.append("ContainerDefaultTemplateRole");
                sb.append(")))");
                return sb.toString();
            }
        }
        return filter;
    }

    public static String getSearchFilter(int objectType, String orgDN, String searchTemplateName, boolean ignoreComplianceFilter) {
        String cacheKey;
        String filter;
        String organizationDN = new DN(orgDN).toRFCString();
        String rootSuffixDN = AMStoreConnection.getAMSdkBaseDN();
        if (orgDN != null && organizationDN.equals(rootSuffixDN)) {
            orgDN = null;
        }
        if ((filter = (String)searchfilterMap.get(cacheKey = new Integer(objectType).toString() + ":" + searchTemplateName + ":" + organizationDN)) == null) {
            IDirectoryServices dsServices = AMDirectoryAccessFactory.getDirectoryServices();
            filter = dsServices.getSearchFilterFromTemplate(objectType, orgDN, searchTemplateName);
            searchfilterMap.put(cacheKey, filter);
        }
        filter = AMSearchFilterManager.modifyFilter(filter, objectType);
        filter = AMSearchFilterManager.addAdminGroupFilters(filter, orgDN, objectType);
        filter = AMSearchFilterManager.addComplianceModeFilters(filter, objectType, ignoreComplianceFilter);
        return filter;
    }

    private static String addAdminGroupFilters(String originalFilter, String orgDN, int objectType) {
        block7: {
            try {
                if (!AMCompliance.isAdminGroupsEnabled(orgDN)) {
                    String modifiedFilter = originalFilter;
                    switch (objectType) {
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            StringBuffer sb = new StringBuffer();
                            sb.append("(&").append(originalFilter).append("(!(");
                            sb.append(AMNamingAttrManager.getNamingAttr(12));
                            sb.append("=serviceadministrators))").append("(!(");
                            sb.append(AMNamingAttrManager.getNamingAttr(12));
                            sb.append("=servicehelpdeskadministrators)))");
                            modifiedFilter = sb.toString();
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMSearchFilterManager.addAdminGroupFilters() - objectType = " + objectType + ", orgDN = " + orgDN + ", Original filter: " + originalFilter + ", Modified filter = " + modifiedFilter);
                    }
                    return modifiedFilter;
                }
            }
            catch (AMException ae) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("AMSearchFilterManager.addAdminGroupFilters() Unable to determine if \"Admin Groups\" option is enabled or disabled. Exception : ", (Throwable)ae);
            }
        }
        return originalFilter;
    }

    private static String addComplianceModeFilters(String originalFilter, int objectType, boolean ignoreComplianceFilter) {
        block9: {
            try {
                String modifiedFilter = originalFilter;
                if (!ignoreComplianceFilter && AMCompliance.isComplianceUserDeletionEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    switch (objectType) {
                        case 1: {
                            sb.append("(&").append(originalFilter);
                            sb.append("(!(inetuserstatus=deleted)))");
                            modifiedFilter = sb.toString();
                            break;
                        }
                        case 2: {
                            sb.append("(&").append(originalFilter);
                            sb.append("(!(inetdomainstatus=deleted)))");
                            modifiedFilter = sb.toString();
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            sb.append("(&").append(originalFilter);
                            sb.append("(!(inetgroupstatus=deleted)))");
                            modifiedFilter = sb.toString();
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMSearchFilterManager.addComplainceModeFilters() - objectType = " + objectType + ", Original Filter = " + originalFilter + ", Modified Filter = " + modifiedFilter);
                    }
                    return modifiedFilter;
                }
            }
            catch (AMException ae) {
                if (!debug.warningEnabled()) break block9;
                debug.warning("AMSearchFilterManager.addComplianceModeFilters() Unable to determine if \"User Compliance deletion mode\" is enabled or disabled. Exception : ", (Throwable)ae);
            }
        }
        return originalFilter;
    }

    public static String getSearchFilter(int objectType, String orgDN) {
        return AMSearchFilterManager.getSearchFilter(objectType, orgDN, null, true);
    }

    public static String getGlobalSearchFilter(int objectType) {
        return AMSearchFilterManager.getGlobalSearchFilter(objectType, null);
    }

    public static String getGlobalSearchFilter(int objectType, String searchTemplateName) {
        return AMSearchFilterManager.getSearchFilter(objectType, null, searchTemplateName, true);
    }
}

