/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.common.DCTreeServicesHelper;
import com.iplanet.am.sdk.common.IDCTreeServices;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.iplanet.ums.Organization;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.dctree.DomainComponent;
import com.iplanet.ums.dctree.DomainComponentTree;
import com.iplanet.ums.dctree.InvalidDCRootException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.util.DN;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class DCTreeServicesImpl
extends DCTreeServicesHelper
implements AMConstants,
IDCTreeServices {
    private static Map domainMap = new HashMap();
    private static Map canonicalDomainMap = new HashMap();
    private static Debug debug = CommonUtils.debug;

    protected void createDomain(SSOToken token, Guid orgGuid, AttrSet attrSet) throws AMException, SSOException {
        if (DCTREE_START_DN == null) {
            throw new AMException(AMSDKBundle.getString("355"), "355");
        }
        String domainName = attrSet.getValue("sunPreferredDomain");
        attrSet.remove("sunPreferredDomain");
        if (domainName != null && domainName != "") {
            try {
                AttrSet[] attrSetArray;
                DomainComponentTree dcTree = new DomainComponentTree(token, new Guid(DCTREE_START_DN));
                dcTree.addDomain(domainName);
                dcTree.setDomainMapping(domainName, orgGuid);
                String status = attrSet.getValue("inetdomainstatus");
                if (status != null) {
                    dcTree.setDomainStatus(domainName, status);
                }
                if ((attrSetArray = this.splitAttrSet(orgGuid.getDn(), attrSet))[1] != null) {
                    this.setDomainAttributes(token, orgGuid.getDn(), attrSetArray[1]);
                }
            }
            catch (InvalidDCRootException ie) {
                debug.error("DCTree.createDomain(): ", (Throwable)ie);
                throw new AMException(AMSDKBundle.getString("343"), "343");
            }
            catch (UMSException ue) {
                debug.error("DCTree.createDomain(): ", (Throwable)ue);
                throw new AMException(AMSDKBundle.getString("344"), "344");
            }
        }
    }

    protected void createDomain(SSOToken token, Guid orgGuid, String domainName, AttrSet attrSet) throws AMException {
        if (DCTREE_START_DN == null) {
            throw new AMException(AMSDKBundle.getString("355"), "355");
        }
        if (domainName != null && domainName != "") {
            try {
                DomainComponentTree dcTree = new DomainComponentTree(token, new Guid(DCTREE_START_DN));
                dcTree.addDomain(domainName);
                dcTree.setDomainMapping(domainName, orgGuid);
                String status = attrSet.getValue("inetdomainstatus");
                if (status != null) {
                    dcTree.setDomainStatus(domainName, status);
                }
            }
            catch (InvalidDCRootException ie) {
                debug.error("DCTree.createDomain(): ", (Throwable)ie);
                throw new AMException(AMSDKBundle.getString("343"), "343");
            }
            catch (UMSException ue) {
                debug.error("DCTree.createDomain(): ", (Throwable)ue);
                throw new AMException(AMSDKBundle.getString("344"), "344");
            }
        }
    }

    protected void removeDomain(SSOToken token, String orgDN) throws AMException {
        block9: {
            try {
                PersistentObject po = UMSObject.getObject(token, new Guid(orgDN));
                if (!(po instanceof Organization)) {
                    if (debug.messageEnabled()) {
                        debug.message("DCTree.removeDomain-> " + orgDN + " is not an organization");
                    }
                    return;
                }
                String domainName = this.getCanonicalDomain(token, orgDN);
                if (debug.messageEnabled()) {
                    debug.message("DCTree.removeDomain-> Obtained canon domain " + domainName);
                }
                if (domainName != null && domainName.length() > 0) {
                    DomainComponentTree dcTree = new DomainComponentTree(token, new Guid(DCTREE_START_DN));
                    if (debug.messageEnabled()) {
                        debug.message("DCTree.removeDomain: removing domain: " + domainName);
                    }
                    dcTree.removeDomain(domainName);
                } else if (debug.warningEnabled()) {
                    debug.warning("DCTree.removeDomain():  unable to get domain for " + orgDN);
                }
            }
            catch (UMSException ue) {
                if (!debug.warningEnabled()) break block9;
                debug.warning("DCTree.removeDomain(): ", (Throwable)ue);
            }
        }
    }

    protected void updateDomainStatus(SSOToken token, String orgDN, String status) throws AMException {
        try {
            String domainName = this.getCanonicalDomain(token, orgDN);
            if (domainName != null && domainName.length() > 0) {
                DomainComponentTree dcTree = new DomainComponentTree(token, new Guid(DCTREE_START_DN));
                dcTree.setDomainStatus(domainName, status);
            } else {
                debug.warning("DCTree.updateDomainStatus(): value for sunPreferredDomain attribute null or empty");
            }
        }
        catch (UMSException ue) {
            debug.error("DCTree.removeDomain(): ", (Throwable)ue);
            throw new AMException(AMSDKBundle.getString("356"), "356");
        }
    }

    protected void setDomainAttributes(SSOToken token, String orgDN, AttrSet attrSet) throws AMException {
        String domainName = null;
        try {
            domainName = this.getCanonicalDomain(token, orgDN);
            DomainComponentTree dcTree = new DomainComponentTree(token, new Guid(DCTREE_START_DN));
            if (domainName == null) {
                if (debug.messageEnabled()) {
                    debug.message("DCTree.setDomainAttrs: No domain found for org : " + orgDN);
                }
                return;
            }
            DomainComponent dcNode = dcTree.getDomainComponent(domainName);
            if (attrSet != null) {
                Attr ocAttr;
                if (debug.messageEnabled()) {
                    debug.message("DCTree.setDomainAttrs:  setting attributes on domain " + domainName + ": " + attrSet.toString());
                }
                if ((ocAttr = attrSet.getAttribute("objectclass")) != null) {
                    Attr oldOCAttr = dcNode.getAttribute("objectclass");
                    if (oldOCAttr != null) {
                        ocAttr.addValues(oldOCAttr.getStringValues());
                    }
                    if (debug.messageEnabled()) {
                        debug.message("DCTree.setDomainAttrs-> objectclasses to be set " + ocAttr.toString());
                    }
                    if (ocAttr.size() == 0) {
                        dcNode.modify(ocAttr, 1);
                    } else {
                        dcNode.modify(ocAttr, 2);
                    }
                    dcNode.save();
                    attrSet.remove("objectclass");
                }
                int size = attrSet.size();
                for (int i = 0; i < size; ++i) {
                    Attr attr = attrSet.elementAt(i);
                    if (attr.size() == 0) {
                        dcNode.modify(attr, 1);
                        continue;
                    }
                    dcNode.modify(attr, 2);
                }
                dcNode.save();
            }
        }
        catch (UMSException umse) {
            debug.error("DCTree.setDomainAttributes:  error setting  attribute for domain " + domainName, (Throwable)umse);
        }
    }

    protected String getDCNodeDN(SSOToken token, String orgDN) throws AMException {
        try {
            String domainName = this.getCanonicalDomain(token, orgDN);
            if (domainName != null) {
                DomainComponentTree dcTree = new DomainComponentTree(token, new Guid(DCTREE_START_DN));
                String dcNodeDN = dcTree.mapDomainToDN(domainName);
                return CommonUtils.formatToRFC(dcNodeDN);
            }
            return null;
        }
        catch (InvalidDCRootException e) {
            debug.error("DCTree.getDCNodeDN(): Invalid DC root ", (Throwable)e);
            throw new AMException(AMSDKBundle.getString("343"), "343");
        }
        catch (UMSException e) {
            debug.error("DCTree.getDCNodeDN(): Unable to get dc node dn for: " + orgDN, (Throwable)e);
            throw new AMException(AMSDKBundle.getString("344"), "344");
        }
    }

    protected AttrSet getDomainAttributes(SSOToken token, String orgDN, String[] attrNames) throws AMException, SSOException {
        String domainName = null;
        try {
            domainName = this.getCanonicalDomain(token, orgDN);
            if (domainName == null) {
                debug.error("DCTree.getDomainAttributes-> Domain not found for:  " + orgDN);
                return null;
            }
            DomainComponentTree dcTree = new DomainComponentTree(token, new Guid(DCTREE_START_DN));
            DomainComponent dcNode = dcTree.getDomainComponent(domainName);
            AttrSet domAttrSet = attrNames != null ? dcNode.getAttributes(attrNames) : dcNode.getAttributes(dcNode.getAttributeNames());
            AttrSet[] attrArray = this.splitAttrSet(null, domAttrSet);
            return attrArray[1];
        }
        catch (UMSException umse) {
            debug.error("DCTree.getDomainAttributes:  error getting attributes for domain " + domainName);
            return null;
        }
    }

    public String getOrganizationDN(SSOToken token, String domainName) throws AMException {
        try {
            DomainComponentTree dcTree = new DomainComponentTree(token, new Guid(DCTREE_START_DN));
            Hashtable domainToOrgTable = dcTree.getChildDomainIDs();
            if (debug.messageEnabled()) {
                debug.message("DCTree:getOrgDN-> domain=" + domainName);
            }
            return (String)domainToOrgTable.get(domainName);
        }
        catch (UMSException umse) {
            debug.error("DCTree:getOrganizationDN: UMS Exception: ", (Throwable)umse);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    protected AttrSet[] splitAttrSet(String orgDN, AttrSet attrSet) throws AMException, SSOException {
        AttrSet[] attrArray = new AttrSet[]{attrSet != null ? (AttrSet)attrSet.clone() : new AttrSet(), new AttrSet()};
        if (attrSet == null) {
            return attrArray;
        }
        Set dcNodeAttrs = this.dcNodeAttributes();
        for (String aName : dcNodeAttrs) {
            if (aName.indexOf("objectclass=") > -1) {
                Attr attr0 = attrSet.getAttribute("objectclass");
                Attr attr = attr0 != null ? (Attr)attr0.clone() : null;
                String oc = aName.substring("objectclass=".length());
                Attr dcAttr = new Attr("objectclass");
                if (attr == null || !attr.contains(oc)) continue;
                attr.removeValue(oc);
                dcAttr.addValue(oc);
                attrArray[0].replace(attr);
                attrArray[1].add(dcAttr);
                continue;
            }
            Attr attr = attrSet.getAttribute(aName);
            if (attr == null) continue;
            attrArray[1].add(attr);
            attrArray[0].remove(aName);
        }
        if (debug.messageEnabled()) {
            debug.message("DCTreeServicesImpl.splitAttrSet: domain attrset = " + attrArray[1].toString());
            debug.message("DCTreeServicesImpl.splitAttrSet: non-domain attrset = " + attrArray[0].toString());
        }
        return attrArray;
    }

    protected String getCanonicalDomain(SSOToken token, String orgDN) throws AMException {
        String canonOrgDN = new DN(orgDN).toRFCString().toLowerCase();
        return this.updateCacheAndReturnDomain(token, canonOrgDN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanDomainMap(String canonOrgDN) {
        Map map = canonicalDomainMap;
        synchronized (map) {
            canonicalDomainMap.remove(canonOrgDN);
        }
        map = domainMap;
        synchronized (map) {
            domainMap.remove(canonOrgDN);
        }
    }

    private String updateCacheAndReturnDomain(SSOToken token, String canonOrgDN) throws AMException {
        try {
            DomainComponentTree dcTree = new DomainComponentTree(token, new Guid(DCTREE_START_DN));
            SearchControl scontrol = new SearchControl();
            scontrol.setSearchScope(2);
            PersistentObject po = UMSObject.getObject(token, new Guid(DCTREE_START_DN));
            String searchFilter = "(inetDomainBaseDN=" + canonOrgDN + ")";
            if (debug.messageEnabled()) {
                debug.message("DCTree.updateCache-> searchFilter= " + searchFilter);
            }
            SearchResults results = po.search(searchFilter, null);
            int count = 0;
            String domainName = null;
            String canonDomain = null;
            while (results.hasMoreElements()) {
                Attr isCanonical;
                DomainComponent dcNode = (DomainComponent)results.next();
                ++count;
                domainName = dcTree.mapDCToDomainName(dcNode);
                if (debug.messageEnabled()) {
                    debug.message("DCTree:updateCache-> domainName= " + domainName);
                }
                if ((isCanonical = dcNode.getAttribute("inetcanonicaldomainname")) == null) continue;
                canonDomain = domainName;
            }
            results.abandon();
            if (count == 1) {
                canonDomain = domainName;
            }
            if (debug.messageEnabled()) {
                debug.message("DCTree.updateCache-> returning domain= " + canonDomain);
            }
            return canonDomain;
        }
        catch (UMSException umse) {
            debug.error("DCTree:updateCache: UMSException", (Throwable)umse);
            return null;
        }
    }

    public Set dcNodeAttributes() throws AMException, SSOException {
        Map attrMap;
        Set values;
        if (!this.isInitalized()) {
            this.initialize();
        }
        if ((values = (Set)(attrMap = this.getAdminServiceGlobalSchema().getAttributeDefaults()).get("iplanet-am-admin-console-dctree-attr-list")) == null) {
            if (debug.messageEnabled()) {
                debug.message("DCTree.dcNodeAttributes = null");
            }
            return Collections.EMPTY_SET;
        }
        if (debug.messageEnabled()) {
            debug.message("DCTree.dcNodeAttributes = " + values.toString());
        }
        return values;
    }
}

