/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.remote;

import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.common.CallBackHelperBase;
import com.iplanet.am.sdk.common.IComplianceServices;
import com.iplanet.am.sdk.common.IDCTreeServices;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.common.MiscUtils;
import com.iplanet.am.sdk.remote.AMRemoteException;
import com.iplanet.am.sdk.remote.ComplianceServicesImpl;
import com.iplanet.am.sdk.remote.DCTreeServicesImpl;
import com.iplanet.am.sdk.remote.EventListener;
import com.iplanet.dpro.session.Session;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SortKey;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class RemoteServicesImpl
implements IDirectoryServices {
    protected static final String AM_SDK_DEBUG_FILE = "amProfile_Client";
    protected static final String SDK_SERVICE = "DirectoryManagerIF";
    protected static final String IDREPO_SERVICE = "IdRepoServiceIF";
    protected static final String AMSR_COUNT = "__count";
    protected static final String AMSR_RESULTS = "__results";
    protected static final String AMSR_CODE = "__errorCode";
    protected static final String AMSR_ATTRS = "__attrs";
    protected static Debug debug = Debug.getInstance((String)"amProfile_Client");
    private static RemoteServicesImpl instance;
    private SOAPClient client = new SOAPClient("DirectoryManagerIF");
    protected IDCTreeServices dcTreeServicesImpl = new DCTreeServicesImpl(this.client);
    protected IComplianceServices complianceServicesImpl = new ComplianceServicesImpl(this.client);
    protected CallBackHelperBase callBackHelperBase = new CallBackHelperBase();

    protected static Debug getDebug() {
        return debug;
    }

    protected SOAPClient getSOAPClient() {
        return this.client;
    }

    protected static synchronized IDirectoryServices getInstance() {
        if (instance == null) {
            RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getInstance(): Creating a new Instance of RemoteServicesImpl()");
            instance = new RemoteServicesImpl();
        }
        return instance;
    }

    public IDCTreeServices getDCTreeServicesImpl() {
        return this.dcTreeServicesImpl;
    }

    public IComplianceServices getComplianceServicesImpl() {
        return this.complianceServicesImpl;
    }

    public boolean doesEntryExists(SSOToken token, String entryDN) {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN};
            Boolean res = (Boolean)this.client.send(this.client.encodeMessage("doesEntryExists", objs), Session.getLBCookie(tokenID), null);
            return res;
        }
        catch (RemoteException rex) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int getObjectType(SSOToken token, String dn) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, dn};
            Integer res = (Integer)this.client.send(this.client.encodeMessage("getObjectType", objs), Session.getLBCookie(tokenID), null);
            return res;
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getObjectType: dn=" + dn + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getObjectType: dn=" + dn + ";  AMRemoteException caught exception=", (Throwable)rex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getObjectType: dn=" + dn + ";  caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getObjectType: dn=" + dn + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public int getObjectType(SSOToken token, String dn, Map cachedAttributes) throws AMException, SSOException {
        return this.getObjectType(token, dn);
    }

    public Map getDCTreeAttributes(SSOToken token, String entryDN, Set attrNames, boolean byteValues, int objectType) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, attrNames, byteValues, new Integer(objectType)};
            return (Map)this.client.send(this.client.encodeMessage("getDCTreeAttributes", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getDCTreeAttributes: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getDCTreeAttributes: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getDCTreeAttributes: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getDCTreeAttributes: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributes(SSOToken token, String entryDN, int profileType) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, new Integer(profileType)};
            Map map = (Map)this.client.send(this.client.encodeMessage("getAttributes1", objs), Session.getLBCookie(tokenID), null);
            AMHashMap res = new AMHashMap();
            res.copy(map);
            return res;
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributes: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributes: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributes: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributes: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributes(SSOToken token, String entryDN, Set attrNames, int profileType) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, attrNames, new Integer(profileType)};
            Map map = (Map)this.client.send(this.client.encodeMessage("getAttributes2", objs), Session.getLBCookie(tokenID), null);
            AMHashMap res = new AMHashMap();
            res.copy(map);
            return res;
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributes 2: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributes: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributes: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributes2: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributesFromDS(SSOToken token, String entryDN, Set attrNames, int profileType) throws AMException, SSOException {
        return this.getAttributes(token, entryDN, attrNames, profileType);
    }

    public Map getAttributesByteValues(SSOToken token, String entryDN, int profileType) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, new Integer(profileType)};
            return (Map)this.client.send(this.client.encodeMessage("getAttributesByteValues1", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributesByteValues: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributesByteValues: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributesByteValues: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributesByteValues: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributesByteValues(SSOToken token, String entryDN, Set attrNames, int profileType) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, attrNames, new Integer(profileType)};
            return (Map)this.client.send(this.client.encodeMessage("getAttributesByteValues2", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributesByteValues2: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributesByteValues: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributesByteValues: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributesByteValues2: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributes(SSOToken token, String entryDN, boolean ignoreCompliance, boolean byteValues, int profileType) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, ignoreCompliance, byteValues, new Integer(profileType)};
            Map map = (Map)this.client.send(this.client.encodeMessage("getAttributes3", objs), Session.getLBCookie(tokenID), null);
            AMHashMap res = new AMHashMap();
            res.copy(map);
            return res;
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributes 3: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributes: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributes: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributes3: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributes(SSOToken token, String entryDN, Set attrNames, boolean ignoreCompliance, boolean byteValues, int profileType) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, attrNames, ignoreCompliance, byteValues, new Integer(profileType)};
            Map map = (Map)this.client.send(this.client.encodeMessage("getAttributes4", objs), Session.getLBCookie(tokenID), null);
            AMHashMap res = new AMHashMap();
            res.copy(map);
            return res;
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributes 4: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributes: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributes: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributes4: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String getOrgSearchFilter(String entryDN) {
        try {
            Object[] objs = new Object[]{entryDN};
            return (String)this.client.send(this.client.encodeMessage("getOrgSearchFilter", objs), null, null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getOrgSearchFilter: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            return "";
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getOrgSearchFilter: caught exception=", (Throwable)rex);
            return "";
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getOrgSearchFilter: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            return "";
        }
    }

    public String getOrganizationDN(SSOToken token, String entryDN) throws AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN};
            return (String)this.client.send(this.client.encodeMessage("getOrganizationDN", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getOrganizationDN: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getOrganizationDN: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getOrganizationDN: caught SSOException=", (Throwable)((Object)ssoe));
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getOrganizationDN: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String verifyAndGetOrgDN(SSOToken token, String entryDN, String childDN) throws AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, childDN};
            return (String)this.client.send(this.client.encodeMessage("verifyAndGetOrgDN", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.verifyAndGetOrgDN: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.verifyAndGetOrgDN: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.verifyAndGetOrgDN: caught SSOException=", (Throwable)((Object)ssoe));
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.verifyAndGetOrgDN: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getExternalAttributes(SSOToken token, String entryDN, Set attrNames, int profileType) throws AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, attrNames, new Integer(profileType)};
            return (Map)this.client.send(this.client.encodeMessage("getExternalAttributes", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getExternalAttributes: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getExternalAttributes: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getExternalAttributes: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void updateUserAttribute(SSOToken token, Set members, String staticGroupDN, boolean toAdd) throws AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, members, staticGroupDN, toAdd};
            this.client.send(this.client.encodeMessage("updateUserAttribute", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.updateUserAttr: staticGroupDN=" + staticGroupDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.updateUserAttribute: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.updateUserAttribute: staticGroupDN=" + staticGroupDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void createEntry(SSOToken token, String entryName, int objectType, String parentDN, Map attributes) throws AMEntryExistsException, AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryName, new Integer(objectType), parentDN, attributes};
            this.client.send(this.client.encodeMessage("createEntry", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.createEntry: entryName=" + entryName + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (SSOException ssoe) {
            throw ssoe;
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.createEntry: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.createEntry: entryName=" + entryName + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void removeEntry(SSOToken token, String entryDN, int objectType, boolean recursive, boolean softDelete) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, new Integer(objectType), recursive, softDelete};
            this.client.send(this.client.encodeMessage("removeEntry", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.removeEntry: entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.removeEntry: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.removeEntry: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.removeEntry: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void removeAdminRole(SSOToken token, String dn, boolean recursive) throws SSOException, AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, dn, recursive};
            this.client.send(this.client.encodeMessage("removeAdminRole", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.removeAdminRole: dn=" + dn + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.removeAdminRole: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.removeAdminRole: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.removeAdminRole: dn=" + dn + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Set search(SSOToken token, String entryDN, String searchFilter, int searchScope) throws AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, searchFilter, new Integer(searchScope)};
            return (Set)this.client.send(this.client.encodeMessage("search1", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.search: entryDN" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.search: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.search: entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public AMSearchResults search(SSOToken token, String entryDN, String searchFilter, SearchControl searchControl, String[] attrNames) throws AMException {
        try {
            SortKey[] keys = searchControl.getSortKeys();
            LinkedList<String> sortKeys = new LinkedList<String>();
            for (int i = 0; keys != null && i < keys.length; ++i) {
                if (keys[i].reverse) {
                    sortKeys.add("true:" + keys[i].attributeName);
                    continue;
                }
                sortKeys.add("fals:" + keys[i].attributeName);
            }
            int[] vlvRange = searchControl.getVLVRange();
            if (vlvRange == null) {
                vlvRange = new int[3];
            }
            Set attrNamesSet = MiscUtils.stringArrayToSet(attrNames);
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, searchFilter, sortKeys, new Integer(vlvRange[0]), new Integer(vlvRange[1]), new Integer(vlvRange[2]), searchControl.getVLVJumpTo(), new Integer(searchControl.getTimeOut()), new Integer(searchControl.getMaxResults()), new Integer(searchControl.getSearchScope()), searchControl.isGetAllReturnAttributesEnabled(), attrNamesSet};
            Map results = (Map)this.client.send(this.client.encodeMessage("search3", objs), Session.getLBCookie(tokenID), null);
            String cString = (String)results.remove(AMSR_COUNT);
            Set dns = (Set)results.remove(AMSR_RESULTS);
            String eString = (String)results.remove(AMSR_CODE);
            int count = 0;
            int errorCode = 0;
            try {
                count = Integer.parseInt(cString);
                errorCode = Integer.parseInt(eString);
            }
            catch (NumberFormatException nfe) {
                RemoteServicesImpl.getDebug().error("RemoteServicesImpl.search: caught number format error", (Throwable)nfe);
            }
            return new AMSearchResults(count, dns, errorCode, results);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.search2 : entryDN" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.search: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.search2 : entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Set getMembers(SSOToken token, String entryDN, int objectType) throws AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, new Integer(objectType)};
            return (Set)this.client.send(this.client.encodeMessage("getMembers", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getMembers : entryDN" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getMembers: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getMembers : entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String renameEntry(SSOToken token, int objectType, String entryDN, String newName, boolean deleteOldName) throws AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, new Integer(objectType), entryDN, newName, deleteOldName};
            return (String)this.client.send(this.client.encodeMessage("renameEntry", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.renameEntry : entryDN" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.renameEntry: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.renameEntry : entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void setAttributes(SSOToken token, String entryDN, int objectType, Map stringAttributes, Map byteAttributes, boolean isAdd) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, new Integer(objectType), stringAttributes, byteAttributes, isAdd};
            this.client.send(this.client.encodeMessage("setAttributes", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.setAttributes : entryDN" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.setAttributes: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.setAttributes: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.setAttributes : entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void changePassword(SSOToken token, String entryDN, String attrName, String oldPassword, String newPassword) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, attrName, oldPassword, newPassword};
            this.client.send(this.client.encodeMessage("changePassword", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.changePassword : entryDN" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.changePassword: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.changePassword: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.changePassword : entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String[] getGroupFilterAndScope(SSOToken token, String entryDN, int profileType) throws SSOException, AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, new Integer(profileType)};
            LinkedList list = (LinkedList)this.client.send(this.client.encodeMessage("getGroupFilterAndScope", objs), Session.getLBCookie(tokenID), null);
            String[] array = new String[list.size()];
            list.toArray(array);
            return array;
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getGroupFilterAndScope : entryDN" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getGroupFilterAndScope: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getGroupFilterAndScope: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getGroupFilterAndScope : entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void setGroupFilter(SSOToken token, String entryDN, String filter) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, filter};
            this.client.send(this.client.encodeMessage("setGroupFilter", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.setGroupFilter : entryDN" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.setGroupFilter: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.setGroupFilter: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.setGroupFilter : entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.setGroupFilter: caught exception=", (Throwable)ex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void modifyMemberShip(SSOToken token, Set members, String target, int type, int operation) throws AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, members, target, new Integer(type), new Integer(operation)};
            this.client.send(this.client.encodeMessage("modifyMemberShip", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.modifyMemberShip : target" + target + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.modifyMemberShip: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.modifyMemberShip : target=" + target + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Set getRegisteredServiceNames(SSOToken token, String entryDN) throws AMException {
        try {
            Object[] objs = new Object[]{null, entryDN};
            return (Set)this.client.send(this.client.encodeMessage("getRegisteredServiceNames", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getRegisteredServiceNames : entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getRegisteredServiceNames: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getRegisteredServiceNames : entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void registerService(SSOToken token, String orgDN, String serviceName) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, orgDN, serviceName};
            this.client.send(this.client.encodeMessage("registerService", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.registerService : orgDN=" + orgDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.registerService: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.registerService: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.registerService : orgDN=" + orgDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void unRegisterService(SSOToken token, String entryDN, int objectType, String serviceName, int type) throws AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, new Integer(objectType), serviceName, new Integer(type)};
            this.client.send(this.client.encodeMessage("unRegisterService", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.unRegisterService : entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.unRegisterService: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.unRegisterService : entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String getAMTemplateDN(SSOToken token, String entryDN, int objectType, String serviceName, int type) throws AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, new Integer(objectType), serviceName, new Integer(type)};
            return (String)this.client.send(this.client.encodeMessage("getAMTemplateDN", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAMTemplateDN : entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAMTemplateDN: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAMTemplateDN : entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String createAMTemplate(SSOToken token, String entryDN, int objectType, String serviceName, Map attributes, int priority) throws AMException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID, entryDN, new Integer(objectType), serviceName, attributes, new Integer(priority)};
            return (String)this.client.send(this.client.encodeMessage("createAMTemplate", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.createAMTemplate : entryDN=" + entryDN + ";  AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.createAMTemplate: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.createAMTemplate : entryDN=" + entryDN + ";  caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String getNamingAttribute(int objectType, String orgDN) {
        try {
            Object[] objs = new Object[]{new Integer(objectType), orgDN};
            return (String)this.client.send(this.client.encodeMessage("getNamingAttr", objs), null, null);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getNamingAttr: caught exception=", (Throwable)rex);
            return null;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getNamingAttribute : orgDN=" + orgDN + ";  caught exception=", (Throwable)ex);
            }
            return null;
        }
    }

    public String getCreationTemplateName(int objectType) {
        try {
            Object[] objs = new Object[]{new Integer(objectType)};
            return (String)this.client.send(this.client.encodeMessage("getCreationTemplateName", objs), null, null);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getCreationTemplateName: caught exception=", (Throwable)rex);
            return null;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getCreationTemplateName :   caught exception=", (Throwable)ex);
            }
            return null;
        }
    }

    public String getObjectClass(int objectType) {
        try {
            Object[] objs = new Object[]{new Integer(objectType)};
            return (String)this.client.send(this.client.encodeMessage("getObjectClassFromDS", objs), null, null);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getObjectClassFromDS: caught exception=", (Throwable)rex);
            return null;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getObjectClass :   caught exception=", (Throwable)ex);
            }
            return null;
        }
    }

    public Set getAttributesForSchema(String objectclass) {
        try {
            Object[] objs = new Object[]{objectclass};
            return (Set)this.client.send(this.client.encodeMessage("getAttributesForSchema", objs), null, null);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getAttributesForSchema: caught exception=", (Throwable)rex);
            return Collections.EMPTY_SET;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getAttributesForSchema :   caught exception=", (Throwable)ex);
            }
            return Collections.EMPTY_SET;
        }
    }

    public String getSearchFilterFromTemplate(int objectType, String orgDN, String searchTemplateName) {
        try {
            Object[] objs = new Object[]{new Integer(objectType), orgDN};
            return (String)this.client.send(this.client.encodeMessage("getSearchFilterFromTemplate", objs), null, null);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getSearchFilterFromTemplate: caught exception=", (Throwable)rex);
            return null;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getSearchFilterFromTemplate : orgDN=" + orgDN + ";  caught exception=", (Throwable)ex);
            }
            return null;
        }
    }

    public Set getTopLevelContainers(SSOToken token) throws AMException, SSOException {
        try {
            String tokenID = ((Object)token.getTokenID()).toString();
            Object[] objs = new Object[]{tokenID};
            return (Set)this.client.send(this.client.encodeMessage("getTopLevelContainers", objs), Session.getLBCookie(tokenID), null);
        }
        catch (AMRemoteException amrex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getTopLevelContainers :   AMRemoteException caught exception=", (Throwable)amrex);
            }
            throw RemoteServicesImpl.convertException(amrex);
        }
        catch (RemoteException rex) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getTopLevelContainers: caught exception=", (Throwable)rex);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException ssoe) {
            RemoteServicesImpl.getDebug().error("RemoteServicesImpl.getTopLevelContainers: caught SSOException=", (Throwable)((Object)ssoe));
            throw ssoe;
        }
        catch (Exception ex) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("RemoteServicesImpl.getTopLevelContainers :   caught exception=", (Throwable)ex);
            }
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    protected static AMException convertException(AMRemoteException amrx) {
        return new AMException(amrx.getMessage(), amrx.getErrorCode(), amrx.getMessageArgs());
    }

    public void addListener(SSOToken token, AMObjectListener listener, Map configMap) throws AMEventManagerException {
        EventListener.getInstance().addListener(token, listener);
    }
}

