/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.ThreadPool;
import com.iplanet.am.util.ThreadPoolException;
import com.iplanet.dpro.session.SessionEvent;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.SessionListener;
import com.iplanet.dpro.session.SessionNotificationHandler;
import com.iplanet.dpro.session.SessionTimedOutException;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.dpro.session.TokenRestrictionFactory;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.dpro.session.share.SessionResponse;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SearchResults;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.common.TimerPool;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.session.util.RestrictedTokenAction;
import com.sun.identity.session.util.RestrictedTokenContext;
import com.sun.identity.session.util.SessionUtils;
import com.sun.identity.shared.debug.Debug;
import java.net.URL;
import java.security.AccessController;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;

public class Session
extends GeneralTaskRunnable {
    private SessionID sessionID;
    private int sessionType;
    private String clientID;
    private String clientDomain;
    private long maxSessionTime;
    private long maxIdleTime;
    private long maxCachingTime;
    private long sessionIdleTime;
    private long sessionTimeLeft;
    private volatile long timedOutAt = 0L;
    private int sessionState;
    private Hashtable sessionProperties = new Hashtable();
    private URL sessionServiceURL;
    private int eventType = -1;
    private volatile long latestRefreshTime;
    private static final String httpSessionTrackingCookieName = SystemProperties.get("com.iplanet.am.session.failover.httpSessionTrackingCookieName", "JSESSIONID");
    volatile boolean needToReset = false;
    private SessionService sessionService = null;
    private boolean sessionIsLocal = false;
    public static final int INVALID = 0;
    public static final int VALID = 1;
    public static final int INACTIVE = 2;
    public static final int DESTROYED = 3;
    public static final int USER_SESSION = 0;
    public static final int APPLICATION_SESSION = 1;
    public static final String SESSION_HANDLE_PROP = "SessionHandle";
    public static final String TOKEN_RESTRICTION_PROP = "TokenRestriction";
    public static final String SESSION_SERVICE = "session";
    private static String cookieName = SystemProperties.get("com.iplanet.am.cookie.name");
    public static String lbCookieName = SystemProperties.get("com.iplanet.am.lbcookie.name", "amlbcookie");
    private static final boolean resetLBCookie = Boolean.valueOf(SystemProperties.get("com.sun.identity.session.resetLBCookie", "false"));
    private String cookieStr;
    Boolean cookieMode = null;
    private TokenRestriction restriction = null;
    private Object context = null;
    private static long purgeDelay;
    private static Debug sessionDebug;
    private static boolean pollingEnabled;
    private static boolean pollerPoolInitialized;
    private static final String ENABLE_POLLING_PROPERTY = "com.iplanet.am.session.client.polling.enable";
    private static boolean sessionCleanupEnabled;
    private static Hashtable sessionTable;
    private static Hashtable sessionServiceURLTable;
    private Vector sessionEventListeners = new Vector();
    private static Vector allSessionEventListeners;
    private volatile boolean isPolling = false;
    private static TimerPool timerPool;
    private static ThreadPool threadPool;
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final int DEFAULT_THRESHOLD = 10000;
    private static boolean cacheBasedPolling;
    private static long appSSOTokenRefreshTime;
    private SessionPollerSender sender = null;

    private static String getAMServerID() {
        String serverid = null;
        try {
            serverid = WebtopNaming.getAMServerID();
        }
        catch (Exception le) {
            serverid = null;
        }
        return serverid;
    }

    protected void setIsPolling(boolean b) {
        this.isPolling = b;
    }

    protected boolean getIsPolling() {
        return this.isPolling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isPollingEnabled() {
        if (!Session.isServerMode()) {
            pollingEnabled = Boolean.valueOf(SystemProperties.get(ENABLE_POLLING_PROPERTY, "false"));
        }
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("Session.isPollingEnabled is " + pollingEnabled);
        }
        if (!pollerPoolInitialized) {
            if (pollingEnabled) {
                int threshold;
                int poolSize;
                try {
                    poolSize = Integer.parseInt(SystemProperties.get("com.sun.identity.session.polling.threadpool.size"));
                }
                catch (Exception e) {
                    poolSize = 5;
                }
                try {
                    threshold = Integer.parseInt(SystemProperties.get("com.sun.identity.session.polling.threadpool.threshold"));
                }
                catch (Exception e) {
                    threshold = 10000;
                }
                ShutdownManager shutdownMan = ShutdownManager.getInstance();
                if (shutdownMan.acquireValidLock()) {
                    try {
                        threadPool = new ThreadPool("amSessionPoller", poolSize, threshold, true, sessionDebug);
                        shutdownMan.addShutdownListener(new ShutdownListener(){

                            public void shutdown() {
                                threadPool.shutdown();
                            }
                        });
                    }
                    finally {
                        shutdownMan.releaseLockAndNotify();
                    }
                }
                pollerPoolInitialized = true;
            } else if (sessionDebug.messageEnabled()) {
                sessionDebug.message("Session Cache cleanup is set to " + sessionCleanupEnabled);
            }
        }
        if ((pollingEnabled || sessionCleanupEnabled) && timerPool == null) {
            timerPool = SystemTimerPool.getTimerPool();
        }
        return pollingEnabled;
    }

    Session(SessionID sid) {
        this.sessionID = sid;
        if (Session.isServerMode()) {
            this.sessionService = SessionService.getSessionService();
        }
    }

    public static String getCookieName() {
        return cookieName;
    }

    public boolean addElement(Object obj) {
        return false;
    }

    public boolean removeElement(Object obj) {
        return false;
    }

    public boolean isEmpty() {
        return true;
    }

    public long getRunPeriod() {
        return -1L;
    }

    public void run() {
        if (Session.isPollingEnabled()) {
            SessionID sid = this.getID();
            try {
                if (!this.getIsPolling()) {
                    long expectedTime = -1L;
                    if (this.maxIdleTime < 0x222222222222222L) {
                        expectedTime = (this.latestRefreshTime + this.maxIdleTime * 60L) * 1000L;
                        if (cacheBasedPolling) {
                            expectedTime = Math.min(expectedTime, (this.latestRefreshTime + this.maxCachingTime * 60L) * 1000L);
                        }
                    } else {
                        expectedTime = (this.latestRefreshTime + appSSOTokenRefreshTime * 60L) * 1000L;
                    }
                    if (expectedTime > this.scheduledExecutionTime()) {
                        timerPool.schedule((TaskRunnable)this, new Date(expectedTime));
                        return;
                    }
                    if (this.sender == null) {
                        this.sender = new SessionPollerSender(this, sessionDebug);
                    }
                    RestrictedTokenContext.doUsing(this.getContext(), new RestrictedTokenAction(){

                        public Object run() throws Exception {
                            try {
                                Session.this.setIsPolling(true);
                                threadPool.run(Session.this.sender);
                            }
                            catch (ThreadPoolException e) {
                                Session.this.setIsPolling(false);
                                sessionDebug.error("Send Polling Error: ", (Throwable)e);
                            }
                            return null;
                        }
                    });
                }
            }
            catch (SessionException se) {
                Session.removeSID(sid);
                sessionDebug.message("session is not in timeout state so clean it", (Throwable)((Object)se));
            }
            catch (Exception ex) {
                sessionDebug.error("Exception encountered while polling", (Throwable)ex);
            }
        } else if (sessionCleanupEnabled) {
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("Session Cache Cleaner started");
            }
            long expectedTime = -1L;
            if (this.maxSessionTime < 0x222222222222222L) {
                expectedTime = (this.latestRefreshTime + this.maxSessionTime * 60L) * 1000L;
            }
            if (expectedTime > this.scheduledExecutionTime()) {
                timerPool.schedule((TaskRunnable)this, new Date(expectedTime));
                return;
            }
            try {
                Session.removeSID(this.getID());
                if (sessionDebug.messageEnabled()) {
                    sessionDebug.message("Session Destroyed, Caching time exceeded the Max Session Time");
                }
            }
            catch (Exception ex) {
                sessionDebug.error("Exception occured while cleaning up Session Cache", (Throwable)ex);
            }
        }
    }

    public static String getLBCookie(String sid) throws SessionException {
        return Session.getLBCookie(new SessionID(sid));
    }

    public static String getLBCookie(SessionID sid) throws SessionException {
        String cookieValue = null;
        lbCookieName = SystemProperties.get("com.iplanet.am.lbcookie.name", "amlbcookie");
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("Session.getLBCookie()lbCookieName is:" + lbCookieName);
        }
        if (sid == null || sid.toString() == null || sid.toString().length() == 0) {
            throw new SessionException(SessionBundle.rbName, "invalidSessionID", null);
        }
        if (Session.isServerMode() && !SessionService.getSessionService().isSiteEnabled()) {
            cookieValue = WebtopNaming.getLBCookieValue(sid.getSessionServerID());
            return lbCookieName + "=" + cookieValue;
        }
        if (resetLBCookie) {
            if (Session.isServerMode()) {
                SessionService ss = SessionService.getSessionService();
                if (ss.isSessionFailoverEnabled() && ss.isLocalSite(sid)) {
                    cookieValue = WebtopNaming.getLBCookieValue(ss.getCurrentHostServer(sid));
                }
            } else {
                Session sess = (Session)((Object)sessionTable.get(sid));
                if (sess != null) {
                    cookieValue = sess.getProperty(lbCookieName);
                }
            }
        }
        if (cookieValue == null || cookieValue.length() == 0) {
            cookieValue = WebtopNaming.getLBCookieValue(sid.getExtension("S1"));
        }
        return lbCookieName + "=" + cookieValue;
    }

    public SessionID getID() {
        return this.sessionID;
    }

    public int getType() {
        return this.sessionType;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientDomain() {
        return this.clientDomain;
    }

    public long getMaxSessionTime() {
        return this.maxSessionTime;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public boolean isTimedOut() throws SessionException {
        if (this.timedOutAt > 0L) {
            return true;
        }
        if (!cacheBasedPolling && this.maxCachingTimeReached()) {
            try {
                this.refresh(false);
            }
            catch (SessionTimedOutException e) {
                this.timedOutAt = this.latestRefreshTime = System.currentTimeMillis() / 1000L;
            }
        }
        return this.timedOutAt > 0L;
    }

    public long getTimeLeftBeforePurge() throws SessionException {
        if (!this.isTimedOut()) {
            return -1L;
        }
        long now = System.currentTimeMillis() / 1000L;
        long left = this.timedOutAt + purgeDelay * 60L - now;
        return left > 0L ? left : 0L;
    }

    public long getMaxCachingTime() {
        return this.maxCachingTime;
    }

    public long getIdleTime() throws SessionException {
        if (!cacheBasedPolling && this.maxCachingTimeReached()) {
            this.refresh(false);
        }
        return this.sessionIdleTime;
    }

    public long getTimeLeft() throws SessionException {
        if (!cacheBasedPolling && this.maxCachingTimeReached()) {
            this.refresh(false);
        }
        return this.sessionTimeLeft;
    }

    public int getState(boolean reset) throws SessionException {
        if (!cacheBasedPolling && this.maxCachingTimeReached()) {
            this.refresh(reset);
        } else if (reset) {
            this.needToReset = true;
        }
        return this.sessionState;
    }

    private void setState(int state) {
        this.sessionState = state;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getProperty(String name) throws SessionException {
        if (name != lbCookieName && (!cacheBasedPolling && this.maxCachingTimeReached() || !this.sessionProperties.containsKey(name))) {
            this.refresh(false);
        }
        return (String)this.sessionProperties.get(name);
    }

    public String getPropertyWithoutValidation(String name) {
        if (Session.isServerMode()) {
            return (String)this.sessionProperties.get(name);
        }
        return null;
    }

    public void setProperty(String name, String value) throws SessionException {
        try {
            if (this.isLocal()) {
                this.sessionService.setProperty(this.sessionID, name, value);
            } else {
                SessionRequest sreq = new SessionRequest(6, this.sessionID.toString(), false);
                sreq.setPropertyName(name);
                sreq.setPropertyValue(value);
                if (Session.isServerMode() && InternalSession.isProtectedProperty(name)) {
                    SSOToken admSSOToken = SessionUtils.getAdminToken();
                    sreq.setRequester(RestrictedTokenContext.marshal(admSSOToken));
                    if (sessionDebug.messageEnabled()) {
                        sessionDebug.message("Session.setProperty: added admSSOToken in sreq to set externalProtectedProperty in remote server");
                    }
                }
                this.getSessionResponse(this.getSessionServiceURL(), sreq);
            }
            this.sessionProperties.put(name, value);
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    protected boolean maxCachingTimeReached() {
        long cachingtime = System.currentTimeMillis() / 1000L - this.latestRefreshTime;
        return cachingtime > this.maxCachingTime * 60L;
    }

    public URL getSessionServiceURL() throws SessionException {
        if (Session.isServerMode()) {
            return Session.getSessionServiceURL(this.sessionID);
        }
        if (this.sessionServiceURL == null) {
            this.sessionServiceURL = Session.getSessionServiceURL(this.sessionID);
        }
        return this.sessionServiceURL;
    }

    public void destroySession(Session session) throws SessionException {
        try {
            if (session.isLocal()) {
                this.sessionService.destroySession(this, session.getID());
                Session.removeSID(session.getID());
            } else {
                SessionRequest sreq = new SessionRequest(2, this.sessionID.toString(), false);
                sreq.setDestroySessionID(session.getID().toString());
                session.getSessionResponse(session.getSessionServiceURL(), sreq);
            }
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
        finally {
            Session.removeSID(session.getID());
        }
    }

    public void logout() throws SessionException {
        try {
            if (this.isLocal()) {
                this.sessionService.logout(this.sessionID);
                Session.removeSID(this.sessionID);
            } else {
                SessionRequest sreq = new SessionRequest(3, this.sessionID.toString(), false);
                this.getSessionResponse(this.getSessionServiceURL(), sreq);
                Session.removeSID(this.sessionID);
            }
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    protected static void removeSID(SessionID sid) {
        Session session = null;
        session = (Session)((Object)sessionTable.remove(sid));
        if (session != null) {
            session.cancel();
            session.setState(3);
            long eventTime = System.currentTimeMillis();
            SessionEvent event = new SessionEvent(session, 5, eventTime);
            Session.invokeListeners(event);
        }
    }

    protected static void invokeListeners(SessionEvent evt) {
        SessionListener listener;
        int i;
        Session session = evt.getSession();
        Vector sess_listeners = session.getSessionEventListeners();
        Vector all_listeners = Session.getAllSessionEventListeners();
        for (i = 0; i < sess_listeners.size(); ++i) {
            listener = (SessionListener)sess_listeners.elementAt(i);
            listener.sessionChanged(evt);
        }
        for (i = 0; i < all_listeners.size(); ++i) {
            listener = (SessionListener)all_listeners.elementAt(i);
            listener.sessionChanged(evt);
        }
    }

    public void addSessionListener(SessionListener listener) throws SessionException {
        if (this.sessionState != 1) {
            throw new SessionException(SessionBundle.rbName, "invalidSessionState", null);
        }
        this.sessionEventListeners.addElement(listener);
    }

    public static Session getSession(SessionID sid) throws SessionException {
        if (sid.toString() == null || sid.toString().length() == 0) {
            throw new SessionException(SessionBundle.rbName, "invalidSessionID", null);
        }
        Session session = (Session)((Object)sessionTable.get(sid));
        if (session != null) {
            TokenRestriction restriction = session.getRestriction();
            try {
                if (Session.isServerMode() && restriction != null && !restriction.isSatisfied(RestrictedTokenContext.getCurrent())) {
                    throw new SessionException(SessionBundle.rbName, "restrictionViolation", null);
                }
            }
            catch (SessionException se) {
                throw se;
            }
            catch (Exception e) {
                throw new SessionException(e);
            }
            if (!cacheBasedPolling && session.maxCachingTimeReached()) {
                session.refresh(false);
            }
            return session;
        }
        session = new Session(sid);
        session.refresh(true);
        session.context = RestrictedTokenContext.getCurrent();
        sessionTable.put(sid, session);
        if (!Session.isPollingEnabled()) {
            session.addInternalSessionListener();
        }
        return session;
    }

    private void scheduleToTimerPool() {
        if (Session.isPollingEnabled()) {
            long timeoutTime = (this.latestRefreshTime + this.maxIdleTime * 60L) * 1000L;
            if (cacheBasedPolling) {
                timeoutTime = Math.min((this.latestRefreshTime + this.maxCachingTime * 60L) * 1000L, timeoutTime);
            }
            if (this.scheduledExecutionTime() > timeoutTime) {
                this.cancel();
            }
            if (this.scheduledExecutionTime() == -1L) {
                timerPool.schedule((TaskRunnable)this, new Date(timeoutTime));
            }
        } else if (sessionCleanupEnabled && this.maxSessionTime < 0x222222222222222L) {
            long timeoutTime = (this.latestRefreshTime + this.maxSessionTime * 60L) * 1000L;
            if (this.scheduledExecutionTime() > timeoutTime) {
                this.cancel();
            }
            if (this.scheduledExecutionTime() == -1L) {
                timerPool.schedule((TaskRunnable)this, new Date(timeoutTime));
            }
        }
    }

    public static SessionResponse sendPLLRequest(URL svcurl, SessionRequest sreq) throws SessionException {
        try {
            String cookies = cookieName + "=" + sreq.getSessionID();
            if (!Session.isServerMode()) {
                SessionID sessionID = new SessionID(sreq.getSessionID());
                cookies = cookies + ";" + Session.getLBCookie(sessionID);
            }
            Request req = new Request(sreq.toXMLString());
            RequestSet set = new RequestSet(SESSION_SERVICE);
            set.addRequest(req);
            Vector responses = PLLClient.send(svcurl, cookies, set);
            if (responses.size() != 1) {
                throw new SessionException(SessionBundle.rbName, "unexpectedResponse", null);
            }
            Response res = (Response)responses.elementAt(0);
            return SessionResponse.parseXML(res.getContent());
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    public SearchResults getValidSessions(String server, String pattern) throws SessionException {
        String protocol = this.sessionID.getSessionServerProtocol();
        String host = server;
        String port = this.sessionID.getSessionServerPort();
        String uri = this.sessionID.getSessionServerURI();
        int pos = host.indexOf("://");
        if (pos != -1) {
            protocol = host.substring(0, pos);
            host = host.substring(pos + 3);
        }
        if ((pos = host.indexOf(":")) != -1) {
            port = host.substring(pos + 1);
            host = host.substring(0, pos);
            int pos1 = port.indexOf("/");
            if (pos1 != -1) {
                uri = port.substring(pos1);
                port = port.substring(0, pos1);
            }
        }
        URL svcurl = Session.getSessionServiceURL(protocol, host, port, uri);
        return this.getValidSessions(svcurl, pattern);
    }

    Vector getSessionEventListeners() {
        return this.sessionEventListeners;
    }

    static Vector getAllSessionEventListeners() {
        return allSessionEventListeners;
    }

    public static URL getSessionServiceURL(SessionID sid) throws SessionException {
        String primary_id = null;
        if (Session.isServerMode()) {
            SessionService ss = SessionService.getSessionService();
            if (ss.isSiteEnabled() && ss.isLocalSite(sid)) {
                if (ss.isSessionFailoverEnabled()) {
                    return Session.getSessionServiceURL(ss.getCurrentHostServer(sid));
                }
                primary_id = sid.getExtension("S1");
                return Session.getSessionServiceURL(primary_id);
            }
        } else {
            primary_id = sid.getExtension("S1");
            if (primary_id != null) {
                String secondarysites = WebtopNaming.getSecondarySites(primary_id);
                String serverID = Session.getAMServerID();
                if (secondarysites != null && serverID != null && secondarysites.indexOf(serverID) != -1) {
                    return Session.getSessionServiceURL(serverID);
                }
            }
        }
        return Session.getSessionServiceURL(sid.getSessionServerProtocol(), sid.getSessionServer(), sid.getSessionServerPort(), sid.getSessionServerURI());
    }

    public static URL getSessionServiceURL(String protocol, String server, String port, String uri) throws SessionException {
        String key = protocol + "://" + server + ":" + port + uri;
        URL url = (URL)sessionServiceURLTable.get(key);
        if (url == null) {
            try {
                url = WebtopNaming.getServiceURL(SESSION_SERVICE, protocol, server, port, uri);
                sessionServiceURLTable.put(key, url);
                return url;
            }
            catch (Exception e) {
                throw new SessionException(e);
            }
        }
        return url;
    }

    public static URL getSessionServiceURL(String serverID) throws SessionException {
        try {
            URL parsedServerURL = new URL(WebtopNaming.getServerFromID(serverID));
            return Session.getSessionServiceURL(parsedServerURL.getProtocol(), parsedServerURL.getHost(), Integer.toString(parsedServerURL.getPort()), parsedServerURL.getPath());
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    private SearchResults getValidSessions(URL svcurl, String pattern) throws SessionException {
        try {
            int[] status = new int[]{0};
            Vector infos = null;
            if (this.sessionService != null && this.sessionService.isLocalSessionService(svcurl)) {
                infos = this.sessionService.getValidSessions(this, pattern, status);
            } else {
                SessionRequest sreq = new SessionRequest(1, this.sessionID.toString(), false);
                if (pattern != null) {
                    sreq.setPattern(pattern);
                }
                SessionResponse sres = this.getSessionResponseWithoutRetry(svcurl, sreq);
                infos = sres.getSessionInfoVector();
                status[0] = sres.getStatus();
            }
            Hashtable<String, Session> sessions = new Hashtable<String, Session>();
            int infoSize = infos.size();
            Session session = null;
            for (int i = 0; i < infoSize; ++i) {
                SessionInfo info = (SessionInfo)infos.elementAt(i);
                SessionID sid = new SessionID(info.sid);
                session = new Session(sid);
                session.sessionServiceURL = svcurl;
                session.update(info);
                sessions.put(info.sid, session);
            }
            return new SearchResults(sessions.size(), sessions.keySet(), status[0], sessions);
        }
        catch (Exception e) {
            sessionDebug.error("Session:getValidSession : ", (Throwable)e);
            throw new SessionException(SessionBundle.rbName, "getValidSessionsError", null);
        }
    }

    public void addSessionListenerOnAllSessions(SessionListener listener) throws SessionException {
        if (!Session.isPollingEnabled()) {
            try {
                String url = WebtopNaming.getNotificationURL().toString();
                if (this.sessionService == null) {
                    throw new SessionException(SessionBundle.rbName, "unsupportedFunction", null);
                }
                this.sessionService.addSessionListenerOnAllSessions(this, url);
            }
            catch (Exception e) {
                throw new SessionException(e);
            }
        }
        allSessionEventListeners.addElement(listener);
    }

    public void refresh(final boolean reset) throws SessionException {
        this.sessionIsLocal = this.checkSessionLocal();
        Object activeContext = RestrictedTokenContext.getCurrent();
        if (activeContext == null) {
            activeContext = this.context;
        }
        try {
            RestrictedTokenContext.doUsing(activeContext, new RestrictedTokenAction(){

                public Object run() throws Exception {
                    Session.this.doRefresh(reset);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Session.removeSID(this.sessionID);
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("session.Refresh Removed SID:" + this.sessionID);
            }
            throw new SessionException(e);
        }
    }

    private void doRefresh(boolean reset) throws SessionException {
        SessionInfo info = null;
        boolean flag = reset || this.needToReset;
        this.needToReset = false;
        if (this.isLocal()) {
            info = this.sessionService.getSessionInfo(this.sessionID, flag);
        } else {
            SessionRequest sreq = new SessionRequest(0, this.sessionID.toString(), flag);
            SessionResponse sres = this.getSessionResponse(this.getSessionServiceURL(), sreq);
            if (sres.getException() != null) {
                throw new SessionException(SessionBundle.rbName, "invalidSessionState", null);
            }
            Vector infos = sres.getSessionInfoVector();
            if (infos.size() != 1) {
                throw new SessionException(SessionBundle.rbName, "unexpectedSession", null);
            }
            info = (SessionInfo)infos.elementAt(0);
        }
        long oldMaxCachingTime = this.maxCachingTime;
        long oldMaxIdleTime = this.maxIdleTime;
        long oldMaxSessionTime = this.maxSessionTime;
        this.update(info);
        if (this.scheduledExecutionTime() == -1L || oldMaxCachingTime > this.maxCachingTime || oldMaxIdleTime > this.maxIdleTime || oldMaxSessionTime > this.maxSessionTime) {
            this.scheduleToTimerPool();
        }
    }

    synchronized void update(SessionInfo info) throws SessionException {
        String sessionTimedOutProp;
        if (info.stype.equals("user")) {
            this.sessionType = 0;
        } else if (info.stype.equals("application")) {
            this.sessionType = 1;
        }
        this.clientID = info.cid;
        this.clientDomain = info.cdomain;
        this.maxSessionTime = Long.parseLong(info.maxtime);
        this.maxIdleTime = Long.parseLong(info.maxidle);
        this.maxCachingTime = Long.parseLong(info.maxcaching);
        this.sessionIdleTime = Long.parseLong(info.timeidle);
        this.sessionTimeLeft = Long.parseLong(info.timeleft);
        if (info.state.equals("invalid")) {
            this.sessionState = 0;
        } else if (info.state.equals("valid")) {
            this.sessionState = 1;
        } else if (info.state.equals("inactive")) {
            this.sessionState = 2;
        } else if (info.state.equals("destroyed")) {
            this.sessionState = 3;
        }
        this.sessionProperties = info.properties;
        if (this.timedOutAt <= 0L && (sessionTimedOutProp = (String)this.sessionProperties.get("SessionTimedOut")) != null) {
            try {
                this.timedOutAt = Long.parseLong(sessionTimedOutProp);
            }
            catch (NumberFormatException e) {
                sessionDebug.error("Invalid timeout value " + sessionTimedOutProp, (Throwable)e);
            }
        }
        this.latestRefreshTime = System.currentTimeMillis() / 1000L;
        String restrictionProp = (String)this.sessionProperties.get(TOKEN_RESTRICTION_PROP);
        if (restrictionProp != null) {
            try {
                this.restriction = TokenRestrictionFactory.unmarshal(restrictionProp);
            }
            catch (Exception e) {
                throw new SessionException(e);
            }
        }
    }

    private void createContext(SSOToken appSSOToken) throws SessionException {
        if (appSSOToken == null) {
            if (sessionDebug.warningEnabled()) {
                sessionDebug.warning("Session.createContext():, cannot obtain application SSO token, defaulting to IP address");
            }
        } else {
            sessionDebug.message("Session.createContext():, setting context to  application SSO token");
            this.context = appSSOToken;
        }
    }

    private SessionResponse getSessionResponseWithoutRetry(URL svcurl, SessionRequest sreq) throws SessionException {
        SessionResponse sres = null;
        this.context = RestrictedTokenContext.getCurrent();
        SSOToken appSSOToken = null;
        if (!Session.isServerMode() && !this.sessionID.getComingFromAuth()) {
            appSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            this.createContext(appSSOToken);
        } else {
            this.context = null;
        }
        try {
            if (this.context != null) {
                sreq.setRequester(RestrictedTokenContext.marshal(this.context));
            }
            sres = Session.sendPLLRequest(svcurl, sreq);
            while (sres.getException() != null) {
                this.processSessionResponseException(sres, appSSOToken);
                if (this.context != null) {
                    sreq.setRequester(RestrictedTokenContext.marshal(this.context));
                }
                sres = Session.sendPLLRequest(svcurl, sreq);
            }
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
        return sres;
    }

    private void processSessionResponseException(SessionResponse sres, SSOToken appSSOToken) throws SessionException {
        block9: {
            try {
                if (sessionDebug.messageEnabled()) {
                    sessionDebug.message("Session.processSessionResponseException: exception received from server:" + sres.getException());
                }
                String exceptionMessage = sres.getException();
                if (this.timedOutAt <= 0L && exceptionMessage.indexOf("SessionTimedOutException") != -1) {
                    this.timedOutAt = System.currentTimeMillis() / 1000L;
                }
                if (exceptionMessage.indexOf(SessionBundle.getString("appTokenInvalid")) != -1) {
                    if (Session.isServerMode() || this.sessionID.getComingFromAuth()) break block9;
                    if (appSSOToken != null) {
                        SSOTokenManager tokenMgr = SSOTokenManager.getInstance();
                        try {
                            tokenMgr.destroyToken(appSSOToken);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (sessionDebug.warningEnabled()) {
                        sessionDebug.warning("Session.processSessionResponseException processSessionResponseException: server responded with app token invalid error,refetching the app sso token");
                    }
                    SSOToken newAppSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    this.createContext(newAppSSOToken);
                    break block9;
                }
                throw new SessionException(sres.getException());
            }
            catch (Exception e) {
                throw new SessionException(e);
            }
        }
    }

    private SessionResponse getSessionResponse(URL svcurl, SessionRequest sreq) throws SessionException {
        if (Session.isServerMode() && SessionService.getUseInternalRequestRouting()) {
            try {
                return this.getSessionResponseWithoutRetry(svcurl, sreq);
            }
            catch (SessionException e) {
                URL retryURL;
                String hostServer = this.sessionService.getCurrentHostServer(this.sessionID);
                if (!this.sessionService.checkServerUp(hostServer) && !(retryURL = this.getSessionServiceURL()).equals(svcurl)) {
                    return this.getSessionResponseWithoutRetry(retryURL, sreq);
                }
                throw e;
            }
        }
        return this.getSessionResponseWithoutRetry(svcurl, sreq);
    }

    private void addInternalSessionListener() {
        try {
            if (SessionNotificationHandler.handler == null) {
                SessionNotificationHandler.handler = new SessionNotificationHandler(sessionTable);
                PLLClient.addNotificationHandler(SESSION_SERVICE, SessionNotificationHandler.handler);
            }
            String url = WebtopNaming.getNotificationURL().toString();
            if (this.isLocal()) {
                this.sessionService.addSessionListener(this.sessionID, url);
            } else {
                SessionRequest sreq = new SessionRequest(4, this.sessionID.toString(), false);
                sreq.setNotificationURL(url);
                this.getSessionResponse(this.getSessionServiceURL(), sreq);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String encodeURL(HttpServletResponse res, String url) {
        return this.encodeURL(res, url, cookieName);
    }

    public String encodeURL(HttpServletResponse res, String url, String cookieName) {
        String httpEncodeUrl = res.encodeURL(url);
        return this.encodeURL(httpEncodeUrl, (short)0, true, cookieName);
    }

    public String encodeURL(String url, boolean escape) {
        return this.encodeURL(url, escape, cookieName);
    }

    public String encodeURL(String url, boolean escape, String cookieName) {
        return this.encodeURL(url, (short)0, escape);
    }

    public String encodeURL(String url) {
        return this.encodeURL(url, cookieName);
    }

    public String encodeURL(String url, String cookieName) {
        return this.encodeURL(url, (short)0, true, cookieName);
    }

    public String encodeURL(String url, short encodingScheme, boolean escape) {
        return this.encodeURL(url, encodingScheme, escape, cookieName);
    }

    public String encodeURL(String url, short encodingScheme, boolean escape, String cookieName) {
        String encodedURL = url;
        if (url != null && url.length() > 0 && !this.getCookieSupport()) {
            if (this.cookieStr != null && this.cookieStr.length() > 0 && Session.foundCookieName(this.cookieStr, cookieName)) {
                encodedURL = SessionEncodeURL.buildCookieString(url, this.cookieStr, encodingScheme, escape);
            } else if (this.sessionID != null) {
                this.cookieStr = SessionEncodeURL.createCookieString(cookieName, this.sessionID.toString());
                encodedURL = SessionEncodeURL.encodeURL(this.cookieStr, url, encodingScheme, escape);
            }
        }
        return encodedURL;
    }

    private boolean getCookieSupport() {
        boolean cookieSupport = false;
        try {
            Boolean cookieMode = this.sessionID.getCookieMode();
            if (cookieMode != null) {
                cookieSupport = cookieMode;
            } else if (this.cookieMode != null) {
                cookieSupport = this.cookieMode;
            } else {
                String cookieSupportStr = this.getProperty("cookieSupport");
                if (cookieSupportStr != null) {
                    cookieSupport = cookieSupportStr.equals("true");
                }
            }
        }
        catch (Exception ex) {
            sessionDebug.error("Error getting cookieSupport value: ", (Throwable)ex);
            cookieSupport = true;
        }
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("Session: getCookieSupport: " + cookieSupport);
        }
        return cookieSupport;
    }

    public void setCookieMode(Boolean cookieMode) {
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("CookieMode is:" + cookieMode);
        }
        if (cookieMode != null) {
            this.cookieMode = cookieMode;
        }
    }

    boolean isLocal() {
        return this.sessionIsLocal;
    }

    public static void markNonLocal(SessionID sid) {
        Session sess = (Session)((Object)sessionTable.get(sid));
        if (sess != null) {
            sess.sessionIsLocal = false;
        }
    }

    private boolean checkSessionLocal() throws SessionException {
        if (Session.isServerMode()) {
            return this.sessionService.checkSessionLocal(this.sessionID);
        }
        return false;
    }

    private TokenRestriction getRestriction() throws SessionException {
        return this.restriction;
    }

    Object getContext() {
        return this.context;
    }

    static boolean isServerMode() {
        return SystemProperties.isServerMode();
    }

    public static boolean foundCookieName(String cookieStr, String cookieName) {
        boolean foundCookieName = false;
        String cookieNameInStr = null;
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("CookieNameStr is :" + cookieNameInStr);
            sessionDebug.message("cookieName is :" + cookieName);
        }
        if (cookieStr != null && cookieStr.length() != 0) {
            cookieNameInStr = cookieStr.substring(0, cookieStr.indexOf("="));
        }
        if (cookieNameInStr != null && cookieNameInStr.equals(cookieName)) {
            foundCookieName = true;
        }
        return foundCookieName;
    }

    static {
        sessionDebug = Debug.getInstance((String)"amSession");
        pollingEnabled = false;
        pollerPoolInitialized = false;
        sessionCleanupEnabled = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.client.cleanup.enable", "true"));
        sessionTable = new Hashtable();
        sessionServiceURLTable = new Hashtable();
        allSessionEventListeners = new Vector();
        timerPool = null;
        threadPool = null;
        cacheBasedPolling = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.client.polling.cacheBased", "false"));
        String purgeDelayProperty = SystemProperties.get("com.iplanet.am.session.purgedelay", "120");
        try {
            purgeDelay = Long.parseLong(purgeDelayProperty);
        }
        catch (Exception le) {
            purgeDelay = 120L;
        }
        String appSSOTokenRefreshTimeProperty = SystemProperties.get("com.iplanet.am.client.appssotoken.refreshtime", "3");
        try {
            appSSOTokenRefreshTime = Long.parseLong(appSSOTokenRefreshTimeProperty);
        }
        catch (Exception le) {
            appSSOTokenRefreshTime = 3L;
        }
        if (pollingEnabled || sessionCleanupEnabled) {
            timerPool = SystemTimerPool.getTimerPool();
        }
    }

    class SessionPollerSender
    implements Runnable {
        SessionInfo info = null;
        Session session = null;
        SessionID sid = null;
        Debug debug = null;

        public SessionPollerSender(Session sess, Debug sessionDebug) {
            this.session = sess;
            this.sid = this.session.getID();
            this.debug = sessionDebug;
        }

        public void run() {
            block11: {
                try {
                    SessionRequest sreq = new SessionRequest(0, this.sid.toString(), false);
                    SessionResponse sres = Session.sendPLLRequest(this.session.getSessionServiceURL(), sreq);
                    if (sres.getException() != null) {
                        Session.removeSID(this.sid);
                        return;
                    }
                    Vector infos = sres.getSessionInfoVector();
                    this.info = (SessionInfo)infos.elementAt(0);
                }
                catch (Exception ex) {
                    Session.removeSID(this.sid);
                    if (!this.debug.messageEnabled()) break block11;
                    this.debug.message("Could not connect to the session server" + ex.getMessage());
                }
            }
            if (this.info != null) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("Updating" + this.info.toXMLString());
                }
                try {
                    if (this.info.state.equals("invalid") || this.info.state.equals("destroyed")) {
                        Session.removeSID(this.sid);
                    } else {
                        long oldMaxCachingTime = this.session.maxCachingTime;
                        long oldMaxIdleTime = this.session.maxIdleTime;
                        long oldMaxSessionTime = this.session.maxSessionTime;
                        this.session.update(this.info);
                        if (Session.this.scheduledExecutionTime() == -1L || oldMaxCachingTime > this.session.maxCachingTime || oldMaxIdleTime > this.session.maxIdleTime || oldMaxSessionTime > this.session.maxSessionTime) {
                            Session.this.scheduleToTimerPool();
                        }
                    }
                }
                catch (SessionException se) {
                    Session.removeSID(this.sid);
                    this.debug.error("Exception encountered while update in polling", (Throwable)((Object)se));
                }
            } else {
                Session.removeSID(this.sid);
            }
            this.session.setIsPolling(false);
        }
    }
}

